<?php

namespace App\Http\Controllers\admin;

use App\Models\Faq;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Storage;

class FaqController extends Controller
{
    public function index()
    {
        $faqs = Faq::latest()->get();
        return view('admin.faq.faqs',compact('faqs'));
    }


    public function create()
    {
        $modalContent = view('admin.faq.create_faq' )->render();

        return response()->json(['modalContent' => $modalContent]);
    }


    public function store(Request $request)
    {

        $request->validate([
            'question_ar' => 'required|string|max:255',
            'question_en' => 'required|string|max:255',
            'answer_ar'   => 'required|string',
            'answer_en'   => 'required|string',
        ]);
        Faq::create([
            'question_ar' => $request->question_ar,
            'question_en' => $request->question_en,
            'answer_ar'   => $request->answer_ar,
            'answer_en'   => $request->answer_en,
            'categories'  => $request->categories ,
        ]);
        $notification = trans('Created Successfully');
        return response()->json(['redirect_url' => route('faq.index'),
        'notification' => $notification ]
    );
    }

    public function edit($id)
    {
        $faq = Faq::find($id);

        $modalContent = view('admin.faq.edit_faq',compact('faq'))->render();
        return response()->json(['modalContent' => $modalContent]);

    }


    public function update(Request $request,$id)
    {
        $faq = Faq::find($id);
        $request->validate([
            'question_ar' => 'required|string|max:255',
            'question_en' => 'required|string|max:255',
            'answer_ar'   => 'required|string',
            'answer_en'   => 'required|string',
        ]);
        $faq->update([
            'question_ar' => $request->question_ar,
            'question_en' => $request->question_en,
            'answer_ar'   => $request->answer_ar,
            'answer_en'   => $request->answer_en,
            'categories'  => $request->categories ,
        ]);
        $notification = trans('Updated Successfully');
        return response()->json(['redirect_url' => route('faq.index'),
        'notification' => $notification ]
    );
    }

    public function destroy($id)
    {
        $faq = Faq::find($id);
        $faq->delete();
        $notification = trans('Delete Successfully');
        $notification = array('messege'=>$notification,'alert-type'=>'success');
        return redirect()->route('faq.index')->with($notification);
    }

    public function changeStatus($id){
        $faq = Faq::find($id);
            if($faq->status== 1){
                $faq->status= 0;
                $faq->save();
                $message = trans('Inactive Successfully');
            }else{
                $faq->status= 1;
                $faq->save();
                $message= trans('Active Successfully');
            }
            return response()->json($message);
    }

}
