<?php

namespace App\Http\Controllers\admin;

use App\Models\Feature;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Storage;

class FeatureController extends Controller
{
    public function index()
    {
        $features = Feature::latest()->get();
        return view('admin.feature.features',compact('features'));
    }


    public function create()
    {
        $modalContent = view('admin.feature.create_feature' )->render();

        return response()->json(['modalContent' => $modalContent]);
    }


    public function store(Request $request)
    {

        $validated = $request->validate([
            'title_ar' => 'required|string|max:1000',
            'title_en' => 'required|string|max:1000',
            'body_ar' => 'nullable|string|max:10000',
            'body_en' => 'nullable|string|max:10000',
        ]);
        feature::create($validated);
        $notification = trans('Created Successfully');
        return response()->json(['redirect_url' => route('feature.index'),
        'notification' => $notification ]
    );
    }

    public function edit($id)
    {
        $feature = Feature::find($id);

        $modalContent = view('admin.feature.edit_feature',compact('feature'))->render();
        return response()->json(['modalContent' => $modalContent]);

    }


    public function update(Request $request,$id)
    {
        $feature = Feature::find($id);
        $validated = $request->validate([
            'title_ar' => 'required|string|max:1000',
            'title_en' => 'required|string|max:1000',
            'body_ar' => 'nullable|string|max:10000',
            'body_en' => 'nullable|string|max:10000',
        ]);
        $feature->update($validated);
        $notification = trans('Updated Successfully');
        return response()->json(['redirect_url' => route('feature.index'),
        'notification' => $notification ]
    );
    }

    public function destroy($id)
    {
        $feature = Feature::find($id);
        $feature->delete();
        $notification = trans('Delete Successfully');
        $notification = array('messege'=>$notification,'alert-type'=>'success');
        return redirect()->route('feature.index')->with($notification);
    }

}
