<?php

namespace App\Http\Controllers\admin;

use App\Models\Order;
use App\Models\Language;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Storage;

class OrderController extends Controller
{
    public function index(Request $request)
    {
        if ($request->ajax()) {
            $draw = $request->get('draw');

            $start = $request->get("start");
            $rowperpage = $request->get("length"); // Rows display per page
            $search_arr = $request->get('search');
            $searchValue = $search_arr['value']; // Search value
            $totalRecords = Order::select('count(*) as allcount')->count();
                        $totalRecordswithFilter = Order::select('count(*) as allcount')->where('name', 'like', '%' . $searchValue . '%')->orwhere('phone', 'like', '%' . $searchValue . '%')->orwhere('email', 'like', '%' . $searchValue . '%')->count();
            $type= $request->type;
            $status= $request->status;

            $orders = Order::select('orders.*')
                ->when($searchValue != null, function ($q) use ($searchValue) {
                    $q->where('name', 'like', '%' . $searchValue . '%')
                    ->orwhere('phone', 'like', '%' . $searchValue . '%') ;
                })
                ->when($type != null, function ($q) use ($type) {
                    $q->where('type', $type);
                })
                ->when($status != null, function ($q) use ($status) {
                    $q->where('status', $status);
                })
                ->skip($start)
                ->take($rowperpage)
                ->orderBy('orders.id', 'desc')
                ->get();

            $records = [];

            foreach($orders as $order)
            {
                if($order->type == 'service'){
                    $type = $order->relatedName() ?? '<span class="badge badge-light-primary">خدمة</span>'  ;
                }elseif($order->type == 'plan'){
                    $type = $order->relatedName() ?? '<span class="badge badge-light-secondary">باقة</span>' ;
                }else{
                    $type ='<span class="badge badge-light-info">إستشارة</span>' ;
                }
                if($order->status == 'new'){
                    $status ='<span class="badge badge-glow bg-info">جديد</span>';
                }elseif($order->status == 'urgent'){
                    $status = '<span class="badge badge-glow bg-warning">مستعجل</span>';
                }elseif($order->status == 'Completed'){
                    $status = '<span class="badge badge-glow bg-success">مكتمل</span>';
                }elseif($order->status == 'Cancelled'){
                    $status = '<span class="badge badge-glow bg-danger">ملغي</span>';
                }elseif($order->status == 'under_review'){
                    $status = '<span class="badge badge-glow bg-secondary">تحت المراجعة</span>';
                }
                if($order->is_featured == 1){
                    $is_featured = '<span class="badge bg-success"> <i data-feather="star" class="me-25"></i> s</span>' ;

                }

                $records[] = [
                       'name' => $order->name ?? ''. $is_featured ?? '',
                       'phone' =>$order->phone ,
                       'email' => $order->email ?? '',
                       'type'=>$type ?? '',
                       'status'=>$status ?? '',
                       'notes'=>$order->notes ?? '',
                       'actions' => view('admin.order.buttons',[ 'order' => $order ])->render() ,
                    ];
            }

            $response = [
                        "draw" => intval($draw),
                        "iTotalRecords" => $totalRecords,
                        "iTotalDisplayRecords" => $totalRecordswithFilter,
                        "aaData" => $records
                    ];

            return response()->json($response);

        }
        $orders = Order::latest()->get();
        $total = Order::select('count(*) as allcount')->count();
        return view('admin.order.orders',[
            'orders' => $orders,
            'total' => $total,
        ]);

        // $contacts = Contact::latest()->get();
        // return view('admin.contact.contacts',compact('contacts'));
    }

    public function edit($id)
    {
        $order = Order::find($id);

        $modalContent = view('admin.order.edit',compact('order'))->render();
        return response()->json(['modalContent' => $modalContent]);

    }


    public function update(Request $request,$id)
    {
        $order = Order::find($id);
        $validated = $request->validate([
            'status' => 'required|string|max:255',
            'notes' => 'nullable|string|max:10000',
            'is_featured' => 'nullable',

        ]);
        $order->update($validated);

        $notification = trans('تم التعديل بنجاح');
        return response()->json(['redirect_url' => route('orders'),
        'notification' => $notification ]);
    }

    public function destroy($id)
    {
        $order = Order::find($id);
        $order->delete();
        $notification = trans('تم الحذف');
        $notification = array('messege'=>$notification,'alert-type'=>'success');
        return redirect()->route('orders')->with($notification);
    }

}
