<?php

namespace App\Http\Controllers\admin;

use App\Models\Plan;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Storage;

class PlanController extends Controller
{
    public function index()
    {
        $plans = Plan::latest()->get();
        return view('admin.plan.plans',compact('plans'));
    }


    public function create()
    {
        $modalContent = view('admin.plan.create_plan' )->render();

        return response()->json(['modalContent' => $modalContent]);
    }


    public function store(Request $request)
    {
        $validated = $request->validate([
            'title_ar'        => 'required|string|max:255',
            'title_en'        => 'required|string|max:255',
            'description_ar'  => 'required|string',
            'description_en'  => 'required|string',
            'image'           => 'nullable|mimes:jpg,jpeg,png,webp,svg|max:2048',
            'monthly_price'   => 'nullable|numeric',
            'yearly_price'    => 'nullable|numeric',
            'monthly_old_price'    => 'nullable|string|max:255',
            'yearly_old_price'    => 'nullable|string|max:255',
            'popular'         => 'nullable',
            'features'        => 'nullable|array',
            'features.*'      => 'exists:features,id',
            'categories'      => 'nullable|array',
            'categories.*'    => 'in:' . implode(',', Plan::categoriesList()),
        ]);
        if($request->hasFile('image') && $request->file('image')->isValid()){
            $validated['image'] = $request->file('image')->store('/','files');
        }
        Plan::create($validated);
        $notification = trans('Created Successfully');
        return response()->json(['redirect_url' => route('plan.index'),
        'notification' => $notification ]
    );
    }

    public function edit($id)
    {
        $plan = Plan::find($id);

        $modalContent = view('admin.plan.edit_plan',compact('plan'))->render();
        return response()->json(['modalContent' => $modalContent]);

    }


    public function update(Request $request,$id)
    {
        $plan = Plan::find($id);
        $validated = $request->validate([
            'title_ar'        => 'required|string|max:255',
            'title_en'        => 'required|string|max:255',
            'description_ar'  => 'required|string',
            'description_en'  => 'required|string',
            'image'           => 'nullable|mimes:jpg,jpeg,png,webp,svg|max:2048',
            'monthly_price'   => 'nullable|numeric',
            'yearly_price'    => 'nullable|numeric',
            'monthly_old_price'    => 'nullable|string|max:255',
            'yearly_old_price'    => 'nullable|string|max:255',
            'popular'         => 'nullable',
            'features'        => 'nullable|array',
            'features.*'      => 'exists:features,id',
            'categories'      => 'nullable|array',
            'categories.*'    => 'in:' . implode(',', Plan::categoriesList()),
        ]);
        if($request->hasFile('image') && $request->file('image')->isValid()){
            if($plan->image)
                Storage::disk('files')->delete($plan->image);
            $validated['image'] = $request->file('image')->store('/','files');
        }
        $plan->update($validated);
        $notification = trans('Updated Successfully');
        return response()->json(['redirect_url' => route('plan.index'),
        'notification' => $notification ]
    );
    }

    public function destroy($id)
    {
        $plan = Plan::find($id);
        $plan->delete();
        $notification = trans('Delete Successfully');
        $notification = array('messege'=>$notification,'alert-type'=>'success');
        return redirect()->route('plan.index')->with($notification);
    }
    public function changeStatus($id){
        $plan = Plan::find($id);
            if($plan->status== 1){
                $plan->status= 0;
                $plan->save();
                $message = trans('Inactive Successfully');
            }else{
                $plan->status= 1;
                $plan->save();
                $message= trans('Active Successfully');
            }
            return response()->json($message);
    }
}
