<?php

namespace App\Http\Controllers\Admin;

use App\Models\User;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Storage;
use Illuminate\Validation\Rules;

class UserController extends Controller
{
    public function index()
    {
        $users = User::where('role','user')->latest()->get();
        return view('admin.user.users',compact('users' ));
    }

    public function show($id){

        $user = User::find($id);
        return view('admin.user.show',compact('user' ));

    }

    public function create()
    {
        $modalContent = view('admin.user.create_user')->render();

        return response()->json(['modalContent' => $modalContent]);
    }


    public function store(Request $request)
    {

        // التحقق من المدخلات
        $validated = $request->validate([
            'name' => 'required|string|max:255',
            'phone' => 'required|string|max:13|min:10',
            'email' => 'required|string|lowercase|email|max:255|unique:'.User::class ,
            'password' =>  'required|confirmed', Rules\Password::defaults() ,
        ] );

        // إنشاء خدمة جديد
        User::create($validated);

        $notification = trans('dash.Created Successfully');
        return response()->json(['redirect_url' => route('admin.user.index'),
        'notification' => $notification ]
    );
    }

    public function edit($id)
    {
        $user = User::find($id);
            $modalContent = view('admin.user.edit_user',compact('user'))->render();
            return response()->json(['modalContent' => $modalContent]);

    }


    public function update(Request $request,$id)
    {
        $user = User::find($id);


        // التحقق من المدخلات
        $validated = $request->validate([
            'name' => 'required|string|max:255',
            'phone' => 'required|string|max:13|min:10',
            'email' => 'required|string|lowercase|email|max:255|unique:users,email,'. $user->id ,
        ] );

        // تحديث بيانات الخدمة
        $user->update($validated);

        $notification = trans('dash.Updated Successfully');
        return response()->json(['redirect_url' => route('admin.user.index'),
        'notification' => $notification ]
    );
    }

    public function destroy($id)
    {
        $user = User::find($id);
        $user->delete();
        $notification = trans('dash.Delete Successfully');
        $notification = array('messege'=>$notification,'alert-type'=>'success');
        return redirect()->route('admin.user.index')->with($notification);
    }

    public function changeStatus($id){
        $user = User::find($id);
            if($user->status=='active'){
                $user->status='inactive';
                $user->save();
                $message = trans('dash.Inactive Successfully');
            }else{
                $user->status='active';
                $user->save();
                $message= trans('dash.Active Successfully');
            }
            return response()->json($message);
    }
}
