<?php

namespace App\Http\Controllers\admin;

use App\Models\Work;
use App\Models\Language;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Storage;

class WorkController extends Controller
{
    public function index()
    {
        $works = Work::latest()->get();
        return view('admin.work.works',compact('works'));
    }


    public function create()
    {
        $languages = Language::orderBy('name')->pluck('name', 'id')->toArray();

        return view('admin.work.create',compact('languages'));

    }


    public function store(Request $request)
    {
        $validated = $request->validate([
            'title' => 'required|string|max:255',
            'category' => 'required|string|max:255',
            'image' => 'nullable|mimes:jpg,jpeg,png,webp|max:2048',
            'content' => 'required|string',
            'seo' => 'nullable|string|max:10000',
            'status' => 'nullable',
            'language_id' => 'exists:languages,id',

        ]);

        if($request->hasFile('image') && $request->file('image')->isValid()){
            $validated['image'] = $request->file('image')->store('/','files');
        }
        Work::create($validated);

        $notification = trans(' Create Successfully');
        $notification = array('messege'=>$notification,'alert-type'=>'success');
        return redirect()->back()->with($notification);
    }

    public function edit($id)
    {
        $work = Work::find($id);
        $languages = Language::orderBy('name')->pluck('name', 'id')->toArray();

        return view('admin.work.edit',compact('work','languages'));

    }


    public function update(Request $request,$id)
    {
        $work = Work::find($id);
        $validated = $request->validate([
            'title' => 'required|string|max:255',
            'category' => 'required|string|max:255',
            'image' => 'nullable|mimes:jpg,jpeg,png,webp|max:2048',
            'content' => 'required|string',
            'seo' => 'nullable|string|max:10000',
            'status'         => 'nullable',
            'language_id' => 'exists:languages,id',

        ]);
        $validated['image']= $work->image;
        if($request->hasFile('image') && $request->file('image')->isValid()){
            if($work->image)
                Storage::disk('files')->delete($work->image);
            $validated['image'] = $request->file('image')->store('/','files');
        }
        $work->update($validated);

        $notification = trans(' Update Successfully');
        $notification = array('messege'=>$notification,'alert-type'=>'success');
        return redirect()->back()->with($notification);
    }

    public function destroy($id)
    {
        $work = Work::find($id);
        if($work->image)
                Storage::disk('files')->delete($work->image);

        $work->delete();
        $notification = trans('dash.Delete Successfully');
        $notification = array('messege'=>$notification,'alert-type'=>'success');
        return redirect()->route('work.index')->with($notification);
    }
}
