<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Plan extends Model
{
    protected $guarded = [];
    protected $casts = [
        'features' => 'array',
        'categories' => 'array',
    ];

    public static function categoriesList(): array
{
    return [
        'Shared Hosting',
        'WordPress Hosting',
        'VPS Hosting',
        'Reseller Hosting',
        'Dedicated Hosting',
        'Cloud Hosting',
        'Public',
    ];
}

public function featuresList()
{
    return Feature::whereIn('id', $this->features ?? [])->get();
}
}
