@extends('Frontend.Layouts.app')
@section('title', __('lang.Opinion'))
@section('content')
    <!-- HEADER AREA -->
    @include('Frontend.Includes.navbar')
    <!-- HEADER AREA END -->
    <div class="site-content">

        <div class="container-fluid">
            <div class="item-efftect">
                <div class="efftect overflow-hidden"></div>
                <div class="efftect overflow-hidden"></div>
                <div class="efftect overflow-hidden"></div>
                <div class="efftect overflow-hidden"></div>
                <div class="efftect overflow-hidden"></div>
            </div>
        </div>

        <!--=================================
                  Page Header -->
        <div class="inner-header bg-holder" style="background-image: url({{ asset('front/images/head.jpg') }});">
            <div class="container">
                <div class="row  justify-content-center">
                    <div class="col-md-12 text-center">
                        <h1 class="title">{{ __('lang.What did they say about our work?') }}</h1>
                    </div>
                </div>
            </div>
        </div>

        <div class="content-wrapper">
            <!-- قسم آراء العملاء -->
            <section class="py-5 bg-light">
                <div class="container">
                    <div class="row justify-content-center mb-4">
                        <div class="col-md-10 section-title ">
                            <h6 class="text-muted sub-title">
                                <p>{{ __('lang.The words that truly make us happy are those that come from a customer who tried, was satisfied, and continued on the journey with us.') }}
                                </p>
                            </h6>
                            <h2 class="fw-bold">
                                {{ __('lang.Let us share with you some of the voices we are proud of.') }}

                            </h2>
                        </div>
                    </div>
                    <div class="row g-4">
                        @php
                            $opinions = App\Models\Opinion::latest()->get();
                        @endphp
                        @foreach ($opinions as $opinion)
                            <div class="col-md-6 col-lg-4">
                                <div class="border rounded-4 p-4 bg-white h-100">
                                    <p class="mb-3">
                                        {{ app()->getLocale() == 'ar' ? $opinion->content : $opinion->content_en }} </p>
                                    <h6 class="mb-0 fw-semibold">
                                        {{ app()->getLocale() == 'ar' ? $opinion->name : $opinion->name_en }} / <small
                                            class="text-muted">
                                            {{ app()->getLocale() == 'ar' ? $opinion->nickname : $opinion->nickname_en }}</small>
                                    </h6>
                                    <small class="text-muted">
                                        {{ app()->getLocale() == 'ar' ? $opinion->category : $opinion->category_en }}</small>
                                </div>
                            </div>
                        @endforeach


                    </div>
                </div>
            </section>


            @php
                $hsetting = App\Models\Home_setting::select(
                    'section10_subtitle',
                    'section10_title',
                    'section10_title_en',
                    'section10_subtitle_en',
                )->first();
            @endphp
            <section class="space-pt ellipse-top bg-black z-index-2">
                <div class="container">
                    <div class="row mb-lg-5">
                        <div class="col-xxl-6 col-lg-8">
                            <div class="section-title mb-lg-0">
                                <span
                                    class="sub-title">{{ app()->getLocale() == 'ar' ? $hsetting->section10_title : $hsetting->section10_title_en }}</span>
                                <h2 class="title mb-0">
                                    {{ app()->getLocale() == 'ar' ? $hsetting->section10_subtitle : $hsetting->section10_subtitle_en }}
                                </h2>
                            </div>
                        </div>
                        <div class="col-xxl-6 col-lg-4 align-self-end">
                            <div class="d-flex justify-content-center mt-5 ms-sm-5 ms-0">
                                <a class="btn btn-effect" href="{{ route('front.form') }}">
                                    <span>{{ __('lang.start now') }}</span>
                                    <svg width="20" height="22" viewBox="0 0 20 22" fill="none"
                                        xmlns="http://www.w3.org/2000/svg">
                                        <g clip-path="url(#clip0_59_253)">
                                            <path
                                                d="M19.4854 11.4293L17.0513 12.221C13.1214 13.4993 10.3036 16.9595 9.84784 21.0668C9.49371 16.981 6.71926 13.5081 2.81255 12.2604L0.210283 11.4293"
                                                stroke="white" stroke-width="2" />
                                            <path d="M9.83594 20.8889L9.83594 0" stroke="white" stroke-width="2" />
                                        </g>
                                        <defs>
                                            <clipPath id="clip0_59_253">
                                                <rect width="21.3333" height="20" fill="white"
                                                    transform="translate(20) rotate(90)" />
                                            </clipPath>
                                        </defs>
                                    </svg>
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </section>
        </div>
    </div>

    @include('Frontend.Includes.Footer')
    <!-- FOOTER AREA END -->
@endsection
