@extends('Frontend.Layouts.app')
@section('title', 'Home')
@section('content')
    <!-- HEADER AREA -->
    @include('Frontend.Includes.navbar')
    <!-- HEADER AREA END -->

    <div class="site-content">

        <div class="container-fluid">
            <div class="item-efftect">
                <div class="efftect overflow-hidden"></div>
                <div class="efftect overflow-hidden"></div>
                <div class="efftect overflow-hidden"></div>
                <div class="efftect overflow-hidden"></div>
                <div class="efftect overflow-hidden"></div>
            </div>
        </div>
        @php
            $setting = App\Models\Home_setting::first();
        @endphp
        <!--=================================
              Main Banner -->
        <div class="main-banner main-banner-3">
            <img class="img-fluid banner-bg"
                src="{{ asset('storage/files/' . ($setting->section1_image ?? 'default.png')) }}" alt="">
                
                    <div class="overlay"></div>
                    
            <div class="container-fluid g-md-0">
                <div class="banner-inner">
                    <div class="row">
                        <div class="col-md-12">
                            <div class="banner-conent">
                                <h2> {{ app()->getLocale() == 'ar' ? $setting->section1_title : $setting->section1_title_en }}
                                <!--</h2>{!! app()->getLocale() == 'ar' ? $setting->section1_content : $setting->section1_content_en !!}-->
                                <div class="banner-conent-footer">
                                    <a class=" custom-btn " href="{{route('front.services')}}" style="background: #990f8d; border: 1px solid #990f8d;"> 
                                        {{__('lang.Discover our services')}}
                                    </a>
                                    <a class=" custom-btn " href="{{route('front.form')}}">
                                        {{__('lang.Book a consultation')}}
                                    </a>

                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="content-wrapper">
            <section class="space-pt z-index-2">
                <div class="container">
                    <div class="row justify-content-between">
                        <div class="col-lg-7 mb-5 mb-lg-0">
                            <div class="section-title pb-0 pb-lg-4">
                                <span class="sub-title">
                                    {{ app()->getLocale() == 'ar' ? $setting->section2_title : $setting->section2_title_en }}</span>
                                <h2 class="title">
                                    {{ app()->getLocale() == 'ar' ? $setting->section2_subtitle : $setting->section2_subtitle_en }}
                                </h2>
                            </div>
                            <div class="row">
                                <div class="col-sm-8">
                                    {!! app()->getLocale() == 'ar' ? $setting->section2_content : $setting->section2_content_en !!}
                                    <div class="d-flex justify-content-center mt-5 ms-sm-5 ms-0">
                                        <a class="btn btn-effect" href="{{route('about')}}">
                                            <span> {{__('lang.More Details') }}</span>
                                            <svg width="20" height="22" viewBox="0 0 20 22" fill="none"
                                                xmlns="http://www.w3.org/2000/svg">
                                                <g clip-path="url(#clip0_59_253)">
                                                    <path
                                                        d="M19.4854 11.4293L17.0513 12.221C13.1214 13.4993 10.3036 16.9595 9.84784 21.0668C9.49371 16.981 6.71926 13.5081 2.81255 12.2604L0.210283 11.4293"
                                                        stroke="white" stroke-width="2" />
                                                    <path d="M9.83594 20.8889L9.83594 0" stroke="white" stroke-width="2" />
                                                </g>
                                                <defs>
                                                    <clipPath id="clip0_59_253">
                                                        <rect width="21.3333" height="20" fill="white"
                                                            transform="translate(20) rotate(90)" />
                                                    </clipPath>
                                                </defs>
                                            </svg>
                                        </a>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-5">
                            <img class="img-fluid  homeimg radius-20"
                                src="{{ asset('storage/files/' . ($setting->section2_image1 ?? 'default.png')) }}"
                                alt="#">
                        </div>
                    </div>
                </div>
            </section>

            <section class="space-ptb ellipse-bottom">
                <div class="container">
                    <div class="row">
                        <div class="col-md-4 mb-5 ">
                            <img class="img-fluid  radius-20 homeimg"
                                src="{{ asset('storage/files/' . ($setting->section3_image ?? 'default.png')) }}"
                                alt="#">
                        </div>
                        <div class="col-md-8">
                            <div class="section-title pe-xl-5">
                                <span class="sub-title"> </span>
                                <h2 class="title">
                                    {{ app()->getLocale() == 'ar' ? $setting->section3_title : $setting->section3_title_en }}
                                </h2>
                            </div>
                            <div class="ps-sm-5">
                                <div class="list-wrapper">
                                    {!! app()->getLocale() == 'ar' ? $setting->section3_content : $setting->section3_content_en !!}

                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </section>
            <section class="space-pt z-index-2 ">
                <div class="container">
                    <div class="row justify-content-between">
                        <div class="col-lg-7 mb-5 mb-lg-0">
                            <div class="section-title pb-0 pb-lg-4">
                                <span class="sub-title">
                                    {{ app()->getLocale() == 'ar' ? $setting->section4_title : $setting->section4_title_en }}</span>
                            </div>
                            <div class="row">
                                
                                <div class="col-sm-8">
                                    {!! app()->getLocale() == 'ar' ? $setting->section4_content : $setting->section4_content_en !!}

                                    <div class="d-flex justify-content-center mt-5 ms-sm-5 ms-0">
                                        <a class="btn btn-effect" href="{{route('about')}}">
                                            <span>{{__('lang.More Details') }}</span>
                                            <svg width="20" height="22" viewBox="0 0 20 22" fill="none"
                                                xmlns="http://www.w3.org/2000/svg">
                                                <g clip-path="url(#clip0_59_253)">
                                                    <path
                                                        d="M19.4854 11.4293L17.0513 12.221C13.1214 13.4993 10.3036 16.9595 9.84784 21.0668C9.49371 16.981 6.71926 13.5081 2.81255 12.2604L0.210283 11.4293"
                                                        stroke="white" stroke-width="2" />
                                                    <path d="M9.83594 20.8889L9.83594 0" stroke="white" stroke-width="2" />
                                                </g>
                                                <defs>
                                                    <clipPath id="clip0_59_253">
                                                        <rect width="21.3333" height="20" fill="white"
                                                            transform="translate(20) rotate(90)" />
                                                    </clipPath>
                                                </defs>
                                            </svg>
                                        </a>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-4">
                            <img class="img-fluid  homeimg radius-20"
                                src="{{ asset('storage/files/' . ($setting->section4_image2 ?? 'default.png')) }}"
                                alt="#">
                        </div>
                    </div>
                </div>
            </section>
            <section class="space-ptb ellipse-top ellipse-bottom">
                <div class="container">
                    <div class="row justify-content-start">
                        <div class="section-title pb-0 pb-lg-4">
                            <span class="sub-title">
                                {{ app()->getLocale() == 'ar' ? $setting->section5_title : $setting->section5_title_en }}
                            </span>
                            <span class="title">
                                {{ app()->getLocale() == 'ar' ? $setting->section5_subtitle : $setting->section5_subtitle_en }}
                            </span>
                        </div>
                        <div class="col-lg-12">
                            <div class="blog-items grid-wrapper grid-xl-3 grid-md-2 grid-sm-1">
                                @php
                                    if (app()->getLocale() == 'ar') {
                                        $works = App\Models\Work::where('status', 1)
                                            ->where('language_id', 2)
                                            ->latest()
                                            ->limit(3)
                                            ->get();
                                    } else {
                                        $works = App\Models\Work::where('status', 1)
                                            ->where('language_id', 1)
                                            ->latest()
                                            ->limit(3)
                                            ->get();
                                    }
                                @endphp
                                @foreach ($works as $work)
                                    <div class="blog-post-wrapper blog-style-1">
                                        <div class="blog-post-info">
                                            <h5 class="post-title"><a href="{{ route('front.work', $work->id) }}">
                                                    {{ $work->title }}</a></h5>
                                            <p class="post-title"> {{ $work->category }} </p>
                                        </div>
                                        <div class="blog-post-img"><img class="img-fluid"
                                                src="{{ asset('storage/files/' . ($work->image ?? 'default.png')) }}"
                                                alt=""></div>
                                    </div>
                                @endforeach



                                <div class="d-flex justify-content-center mt-5 ms-sm-5 ms-0">
                                    <a class="btn btn-effect" href="{{route('front.our_work')}}">
                                        <span>{{__('lang.See all projects')}}</span>
                                        <svg width="20" height="22" viewBox="0 0 20 22" fill="none"
                                            xmlns="http://www.w3.org/2000/svg">
                                            <g clip-path="url(#clip0_59_253)">
                                                <path
                                                    d="M19.4854 11.4293L17.0513 12.221C13.1214 13.4993 10.3036 16.9595 9.84784 21.0668C9.49371 16.981 6.71926 13.5081 2.81255 12.2604L0.210283 11.4293"
                                                    stroke="white" stroke-width="2" />
                                                <path d="M9.83594 20.8889L9.83594 0" stroke="white" stroke-width="2" />
                                            </g>
                                            <defs>
                                                <clipPath id="clip0_59_253">
                                                    <rect width="21.3333" height="20" fill="white"
                                                        transform="translate(20) rotate(90)" />
                                                </clipPath>
                                            </defs>
                                        </svg>
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
            </section>

            <!-- قسم آراء العملاء -->
            <section class="py-5 bg-light">
                <div class="container">
                    <div class="row justify-content-center mb-4">
                        <div class="col-md-10 section-title ">
                            <h6 class="text-muted sub-title">
                                {{ app()->getLocale() == 'ar' ? $setting->section6_title : $setting->section6_title_en }}
                            </h6>
                            <h2 class="fw-bold">
                                {{ app()->getLocale() == 'ar' ? $setting->section6_subtitle : $setting->section6_subtitle_en }}
                            </h2>
                        </div>
                    </div>
                    <div class="row g-4">
                        @php
                            $opinions = App\Models\Opinion::latest()->limit(6)->get();
                        @endphp
                        @foreach ($opinions as $opinion)
                            <div class="col-md-6 col-lg-4">
                                <div class="border rounded-4 p-4 bg-white h-100">
                                    <p class="mb-3">
                                        {{ app()->getLocale() == 'ar' ? $opinion->content : $opinion->content_en }} </p>
                                    <h6 class="mb-0 fw-semibold">
                                        {{ app()->getLocale() == 'ar' ? $opinion->name : $opinion->name_en }}</h6>
                                    <small class="text-muted">
                                        {{ app()->getLocale() == 'ar' ? $opinion->category : $opinion->category_en }}</small>
                                </div>
                            </div>
                        @endforeach


                    </div>
                    <div class="d-flex justify-content-center mt-5 ms-sm-5 ms-0">
                        <a class="btn btn-effect" href="{{route('front.Opinion')}}">
                            <span>{{__('lang.See More')}}</span>
                            <svg width="20" height="22" viewBox="0 0 20 22" fill="none"
                                xmlns="http://www.w3.org/2000/svg">
                                <g clip-path="url(#clip0_59_253)">
                                    <path
                                        d="M19.4854 11.4293L17.0513 12.221C13.1214 13.4993 10.3036 16.9595 9.84784 21.0668C9.49371 16.981 6.71926 13.5081 2.81255 12.2604L0.210283 11.4293"
                                        stroke="white" stroke-width="2" />
                                    <path d="M9.83594 20.8889L9.83594 0" stroke="white" stroke-width="2" />
                                </g>
                                <defs>
                                    <clipPath id="clip0_59_253">
                                        <rect width="21.3333" height="20" fill="white"
                                            transform="translate(20) rotate(90)" />
                                    </clipPath>
                                </defs>
                            </svg>
                        </a>
                    </div>
                </div>
            </section>



            <section class="space-pt">
                <div class="container">
                    <div class="row">
                        <div class="col-lg-5">
                            <div class="section-title">
                                <h2 class="title">
                                    {{ app()->getLocale() == 'ar' ? $setting->section8_title : $setting->section8_title_en }}
                                </h2>
                                <p class="title">
                                    {{ app()->getLocale() == 'ar' ? $setting->section8_subtitle : $setting->section8_subtitle_en }}
                                </p>
                            </div>
                            <div class="ps-xxl-5 ms-0 ms-md-5">
                                <a class="btn btn-effect" href="{{route('front.plans')}}">
                                    <span> {{__('lang.Browse packages')}}</span>
                                    <svg width="20" height="22" viewBox="0 0 20 22" fill="none"
                                        xmlns="http://www.w3.org/2000/svg">
                                        <g clip-path="url(#clip0_59_253)">
                                            <path
                                                d="M19.4854 11.4293L17.0513 12.221C13.1214 13.4993 10.3036 16.9595 9.84784 21.0668C9.49371 16.981 6.71926 13.5081 2.81255 12.2604L0.210283 11.4293"
                                                stroke="white" stroke-width="2" />
                                            <path d="M9.83594 20.8889L9.83594 0" stroke="white" stroke-width="2" />
                                        </g>
                                        <defs>
                                            <clipPath id="clip0_59_253">
                                                <rect width="21.3333" height="20" fill="white"
                                                    transform="translate(20) rotate(90)" />
                                            </clipPath>
                                        </defs>
                                    </svg>
                                </a>
                            </div>
                        </div>
                        @php
                            $plans = App\Models\Plan::where('status', 1)->latest()->limit(3)->get();
                            $allFeatures = App\Models\Feature::all();
                        @endphp
                        <div class="col-lg-7 ps-xxl-5">
                            <div class="pgs-accordion pgs-pricing ps-0 ps-lg-5 mt-5 mt-lg-0 mb-5">
                                @foreach ($plans as $index => $plan)
                                    <div class="accordion-item @if ($index == 0) is-active @endif">
                                        <div class="accordion-header">
                                            <div class="package-info">
                                                <span class="package-check"><i class="fa-solid fa-check"></i></span>
                                                <div class="package-name">
                                                    <h5 class="package-title">
                                                        {{ app()->getLocale() == 'ar' ? $plan->title_ar : $plan->title_en }}
                                                    </h5>
                                                    <span
                                                        class="package-discount">{{ app()->getLocale() == 'ar' ? $plan->description_ar : $plan->description_en }}</span>
                                                </div>
                                            </div>
                                            <div class="package-price">
                                                <img class="img-fluid" width="170"
                                                    src="{{ asset('storage/files/' . ($plan->image ?? 'default.png')) }}"
                                                    alt="logo">
                                            </div>
                                        </div>
                                        <div class="accordion-content">
                                            <div class="content-inner">
                                                <div class="pricing-lists">
                                                    <ul class="pricing-lists">
                                                        @foreach ($allFeatures as $feature)
                                                            @if (in_array($feature->id, $plan->features))
                                                                <li><i class="fa-regular fa-circle-check"></i>
                                                                    {{ app()->getLocale() == 'ar' ? $feature->title_ar : $feature->title_en }}
                                                                </li>
                                                            @endif
                                                        @endforeach
                                                    </ul>
                                                </div>
                                                <div class="pricing-link">
                                                    <a href="{{route('front.form')}}"><svg width="17" height="16"
                                                            viewBox="0 0 17 16" fill="none"
                                                            xmlns="http://www.w3.org/2000/svg">
                                                            <g clip-path="url(#clip0_923_1331)">
                                                                <path
                                                                    d="M8.70801 0.959961L9.29825 2.7665C10.2512 5.68321 12.8308 7.77453 15.8928 8.1128C12.8468 8.37564 10.2578 10.4348 9.3276 13.3343L8.70801 15.2657"
                                                                    stroke="inherit" stroke-width="1" />
                                                                <path d="M15.7602 8.12158H0.1875" stroke="inherit"
                                                                    stroke-width="1" />
                                                            </g>
                                                            <defs>
                                                                <clipPath id="clip0_923_1331">
                                                                    <rect width="15.904" height="14.8437" fill="inherit"
                                                                        transform="translate(0.1875 0.578125)" />
                                                                </clipPath>
                                                            </defs>
                                                        </svg></a>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                @endforeach

                            </div>
                        </div>
                    </div>
                </div>
            </section>

            <section class="py-5 bg-light">
                <div class="container">
                    <div class="row justify-content-center mb-4">
                        <div class="col-md-10 section-title ">
                            <h3 class="text-muted sub-title">
                                {{ app()->getLocale() == 'ar' ? $setting->section7_title : $setting->section7_title_en }}
                            </h3>
                            <p class="text-muted title">
                                {{ app()->getLocale() == 'ar' ? $setting->section7_title : $setting->section7_title_en }}
                            </p>
                        </div>
                    </div>
                    @php
                        if (app()->getLocale() == 'ar') {
                            $blogs = App\Models\Blog::where('popular', 1)
                                ->where('status', 1)
                                ->where('language_id', 2)
                                ->latest()
                                ->limit(3)
                                ->get();
                        } else {
                            $blogs = App\Models\Blog::where('popular', 1)
                                ->where('status', 1)
                                ->where('language_id', 1)
                                ->latest()
                                ->limit(3)
                                ->get();
                        }
                    @endphp
                    <div class="row g-4">
                        @foreach ($blogs as $blog)
                            <div class="col-4">
                                <div class="blog-post-wrapper blog-style-1">
                                    <div class="blog-post-img"><img class="img-fluid"
                                            src="{{ asset('storage/files/' . ($blog->image ?? 'default.png')) }}"
                                            alt=""></div>
                                    <div class="blog-post-info">
                                        <h5 class="post-title"><a href="{{ route('front.blog', $blog->id) }}">
                                                {{ $blog->title }}</a></h5>
                                        <p class="post-title"> {{ $blog->category }} </p>
                                    </div>
                                </div>
                            </div>
                        @endforeach
                    </div>
                    <div class="d-flex justify-content-center mt-5 ms-sm-5 ms-0">
                        <a class="btn btn-effect" href="{{route('front.blogs')}}">
                            <span>{{ __('lang.Enter the Knowledge Center') }}</span>
                            <svg width="20" height="22" viewBox="0 0 20 22" fill="none"
                                xmlns="http://www.w3.org/2000/svg">
                                <g clip-path="url(#clip0_59_253)">
                                    <path
                                        d="M19.4854 11.4293L17.0513 12.221C13.1214 13.4993 10.3036 16.9595 9.84784 21.0668C9.49371 16.981 6.71926 13.5081 2.81255 12.2604L0.210283 11.4293"
                                        stroke="white" stroke-width="2" />
                                    <path d="M9.83594 20.8889L9.83594 0" stroke="white" stroke-width="2" />
                                </g>
                                <defs>
                                    <clipPath id="clip0_59_253">
                                        <rect width="21.3333" height="20" fill="white"
                                            transform="translate(20) rotate(90)" />
                                    </clipPath>
                                </defs>
                            </svg>
                        </a>
                    </div>
                </div>
            </section>




            <!--=================================
                Contact Us -->
            <section class="space-ptb">
                <div class="container">
                    <div class="row">
                        <div class="col-lg-5 col-xl-6">
                            <div class="section-title ">
                                <span class="sub-title"><img class="img-fluid"
                                        src="{{ asset('front/images/subtitle-icon.png') }}" alt="">تواصل
                                    معنا</span>
                                <h2 class="title">
                                    {{ app()->getLocale() == 'ar' ? $setting->section9_title : $setting->section9_title_en }}
                                    </h6>
                                </h2>
                                <div class="social-icons" style="display: flex; gap: 40px;">
                                    <a href="{{ $setting->whatsapp }}" target="_blank" style="color: #25D366;">
                                        <i class="fab fa-whatsapp fa-lg"></i>
                                    </a>
                                    <a href="{{ $setting->facebook }}" target="_blank" style="color: #3b5998;">
                                        <i class="fab fa-facebook-f fa-lg"></i>
                                    </a>
                                    <a href="{{ $setting->twitter }}" target="_blank" style="color: #1DA1F2;">
                                        <i class="fab fa-twitter fa-lg"></i>
                                    </a>
                                    <a href="{{ $setting->instagram }}" target="_blank" style="color: #C13584;">
                                        <i class="fab fa-instagram fa-lg"></i>
                                    </a>
                                    <a href="{{ $setting->linkedin }}" target="_blank" style="color: #0077b5;">
                                        <i class="fab fa-linkedin-in fa-lg"></i>
                                    </a>
                                </div>
                            </div>
                            <div class="widget widget-address-info">
                                <ul class="address-info-list address-info-2">
                                    <li><i class="icon"><img class="img-fluid"
                                                src="{{ asset('front/images/svg/address-info-headphone.svg') }}"
                                                alt=""></i><span class="info"><span><a
                                                    href="tel:{{ $setting->phone }}">{{ $setting->phone }}</a> </li>
                                    <li><i class="icon"><img class="img-fluid"
                                                src="{{ asset('front/images/svg/address-info-email.svg') }}"
                                                alt=""></i><span class="info"><span><a
                                                    href="mailto:{{ $setting->email }}">{{ $setting->email }}</a></span>24x7
                                        </span></li>
                                </ul>

                            </div>


                            <p class="title mb-0">
                                {{ app()->getLocale() == 'ar' ? $setting->section9_subtitle : $setting->section9_subtitle_en }}
                            </p>
                            <div class="d-flex justify-content-center mt-5 ms-sm-5 ms-0">
                                <a class="btn btn-effect" href="#">
                                    <span> {{ __('lang.Book a consultation') }}</span>
                                    <svg width="20" height="22" viewBox="0 0 20 22" fill="none"
                                        xmlns="http://www.w3.org/2000/svg">
                                        <g clip-path="url(#clip0_59_253)">
                                            <path
                                                d="M19.4854 11.4293L17.0513 12.221C13.1214 13.4993 10.3036 16.9595 9.84784 21.0668C9.49371 16.981 6.71926 13.5081 2.81255 12.2604L0.210283 11.4293"
                                                stroke="white" stroke-width="2" />
                                            <path d="M9.83594 20.8889L9.83594 0" stroke="white" stroke-width="2" />
                                        </g>
                                        <defs>
                                            <clipPath id="clip0_59_253">
                                                <rect width="21.3333" height="20" fill="white"
                                                    transform="translate(20) rotate(90)" />
                                            </clipPath>
                                        </defs>
                                    </svg>
                                </a>
                            </div>
                        </div>
                        <div class="col-lg-7 col-xl-6">
                            <div class="form-wrapper form-box bg-black mt-5 mt-lg-0 z-index-2">
                                <div class="section-title">
                                    <h4 class="title mb-0">{{ __('lang.Quick contact form:') }} </h4>
                                </div>
                                <form class="contact-form form-style-border">
                                    <div class="row">
                                        <div class="col-sm-6">
                                            <input type="text" class="form-control" placeholder="{{__('lang.Name')}}"
                                                aria-label="Name">
                                        </div>
                                        <div class="col-sm-6">
                                            <input type="email" class="form-control" placeholder="{{__('lang.Email')}}"
                                                aria-label="Email" required>
                                        </div>
                                        <div class="col-sm-6">
                                            <input type="text" class="form-control" id="phone"
                                                placeholder="{{__('lang.Phone')}}" required>
                                        </div>
                                        <div class="col-sm-6">
                                            <input type="text" class="form-control" id="Subject"
                                                placeholder="{{__('lang.Subject')}}">
                                        </div>
                                        <div class="col-lg-12">
                                            <textarea class="form-control" rows="3" placeholder="{{__('lang.Describe your message')}}*"></textarea>
                                        </div>
                                        <div class="d-flex justify-content-center ms-sm-5 ms-0">
                                            <button type="submit" class="btn btn-effect" href="#">
                                                <span>{{__('lang.Send now')}}</span>
                                                <svg width="20" height="22" viewBox="0 0 20 22" fill="none"
                                                    xmlns="http://www.w3.org/2000/svg">
                                                    <g clip-path="url(#clip0_59_253)">
                                                        <path
                                                            d="M19.4854 11.4293L17.0513 12.221C13.1214 13.4993 10.3036 16.9595 9.84784 21.0668C9.49371 16.981 6.71926 13.5081 2.81255 12.2604L0.210283 11.4293"
                                                            stroke="white" stroke-width="2" />
                                                        <path d="M9.83594 20.8889L9.83594 0" stroke="white"
                                                            stroke-width="2" />
                                                    </g>
                                                    <defs>
                                                        <clipPath id="clip0_59_253">
                                                            <rect width="21.3333" height="20" fill="white"
                                                                transform="translate(20) rotate(90)" />
                                                        </clipPath>
                                                    </defs>
                                                </svg>
                                            </button>
                                        </div>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </section>
            <section class="space-pt ellipse-top bg-black z-index-2" style="background: #f5ebeb !important; padding: 5rem 0;">
                <div class="container">
                    <div class="row mb-lg-5">
                        <div class="col-xxl-6 col-lg-8">
                            <div class="section-title mb-lg-0">
                                <span
                                    class="sub-title">{{ app()->getLocale() == 'ar' ? $setting->section10_title : $setting->section10_title_en }}</span>
                                <h2 class="title mb-0">
                                    {{ app()->getLocale() == 'ar' ? $setting->section10_subtitle : $setting->section10_subtitle_en }}
                                </h2>
                            </div>
                        </div>
                        <div class="col-xxl-6 col-lg-4 align-self-end">
                            <div class="d-flex justify-content-center mt-5 ms-sm-5 ms-0">
                                <a class="btn btn-effect" href="{{route('front.form')}}">
                                    <span>{{__('lang.start now')}}</span>
                                    <svg width="20" height="22" viewBox="0 0 20 22" fill="none"
                                        xmlns="http://www.w3.org/2000/svg">
                                        <g clip-path="url(#clip0_59_253)">
                                            <path
                                                d="M19.4854 11.4293L17.0513 12.221C13.1214 13.4993 10.3036 16.9595 9.84784 21.0668C9.49371 16.981 6.71926 13.5081 2.81255 12.2604L0.210283 11.4293"
                                                stroke="white" stroke-width="2" />
                                            <path d="M9.83594 20.8889L9.83594 0" stroke="white" stroke-width="2" />
                                        </g>
                                        <defs>
                                            <clipPath id="clip0_59_253">
                                                <rect width="21.3333" height="20" fill="white"
                                                    transform="translate(20) rotate(90)" />
                                            </clipPath>
                                        </defs>
                                    </svg>
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </section>

        </div>
    </div>
    @include('Frontend.Includes.Footer')
    <!-- FOOTER AREA END -->
@endsection
