@extends('Frontend.Layouts.app')
@section('title', __('lang.Blog'))
@section('content')
    <!-- HEADER AREA -->
    @include('Frontend.Includes.navbar')
    <!-- HEADER AREA END -->
    <div class="site-content">

        <div class="container-fluid">
            <div class="item-efftect">
                <div class="efftect overflow-hidden"></div>
                <div class="efftect overflow-hidden"></div>
                <div class="efftect overflow-hidden"></div>
                <div class="efftect overflow-hidden"></div>
                <div class="efftect overflow-hidden"></div>
            </div>
        </div>

        <div class="inner-header bg-holder" style="background-image: url({{ asset('front/images/head.jpg') }});">
            <div class="container">
                <div class="row  justify-content-center">
                    <div class="col-md-12 text-center">
                        <h1 class="title">{{ $blog->title }}</h1>
                        <p>{{ $blog->category }}</p>
                    </div>
                </div>
            </div>
        </div>

        <div class="content-wrapper">
            <section class="space-ptb ellipse-bottom">
                <div class="container">
                    <div class="row">
                        <div class="col-lg-8 order-lg-2">
                            <a class="sidebar-btn d-lg-none" href="#offcanvasSidebar" data-bs-toggle="offcanvas"
                                aria-controls="offcanvasSidebar">
                                <i class="fa-solid fa-outdent"></i>{{ $blog->title }}
                            </a>
                            <div class="mb-0">
                                <img class="img-fluid" src="{{ asset('storage/files/' . ($blog->image ?? 'default.png')) }}" alt=""><hr>
                                {!!$blog->content !!}
                            </div>
                        </div>
                        <div class="col-lg-4 order-lg-1 mt-5 mt-lg-0">
                            <div class="offcanvas-lg mobile-sidebar offcanvas-sidebar offcanvas-start"
                                data-bs-backdrop="static" tabindex="-1" id="offcanvasSidebar"
                                aria-labelledby="offcanvasSidebar">

                                <div class="offcanvas-body">
                                    <div class="sidebar mobile-offcanvas ps-0 pe-0 ps-xl-5 pe-xl-5 pe-lg-4">
                                        <div class="widget tags-widget">
                                            <h5 class="widget-title">Tag</h5>
                                            <ul class="tag-list">
                                                @foreach(explode(',', $blog->tags) as $tag)
                                                <li><a href="#">{{ trim($tag) }}</a></li>
                                                @endforeach
                                            </ul>
                                            </div>

                                        <div class="widget widget-recent-posts">
                                            <h5 class="widget-title">{{ __('lang.popular blog') }}</h5>

                                            @php
                                                if (app()->getLocale() == 'ar') {
                                                    $blogs = App\Models\blog::where('status', 1)
                                                        ->where('language_id', 2)
                                                        ->where('popular', 1)
                                                        ->latest()->limit(4)
                                                        ->get();
                                                } else {
                                                    $blogs = App\Models\blog::where('status', 1)
                                                        ->where('language_id', 1)
                                                        ->where('popular', 1)
                                                        ->latest()->limit(4)
                                                        ->get();
                                                }
                                            @endphp
                                            @foreach ($blogs as $blog1)
                                            <div class="mb-5 ">
                                                <div class="blog-post-img"><img class="img-fluid"
                                                    src="{{ asset('storage/files/' . ($blog1->image ?? 'default.png')) }}"
                                                    alt=""></div>
                                                <div class="blog-post-info">
                                                    <p class="post-title"><a href="{{ route('front.blog', $blog1->id) }}">
                                                            {{ $blog1->title }}</a></h5>
                                                    <p class="post-title"> {{ $blog1->category }} </p>
                                                </div>

                                            </div>
                                            <hr>
                                            @endforeach


                                        </div>


                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </section>
            @php
                $hsetting = App\Models\Home_setting::select(
                    'section10_subtitle',
                    'section10_title',
                    'section10_title_en',
                    'section10_subtitle_en',
                )->first();
            @endphp

            <section class="space-pt ellipse-top bg-black z-index-2">
                <div class="container">
                    <div class="row mb-lg-5">
                        <div class="col-xxl-6 col-lg-8">
                            <div class="section-title mb-lg-0">
                                <span
                                    class="sub-title">{{ app()->getLocale() == 'ar' ? $hsetting->section10_title : $hsetting->section10_title_en }}</span>
                                <h2 class="title mb-0">
                                    {{ app()->getLocale() == 'ar' ? $hsetting->section10_subtitle : $hsetting->section10_subtitle_en }}
                                </h2>
                            </div>
                        </div>
                        <div class="col-xxl-6 col-lg-4 align-self-end">
                            <div class="d-flex justify-content-center mt-5 ms-sm-5 ms-0">
                                <a class="btn btn-effect" href="{{ route('front.form') }}">
                                    <span>{{ __('lang.start now') }}</span>
                                    <svg width="20" height="22" viewBox="0 0 20 22" fill="none"
                                        xmlns="http://www.w3.org/2000/svg">
                                        <g clip-path="url(#clip0_59_253)">
                                            <path
                                                d="M19.4854 11.4293L17.0513 12.221C13.1214 13.4993 10.3036 16.9595 9.84784 21.0668C9.49371 16.981 6.71926 13.5081 2.81255 12.2604L0.210283 11.4293"
                                                stroke="white" stroke-width="2" />
                                            <path d="M9.83594 20.8889L9.83594 0" stroke="white" stroke-width="2" />
                                        </g>
                                        <defs>
                                            <clipPath id="clip0_59_253">
                                                <rect width="21.3333" height="20" fill="white"
                                                    transform="translate(20) rotate(90)" />
                                            </clipPath>
                                        </defs>
                                    </svg>
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </section>
        </div>
    </div>

    @include('Frontend.Includes.Footer')
    <!-- FOOTER AREA END -->
@endsection
