@extends('layouts.dash_master')
@section('title')
    <title>{{ __('إنشاء مدونة') }}</title>
@endsection

@section('dash-content')
    <div class="content-header row">
        <div class="content-header-left col-md-9 col-12 mb-2">
            <div class="row breadcrumbs-top">
                <div class="col-12">
                    <h2 class="content-header-title float-start mb-0">{{ __('إنشاء مدونة') }}</h2>
                    <div class="breadcrumb-wrapper">
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">الرئيسية</a>
                            </li>
                            <li class="breadcrumb-item"><a href="{{ route('blog.index') }}">مدونة</a>
                            </li>
                            <li class="breadcrumb-item"> {{ __('إنشاء مدونة') }}
                            </li>
                        </ol>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <section id="multiple-column-form">
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-header">
                        <h4 class="card-title"> {{ __('إنشاء مدونة') }}</h4>
                    </div>
                    <div class="card-body">
                        <form action="{{ route('blog.store') }}" method="POST"
                            enctype="multipart/form-data">
                            @csrf
                            <div class="row">
                                {{-- //image --}}
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <input type='file' onchange="loadFile_image(image)" name="image" id="image"
                                            class="@error('image') is-invalid @enderror" style="display:none;" />
                                        <button id="output_image" type="button"
                                            onclick="document.getElementById('image').click();"
                                            style="width: 190px;
                                                    height: 120px;
                                                    border-radius: 0.357rem !important;
                                                    background-color: #cecbcb;
                                                    background-repeat: no-repeat;
                                                    background-size: cover;
                                                    background-position: center;
                                                    " />
                                    </div>
                                    <label for="username">{{ __('الصورة') }}</label>
                                </div>
                                <script>
                                    var loadFile_image = function(image) {
                                        var image = document.getElementById('output_image');
                                        var src = URL.createObjectURL(event.target.files[0]);
                                        image.style.backgroundImage = 'url(' + src + ')';
                                    };
                                </script>
                                <hr class="invoice-spacing">
                                <div class="row">

                                    <x-input-field label="{{ __('العنوان ') }}" name="title"
                                        value="{{ old('title') }}" maxLength="250" col="6" required />

                                    <x-input-field label="{{ __('Category') }}" name="category"
                                        value="{{ old('category') }}" maxLength="250" col="6" required />


                                    <div class="col-12 mb-1">
                                        <label for="content"> {{ __('الفئة') }}</label>
                                        <textarea name="content" id="content" class="form-control"></textarea>
                                    </div>

                                    <div class="col-12 mb-1">
                                        <label for="tags">Tages:</label>
                                        <div id="tag-container">
                                            <input type="text" id="tag-input" class="form-control"
                                                placeholder="أدخل التاغ واضغطEnter">
                                        </div>
                                    </div>
                                    <x-select-field label="{{ __('Language') }}" required="true" name="language_id" :options="$languages"
                                            value="{{ old('language_id') }}" />
                                    <div class="col-6 mt-2">
                                        <label  class="form-label pb-1">Is active:</label>
                                            <input type="checkbox" class="form-check-input"  name="status" checked value="1" id="colorCheck4">
                                            <label  class="form-label ">نشط </label>
                                    </div>
                                    <div class="col-6 mt-2">
                                        <label  class="form-label pb-1">هل شائع:</label>
                                            <input type="checkbox" class="form-check-input"  name="popular" value="1" id="colorCheck4">
                                            <label  class="form-label ">شائع </label>
                                    </div>
                                    <x-textarea-field label="{{ __('seo') }}" name="seo" value="{{ old('seo') }}"
                                        maxLength="10000" />
                                    <input type="hidden" name="tags" id="hidden-tags">
                                    <div class="col-12">
                                        <button type="submit"
                                            class="btn btn-primary me-1 waves-effect waves-float waves-light">Submit</button>
                                    </div>
                                </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </section>
@endsection

@push('js')
    <script src="https://cdn.ckeditor.com/ckeditor5/39.0.1/classic/ckeditor.js"></script>
    <script>

        ClassicEditor
            .create(document.querySelector('#content'))
            .then(editor => {
        editor.editing.view.change(writer => {
            writer.setStyle('min-height', '300px', editor.editing.view.document.getRoot());
        });
    })
            .catch(error => {
                console.error(error);
            });
    </script>

    <script>
        document.addEventListener("DOMContentLoaded", function() {
            let tagInput = document.getElementById("tag-input");
            let tagContainer = document.getElementById("tag-container");
            let hiddenTags = document.getElementById("hidden-tags");
            let tags = [];

            tagInput.addEventListener("keypress", function(event) {
                if (event.key === "Enter") {
                    event.preventDefault();
                    let tagText = tagInput.value.trim();

                    if (tagText !== "" && !tags.includes(tagText)) {
                        tags.push(tagText);
                        updateTags();
                        tagInput.value = "";
                    }
                }
            });

            function updateTags() {
                tagContainer.innerHTML = "";
                tags.forEach((tag, index) => {
                    let tagElement = document.createElement("span");
                    tagElement.classList.add("tag");
                    tagElement.innerHTML =
                        `${tag} <button type="button" onclick="removeTag(${index})">×</button>`;
                    tagContainer.appendChild(tagElement);
                });

                // إعادة إدخال الحقل حتى يكون موجود
                let newInput = document.createElement("input");
                newInput.type = "text";
                newInput.id = "tag-input";
                newInput.classList.add("form-control");
                newInput.placeholder = "أدخل التاغ واضغط Enter";
                tagContainer.appendChild(newInput);
                tagInput = newInput;
                tagInput.addEventListener("keypress", function(event) {
                    if (event.key === "Enter") {
                        event.preventDefault();
                        let tagText = tagInput.value.trim();

                        if (tagText !== "" && !tags.includes(tagText)) {
                            tags.push(tagText);
                            updateTags();
                            tagInput.value = "";
                        }
                    }
                });

                hiddenTags.value = tags.join(",");
            }

            window.removeTag = function(index) {
                tags.splice(index, 1);
                updateTags();
            };
        });
    </script>
@endpush
