@extends('layouts.dash_master')
@section('title')
    <title>{{ __('الصفحات') }}</title>
@endsection

@section('dash-content')
    <!-- Main Content -->
    <div class="main-content">
        <section class="section">
            <div class="content-header row">
                <div class="content-header-left col-md-9 col-12 mb-2">
                    <div class="row breadcrumbs-top">
                        <div class="col-12">
                            <h2 class="content-header-title float-start mb-0">الصفحات</h2>
                            <div class="breadcrumb-wrapper">
                                <ol class="breadcrumb">
                                    <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">الرئيسية</a>
                                    </li>
                                    <li class="breadcrumb-item active">الإعدادات
                                    </li>
                                    <li class="breadcrumb-item active">الصفحات
                                    </li>
                                </ol>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <section id="multiple-column-form">
            <div class="row">
                <div class="col-2">
                    <div class="card">
                        <div class="card-header">
                            <h4 class="card-title">الصفحات</h4>
                        </div>
                        <div class="card-body">
                            <div class="nav-vertical">
                                <ul class="nav nav-tabs nav-left flex-column" role="tablist">
                                    <li class="nav-item">
                                        <a class="nav-link active" id="baseVerticalLeft-tab1" data-bs-toggle="tab"
                                            aria-controls="tabVerticalLeft1" href="#tabVerticalLeft1" role="tab"
                                            aria-selected="true">شروط الخدمة</a>
                                    </li>
                                    <li class="nav-item">
                                        <a class="nav-link" id="baseVerticalLeft-tab2" data-bs-toggle="tab"
                                            aria-controls="tabVerticalLeft2" href="#tabVerticalLeft2" role="tab"
                                            aria-selected="false">شروط الاستخدام</a>
                                    </li>
                                    <li class="nav-item">
                                        <a class="nav-link" id="baseVerticalLeft-tab3" data-bs-toggle="tab"
                                            aria-controls="tabVerticalLeft3" href="#tabVerticalLeft3" role="tab"
                                            aria-selected="false">الخصوصية
                                        </a>
                                    </li>

                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-10">
                    <div class="tab-content">
                        <div class="tab-pane active" id="tabVerticalLeft1" role="tabpanel"
                            aria-labelledby="baseVerticalLeft-tab1">
                            <p>
                            <form action="{{ route('admin.update-page-setting') }}" method="POST"
                                enctype="multipart/form-data">
                                @csrf
                                @method('PUT')
                                <div class="row">
                                    <div class="col-md-11">
                                        <div class="card">
                                            <div class="row card-body">
                                                <ul class="nav nav-tabs" role="tablist">
                                                    <li class="nav-item">
                                                        <a class="nav-link active" id="arabic-tab" data-bs-toggle="tab"
                                                            href="#arabic" aria-controls="arabic" role="tab"
                                                            aria-selected="true"> عربي</a>
                                                    </li>
                                                    <li class="nav-item">
                                                        <a class="nav-link" id="english-tab" data-bs-toggle="tab"
                                                            href="#english" aria-controls="english" role="tab"
                                                            aria-selected="false"> English</a>
                                                    </li>
                                                </ul>
                                                <div class="tab-content">
                                                    <div class="tab-pane active" id="arabic" aria-labelledby="arabic-tab"
                                                        role="tabpanel">

                                                        <div class="col-12 mb-1">
                                                            <label for="t_s_content">
                                                                {{ __('محتوى الصفحة ') }}</label>
                                                            <textarea name="t_s_content" rows="10" id="t_s_content" class="form-control">{!! $setting->t_s_content ?? '' !!}</textarea>
                                                        </div>

                                                    </div>
                                                    <div class="tab-pane" id="english" aria-labelledby="english-tab"
                                                        role="tabpanel">
                                                        <div class="col-12 mb-1">
                                                            <label for="t_s_content_en">
                                                                {{ __('en محتوى الصفحة ') }}</label>
                                                            <textarea name="t_s_content_en" rows="10" id="t_s_content_en" class="form-control">{!! $setting->t_s_content_en ?? '' !!}</textarea>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="col-12">
                                        <button type="submit"
                                            class="btn btn-primary me-1 waves-effect waves-float waves-light">تعديل</button>
                                    </div>
                                </div>

                            </form>
                            </p>
                        </div>
                        <div class="tab-pane" id="tabVerticalLeft2" role="tabpanel"
                            aria-labelledby="baseVerticalLeft-tab2">
                            <form action="{{ route('admin.update-page-setting') }}" method="POST"
                                enctype="multipart/form-data">
                                @csrf
                                @method('PUT')
                                <div class="row">
                                    <div class="col-md-11">
                                        <div class="card">
                                            <div class="row card-body">
                                                <ul class="nav nav-tabs" role="tablist">
                                                    <li class="nav-item">
                                                        <a class="nav-link active" id="arabic3-tab" data-bs-toggle="tab"
                                                            href="#arabic3" aria-controls="arabic3" role="tab"
                                                            aria-selected="true"> عربي</a>
                                                    </li>
                                                    <li class="nav-item">
                                                        <a class="nav-link" id="english3-tab" data-bs-toggle="tab"
                                                            href="#english3" aria-controls="english3" role="tab"
                                                            aria-selected="false"> English </a>
                                                    </li>
                                                </ul>
                                                <div class="tab-content">
                                                    <div class="tab-pane active" id="arabic3"
                                                        aria-labelledby="arabic3-tab" role="tabpanel">
                                                        <div class="col-12 mb-1">
                                                            <label for="t_u_content">
                                                                {{ __('محتوى الصفحة ') }}</label>
                                                            <textarea name="t_u_content" rows="10" id="t_u_content" class="form-control">{!! $setting->t_u_content ?? '' !!}</textarea>
                                                        </div>

                                                    </div>
                                                    <div class="tab-pane" id="english3" aria-labelledby="english3-tab"
                                                        role="tabpanel">

                                                        <div class="col-12 mb-1">
                                                            <label for="t_u_content_en">
                                                                {{ __('en محتوى الصفحة ') }}</label>
                                                            <textarea name="t_u_content_en" rows="10" id="t_u_content_en" class="form-control">{!! $setting->t_u_content_en ?? '' !!}</textarea>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-12">
                                        <button type="submit"
                                            class="btn btn-primary me-1 waves-effect waves-float waves-light">تعديل</button>
                                    </div>
                                </div>

                            </form>
                        </div>
                        <div class="tab-pane" id="tabVerticalLeft3" role="tabpanel"
                            aria-labelledby="baseVerticalLeft-tab3">
                            <form action="{{ route('admin.update-page-setting') }}" method="POST"
                                enctype="multipart/form-data">
                                @csrf
                                @method('PUT')
                                <div class="row">
                                    <div class="col-md-11">
                                        <div class="card">
                                            <div class="row card-body">
                                                <ul class="nav nav-tabs" role="tablist">
                                                    <li class="nav-item">
                                                        <a class="nav-link active" id="arabic4-tab" data-bs-toggle="tab"
                                                            href="#arabic4" aria-controls="arabic4" role="tab"
                                                            aria-selected="true"> عربي</a>
                                                    </li>
                                                    <li class="nav-item">
                                                        <a class="nav-link" id="english4-tab" data-bs-toggle="tab"
                                                            href="#english4" aria-controls="english4" role="tab"
                                                            aria-selected="false"> English </a>
                                                    </li>
                                                </ul>
                                                <div class="tab-content">
                                                    <div class="tab-pane active" id="arabic4"
                                                        aria-labelledby="arabic4-tab" role="tabpanel">
                                                        <div class="col-12 mb-1">
                                                            <label for="s_content">
                                                                {{ __('محتوى الصفحة ') }}</label>
                                                            <textarea name="s_content" rows="10" id="s_content" class="form-control">{!! $setting->s_content ?? '' !!}</textarea>
                                                        </div>

                                                    </div>
                                                    <div class="tab-pane" id="english4" aria-labelledby="english4-tab"
                                                        role="tabpanel">

                                                        <div class="col-12 mb-1">
                                                            <label for="s_content_en">
                                                                {{ __('en محتوى الصفحة ') }}</label>
                                                            <textarea name="s_content_en" rows="10" id="s_content_en" class="form-control">{!! $setting->s_content_en ?? '' !!}</textarea>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-12">
                                        <button type="submit"
                                            class="btn btn-primary me-1 waves-effect waves-float waves-light">تعديل</button>
                                    </div>
                                </div>

                            </form>
                        </div>

                    </div>
                </div>
            </div>

        </section>
    </div>
@endsection
@push('js')
    <script src="https://cdn.ckeditor.com/ckeditor5/39.0.1/classic/ckeditor.js"></script>
    <script>

        ClassicEditor
            .create(document.querySelector('#t_s_content'))
            .then(editor => {
                editor.editing.view.change(writer => {
                    writer.setStyle('min-height', '300px', editor.editing.view.document.getRoot());
                });
            })
            .catch(error => {
                console.error(error);
            });
        ClassicEditor
            .create(document.querySelector('#t_s_content_en'))
            .then(editor => {
                editor.editing.view.change(writer => {
                    writer.setStyle('min-height', '300px', editor.editing.view.document.getRoot());
                });
            })
            .catch(error => {
                console.error(error);
            });
        ClassicEditor
            .create(document.querySelector('#t_u_content'))
            .then(editor => {
                editor.editing.view.change(writer => {
                    writer.setStyle('min-height', '300px', editor.editing.view.document.getRoot());
                });
            })
            .catch(error => {
                console.error(error);
            });
        ClassicEditor
            .create(document.querySelector('#t_u_content_en'))
            .then(editor => {
                editor.editing.view.change(writer => {
                    writer.setStyle('min-height', '300px', editor.editing.view.document.getRoot());
                });
            })
            .catch(error => {
                console.error(error);
            });
        ClassicEditor
            .create(document.querySelector('#s_content'))
            .then(editor => {
                editor.editing.view.change(writer => {
                    writer.setStyle('min-height', '300px', editor.editing.view.document.getRoot());
                });
            })
            .catch(error => {
                console.error(error);
            });
        ClassicEditor
            .create(document.querySelector('#s_content_en'))
            .then(editor => {
                editor.editing.view.change(writer => {
                    writer.setStyle('min-height', '300px', editor.editing.view.document.getRoot());
                });
            })
            .catch(error => {
                console.error(error);
            });
    </script>
@endpush
