<?php

namespace App\Http\Controllers\admin;

use App\Models\Agent;
use App\Models\Company;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Storage;

class AgentController extends Controller
{
    public function index()
    {
        $agents = Agent::latest()->get();
        return view('admin.agent.agents',compact('agents'));
    }

    public function show(Agent $agent)
    {
        return view('admin.agent.show', compact('agent'));
    }

    public function create()
    {
        $companies = Company::orderBy('name')->pluck('name', 'id')->toArray();
        $modalContent = view('admin.agent.create_agent',compact('companies'))->render();

        return response()->json(['modalContent' => $modalContent]);
    }


    public function store(Request $request)
    {

        // التحقق من المدخلات
        $validated = $request->validate([
            'name' => 'required|string|max:255',
            'phone' => 'required|string|max:13|min:10',
            'company_id' => 'nullable|exists:companies,id',
        ] );

        // إنشاء خدمة جديد
        Agent::create($validated);

        $notification = trans('dash.Created Successfully');
        return response()->json(['redirect_url' => route('admin.agent.index'),
        'notification' => $notification ]
    );
    }

    public function edit($id)
    {
        $agent = Agent::find($id);
        $companies = Company::orderBy('name')->pluck('name', 'id')->toArray();

            $modalContent = view('admin.agent.edit_agent',compact('agent','companies'))->render();
            return response()->json(['modalContent' => $modalContent]);

    }


    public function update(Request $request,$id)
    {
        $agent = Agent::find($id);


        // التحقق من المدخلات
        $validated = $request->validate([
            'name' => 'required|string|max:255',
            'phone' => 'required|string|max:13|min:10',
            'company_id' => 'nullable|exists:companies,id',
        ] );

        // تحديث بيانات الخدمة
        $agent->update($validated);

        $notification = trans('dash.Updated Successfully');
        return response()->json(['redirect_url' => route('admin.agent.index'),
        'notification' => $notification ]
    );
    }

    public function destroy($id)
    {
        $agent = Agent::find($id);
        $agent->delete();
        $notification = trans('dash.Delete Successfully');
        $notification = array('messege'=>$notification,'alert-type'=>'success');
        return redirect()->route('admin.agent.index')->with($notification);
    }

    public function changeStatus($id){
        $agent = Agent::find($id);
            if($agent->status=='active'){
                $agent->status='inactive';
                $agent->save();
                $message = trans('dash.Inactive Successfully');
            }else{
                $agent->status='active';
                $agent->save();
                $message= trans('dash.Active Successfully');
            }
            return response()->json($message);
    }


}
