<?php

namespace App\Http\Controllers\admin;

use App\Models\Company;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Storage;

class CompanyController extends Controller
{
    public function index()
    {
        $companies = Company::latest()->get();
        return view('admin.company.companies',compact('companies'));
    }

    public function show(Company $company)
    {
        return view('admin.company.show', compact('company'));
    }

    public function create()
    {
        $modalContent = view('admin.company.create_company')->render();

        return response()->json(['modalContent' => $modalContent]);
    }


    public function store(Request $request)
    {

        // التحقق من المدخلات
        $validated = $request->validate([
            'name' => 'required|string|max:255',
            'address' => 'required|string|max:255',
        ] );

        // إنشاء خدمة جديد
        Company::create($validated);

        $notification = trans('dash.Created Successfully');
        return response()->json(['redirect_url' => route('admin.company.index'),
        'notification' => $notification ]
    );
    }

    public function edit($id)
    {
        $company = Company::find($id);
            $modalContent = view('admin.company.edit_company',compact('company'))->render();
            return response()->json(['modalContent' => $modalContent]);

    }


    public function update(Request $request,$id)
    {
        $company = Company::find($id);


        // التحقق من المدخلات
        $validated = $request->validate([
            'name' => 'required|string|max:255',
            'address' => 'required|string|max:255',
        ] );

        // تحديث بيانات الخدمة
        $company->update($validated);

        $notification = trans('dash.Updated Successfully');
        return response()->json(['redirect_url' => route('admin.company.index'),
        'notification' => $notification ]
    );
    }

    public function destroy($id)
    {
        $company = Company::find($id);
        $company->delete();
        $notification = trans('dash.Delete Successfully');
        $notification = array('messege'=>$notification,'alert-type'=>'success');
        return redirect()->route('admin.company.index')->with($notification);
    }

}
