<?php

namespace App\Http\Controllers\admin;

use App\Models\Message;
use App\Models\Language;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Storage;

class MessageController extends Controller
{
    public function index(Request $request)
    {
        if ($request->ajax()) {
            $draw = $request->get('draw');

            $start = $request->get("start");
            $rowperpage = $request->get("length"); // Rows display per page
            $search_arr = $request->get('search');
            $searchValue = $search_arr['value']; // Search value
            $totalRecords = Message::select('count(*) as allcount')->count();
            $totalRecordswithFilter = message::select('count(*) as allcount')->where('name', 'like', '%' . $searchValue . '%')->orwhere('phone', 'like', '%' . $searchValue . '%')->orwhere('email', 'like', '%' . $searchValue . '%')->count();

            $messages = Message::select('messages.*')
                ->when($searchValue != null, function ($q) use ($searchValue) {
                    $q->where('name', 'like', '%' . $searchValue . '%')
                    ->orwhere('phone', 'like', '%' . $searchValue . '%') ;
                })
                ->skip($start)
                ->take($rowperpage)
                ->orderBy('messages.id', 'desc')
                ->get();

            $records = [];

            foreach($messages as $message)
            {
                if($message->type == 'service'){
                    $type = '<span class="badge badge-light-primary">خدمة</span>';
                }elseif($message->type == 'plan'){
                    $type ='<span class="badge badge-light-secondary">باقة</span>' ;
                }else{
                    $type ='<span class="badge badge-light-info">إستشارة</span>' ;
                }
                if($message->status == 'new'){
                    $status ='<span class="badge badge-glow bg-info">جديد</span>';
                }elseif($message->status == 'urgent'){
                    $status = '<span class="badge badge-glow bg-warning">مستعجل</span>';
                }elseif($message->status == 'Completed'){
                    $status = '<span class="badge badge-glow bg-success">مكتمل</span>';
                }elseif($message->status == 'Cancelled'){
                    $status = '<span class="badge badge-glow bg-danger">ملغي</span>';
                }elseif($message->status == 'under_review'){
                    $status = '<span class="badge badge-glow bg-secondary">تحت المراجعة</span>';
                }
                if($message->is_featured == 1){
                    $is_featured = '<span class="badge bg-success"> <i data-feather="star" class="me-25"></i> s</span>' ;

                }

                $records[] = [
                       'name' => $message->name ?? '-' ,
                       'phone' =>$message->phone ?? '-'  ,
                       'email' => $message->email ?? '-',
                       'subject' => $message->subject ?? '-',
                       'message' => $message->message ?? '-',
                       'actions' => view('admin.message.buttons',[ 'message' => $message ])->render() ,
                    ];
            }

            $response = [
                        "draw" => intval($draw),
                        "iTotalRecords" => $totalRecords,
                        "iTotalDisplayRecords" => $totalRecordswithFilter,
                        "aaData" => $records
                    ];

            return response()->json($response);

        }
        $messages = Message::latest()->get();
        $total = Message::select('count(*) as allcount')->count();
        return view('admin.message.messages',[
            'messages' => $messages,
            'total' => $total,
        ]);
    }


    public function destroy($id)
    {
        $message = Message::find($id);
        $message->delete();
        $notification = trans('تم الحذف');
        $notification = array('messege'=>$notification,'alert-type'=>'success');
        return redirect()->route('messages')->with($notification);
    }

}
