<?php

namespace App\Http\Controllers\admin;

use App\Models\Service;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Storage;

class ServiceController extends Controller
{
    public function index()
    {
        $services = Service::latest()->get();
        return view('admin.service.services',compact('services'));
    }


    public function create()
    {
        $modalContent = view('admin.service.create_service' )->render();

        return response()->json(['modalContent' => $modalContent]);
    }


    public function store(Request $request)
    {

        $request->validate([
            'title' => 'required|string|max:255',
            'title_en' => 'nullable|string|max:255',
            'body'   => 'required|string',
            'body_en'   => 'nullable|string',
        ]);
        Service::create([
            'title' => $request->title,
            'title_en' => $request->title_en,
            'body'   => $request->body,
            'body_en'   => $request->body_en,
        ]);
        $notification = trans('تم الانشاء بنجاح');
        return response()->json(['redirect_url' => route('service.index'),
        'notification' => $notification ]
    );
    }

    public function edit($id)
    {
        $service = Service::find($id);

        $modalContent = view('admin.service.edit_service',compact('service'))->render();
        return response()->json(['modalContent' => $modalContent]);

    }


    public function update(Request $request,$id)
    {
        $service = Service::find($id);
        $request->validate([
            'title' => 'required|string|max:255',
            'title_en' => 'required|string|max:255',
            'body'   => 'required|string',
            'body_en'   => 'required|string',
        ]);
        $service->update([
            'title' => $request->title,
            'title_en' => $request->title_en,
            'body'   => $request->body,
            'body_en'   => $request->body_en,
        ]);
        $notification = trans('تم التعديل بنجاح');
        return response()->json(['redirect_url' => route('service.index'),
        'notification' => $notification ]
    );
    }

    public function destroy($id)
    {
        $service = Service::find($id);
        $service->delete();
        $notification = trans('تم الحذف بنجاح');
        $notification = array('messege'=>$notification,'alert-type'=>'success');
        return redirect()->route('service.index')->with($notification);
    }

    public function changeStatus($id){
        $service = Service::find($id);
            if($service->status== 1){
                $service->status= 0;
                $service->save();
                $message = trans('غير نشط الان');
            }else{
                $service->status= 1;
                $service->save();
                $message= trans('نشط الان');
            }
            return response()->json($message);
    }

}
