<?php

namespace App\Http\Controllers\Admin;

use App\Models\Home_setting;
use App\Models\About_setting;
use App\Models\Page_setting;
use Illuminate\Http\Request;

use App\Http\Controllers\Controller;
use App\Http\Requests\CenterRequest;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Storage;

class SettingController extends Controller
{

    public function index(){
        $setting=Home_setting::first();
        return view('admin.setting',compact('setting'));
    }


    public function updateSiteSetting(Request $request)
{
    $validated = $request->validate([
        'logo' => 'nullable|image|mimes:jpeg,png,jpg,gif,svg|max:2048',
        'logo_secondary' => 'nullable|image|mimes:jpeg,png,jpg,gif,svg|max:2048',
        'favicon' => 'nullable|image|mimes:jpeg,png,jpg,gif,svg|max:512',
        'site_name' => 'nullable|string|max:255',
        'site_name_en' => 'nullable|string|max:255',
        'footer' => 'nullable|string',
        'footer_en' => 'nullable|string',
        'address' => 'nullable|string',
        'address_en' => 'nullable|string',
        'phone' => 'nullable|string|max:20',
        'email' => 'nullable|email|max:255',
        'facebook' => 'nullable|url',
        'whatsapp' => 'nullable|url',
        'twitter' => 'nullable|url',
        'instagram' => 'nullable|url',
        'linkedin' => 'nullable|url',

        'section1_title' => 'nullable|string',
        'section1_title_en' => 'nullable|string',
        'section1_content' => 'nullable|string',
        'section1_content_en' => 'nullable|string',
        'section1_image' => 'nullable|image|mimes:jpeg,png,jpg,gif,svg|max:2048',

        'section2_title' => 'nullable|string',
        'section2_title_en' => 'nullable|string',
        'section2_subtitle' => 'nullable|string',
        'section2_subtitle_en' => 'nullable|string',
        'section2_subtitle2' => 'nullable|string',
        'section2_subtitle2_en' => 'nullable|string',
        'section2_content' => 'nullable|string',
        'section2_content_en' => 'nullable|string',
        'section2_image1' => 'nullable|image|mimes:jpeg,png,jpg,gif,svg|max:2048',
        'section2_image2' => 'nullable|image|mimes:jpeg,png,jpg,gif,svg|max:2048',

        'section3_title' => 'nullable|string',
        'section3_title_en' => 'nullable|string',
        'section3_content' => 'nullable|string',
        'section3_content_en' => 'nullable|string',
        'section3_image' => 'nullable|image|mimes:jpeg,png,jpg,gif,svg|max:2048',

        'section4_title' => 'nullable|string',
        'section4_title_en' => 'nullable|string',
        'section4_content' => 'nullable|string',
        'section4_content_en' => 'nullable|string',
        'section4_image1' => 'nullable|image|mimes:jpeg,png,jpg,gif,svg|max:2048',
        'section4_image2' => 'nullable|image|mimes:jpeg,png,jpg,gif,svg|max:2048',

        'section5_title' => 'nullable|string',
        'section5_title_en' => 'nullable|string',
        'section5_subtitle' => 'nullable|string',
        'section5_subtitle_en' => 'nullable|string',

        'section6_title' => 'nullable|string',
        'section6_title_en' => 'nullable|string',
        'section6_subtitle' => 'nullable|string',
        'section6_subtitle_en' => 'nullable|string',

        'section7_title' => 'nullable|string',
        'section7_title_en' => 'nullable|string',
        'section7_subtitle' => 'nullable|string',
        'section7_subtitle_en' => 'nullable|string',

        'section8_title' => 'nullable|string',
        'section8_title_en' => 'nullable|string',
        'section8_subtitle' => 'nullable|string',
        'section8_subtitle_en' => 'nullable|string',

        'section9_title' => 'nullable|string',
        'section9_title_en' => 'nullable|string',
        'section9_subtitle' => 'nullable|string',
        'section9_subtitle_en' => 'nullable|string',

        'section10_title' => 'nullable|string',
        'section10_title_en' => 'nullable|string',
        'section10_subtitle' => 'nullable|string',
        'section10_subtitle_en' => 'nullable|string',

        'section11_title' => 'nullable|string',
        'section11_title_en' => 'nullable|string',
        'section11_subtitle' => 'nullable|string',
        'section11_subtitle_en' => 'nullable|string',


    ]);

    $imageFields = [
        'logo', 'favicon','logo_secondary',
        'section1_image',
        'section2_image1', 'section2_image2',
        'section3_image',
        'section4_image1', 'section4_image2',
    ];

    $setting = Home_setting::first();

    foreach ($imageFields as $field) {
        if ($request->hasFile($field) && $request->file($field)->isValid()) {
            if ($setting && $setting->$field) {
                Storage::disk('files')->delete($setting->$field);
            }
            $validated[$field] = $request->file($field)->store('/', 'files');
        } elseif ($setting) {
            $validated[$field] = $setting->$field;
        }
    }

    if ($setting) {
        $setting->update($validated);
    } else {
        Home_setting::create($validated);
    }

    return redirect()->back()->with([
        'messege' => __('تم التحديث بنجاح'),
        'alert-type' => 'success'
    ]);
}

public function about_index(){
    $setting= About_setting::first();
    return view('admin.about_setting',compact('setting'));
}

public function updateAboutSetting(Request $request)
{
    $validated = $request->validate([
        'section1_title' => 'nullable|string',
        'section1_content' => 'nullable|string',
        'section1_title_en' => 'nullable|string',
        'section1_content_en' => 'nullable|string',
        'section1_image' => 'nullable|image|mimes:jpeg,png,jpg,gif,svg|max:2048',

        'content_1' => 'nullable|string',
        'content_1_en' => 'nullable|string',
        'content_2' => 'nullable|string',
        'content_2_en' => 'nullable|string',
        'content_3' => 'nullable|string',
        'content_3_en' => 'nullable|string',
        'content_4' => 'nullable|string',
        'content_4_en' => 'nullable|string',
        'content_5' => 'nullable|string',
        'content_5_en' => 'nullable|string',
        'content_6' => 'nullable|string',
        'content_6_en' => 'nullable|string',
        'content_7' => 'nullable|string',
        'content_7_en' => 'nullable|string',

        'section2_title' => 'nullable|string',
        'section2_subtitle' => 'nullable|string',
        'section2_title_en' => 'nullable|string',
        'section2_subtitle_en' => 'nullable|string',
        'section2_image' => 'nullable|image|mimes:jpeg,png,jpg,gif,svg|max:2048',
        'section2_content' => 'nullable|string',
        'section2_content_en' => 'nullable|string',

        'section3_title' => 'nullable|string',
        'section3_content' => 'nullable|string',
        'section3_title_en' => 'nullable|string',
        'section3_content_en' => 'nullable|string',
        'section3_image1' => 'nullable|image|mimes:jpeg,png,jpg,gif,svg|max:2048',
        'section3_image2' => 'nullable|image|mimes:jpeg,png,jpg,gif,svg|max:2048',

        'section4_title' => 'nullable|string',
        'section4_content' => 'nullable|string',
        'section4_title_en' => 'nullable|string',
        'section4_content_en' => 'nullable|string',
        'section4_image' => 'nullable|image|mimes:jpeg,png,jpg,gif,svg|max:2048',

        'section5_title' => 'nullable|string',
        'section5_subtitle' => 'nullable|string',
        'section5_title_en' => 'nullable|string',
        'section5_subtitle_en' => 'nullable|string',
    ]);

    $imageFields = [
        'section1_image',
        'section2_image',
        'section3_image1', 'section3_image2',
        'section4_image',
    ];

    $setting = About_setting::first();

    foreach ($imageFields as $field) {
        if ($request->hasFile($field) && $request->file($field)->isValid()) {
            if ($setting && $setting->$field) {
                Storage::disk('files')->delete($setting->$field);
            }
            $validated[$field] = $request->file($field)->store('/', 'files');
        } elseif ($setting) {
            $validated[$field] = $setting->$field;
        }
    }

    if ($setting) {
        $setting->update($validated);
    } else {
        About_setting::create($validated);
    }

    return redirect()->back()->with([
        'messege' => __('تم التحديث بنجاح'),
        'alert-type' => 'success'
    ]);
}

public function page_index(){
    $setting= Page_setting::first();
    return view('admin.page_setting',compact('setting'));
}

public function updatePageSetting(Request $request)
{
    $validated = $request->validate([
        't_s_content' => 'nullable|string',
        't_s_content_en' => 'nullable|string',
        't_u_content' => 'nullable|string',
        't_u_content_en' => 'nullable|string',
        's_content' => 'nullable|string',
        's_content_en' => 'nullable|string',
    ]);

    $setting = Page_setting::first();


    if ($setting) {
        $setting->update($validated);
    } else {
        Page_setting::create($validated);
    }

    return redirect()->back()->with([
        'messege' => __('تم التحديث بنجاح'),
        'alert-type' => 'success'
    ]);
}

}
