<?php

namespace App\Http\Controllers\admin;

use App\Models\Slider;
use App\Models\Work;
use App\Models\Language;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Storage;

class SliderController extends Controller
{
    public function index()
    {
        $works = Slider::latest()->get();
        return view('admin.slider.index',compact('works'));
    }


    public function create()
    {
        return view('admin.slider.create');
    }


    public function store(Request $request)
    {
        $validated = $request->validate([
            'subtitle_ar' => 'required|string|max:255',
            'subtitle_en' => 'required|string|max:255',
            'image_ar' => 'required|mimes:jpg,jpeg,png,webp|max:2048',
            'image_en' => 'required|mimes:jpg,jpeg,png,webp|max:2048',
            'title_ar' => 'required|string',
            'btn_ar' => 'nullable|string',
            'btn_en' => 'nullable|string',
            'url' => 'nullable|string',
            'title_en' => 'required|string|max:10000',
            'status' => 'nullable',
            'clients' => 'nullable',

        ]);

        if($request->hasFile('image_ar') && $request->file('image_ar')->isValid()){
            $validated['image_ar'] = $request->file('image_ar')->store('/','files');
        }

        if($request->hasFile('image_en') && $request->file('image_en')->isValid()){
            $validated['image_en'] = $request->file('image_en')->store('/','files');
        }
        Slider::create($validated);

        $notification = trans(' Create Successfully');
        $notification = array('messege'=>$notification,'alert-type'=>'success');
        return redirect()->back()->with($notification);
    }

    public function edit($id)
    {
        $work = Slider::find($id);

        return view('admin.slider.edit',compact('work'));

    }


    public function update(Request $request,$id)
    {
        $work = Slider::find($id);
        $validated = $request->validate([
            'subtitle_ar' => 'required|string|max:255',
            'subtitle_en' => 'required|string|max:255',
            'image_ar' => 'nullable|mimes:jpg,jpeg,png,webp|max:2048',
            'image_en' => 'nullable|mimes:jpg,jpeg,png,webp|max:2048',
            'title_ar' => 'required|string',
            'btn_ar' => 'nullable|string',
            'btn_en' => 'nullable|string',
            'url' => 'nullable|string',
            'title_en' => 'required|string|max:10000',
            'status' => 'nullable',
            'clients' => 'nullable',

        ]);
        $validated['image']= $work->image;
        if($request->hasFile('image_ar') && $request->file('image_ar')->isValid()){
            if($work->image_ar)
                Storage::disk('files')->delete($work->image_ar);
            $validated['image_ar'] = $request->file('image_ar')->store('/','files');
        }
        if($request->hasFile('image_en') && $request->file('image_en')->isValid()){
            if($work->image_en)
                Storage::disk('files')->delete($work->image_en);
            $validated['image_en'] = $request->file('image_en')->store('/','files');
        }

        $work->update($validated);

        $notification = trans(' Update Successfully');
        $notification = array('messege'=>$notification,'alert-type'=>'success');
        return redirect()->back()->with($notification);
    }

    public function destroy($id)
    {
        $work = Slider::find($id);
        if($work->image_ar) {
            Storage::disk('files')->delete($work->image_ar);
        }

        if($work->image_en) {
            Storage::disk('files')->delete($work->image_en);
        }
        $work->delete();
        $notification = trans('dash.Delete Successfully');
        $notification = array('messege'=>$notification,'alert-type'=>'success');
        return redirect()->route('work.index')->with($notification);
    }
}
