<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Order extends Model
{
    protected $guarded = [];

    public function service()
    {
        return $this->belongsTo(Service::class, 'related_id');
    }

    public function plan()
    {
        return $this->belongsTo(Plan::class, 'related_id');
    }

    public function relatedName()
   {
    if ($this->type === 'service') {
        return optional($this->service)->title;
    } elseif ($this->type === 'plan') {
        return optional($this->plan)->title_ar;
    }

    return null;
  }

}
