@php
    $setting = App\Models\Home_setting::select('logo','phone','email')->first();
@endphp
<header class="header header-3 header-sticky header-absolute">
    <div class="header-inner">
        <div class="site-logo">
            <a class="navbar-brand" style=" padding: 10px 0;" href="{{route('home')}}"><img class="img-fluid"
                                                                                            width="170"
                                                                                            src="{{asset('storage/files/' . ($setting->logo ?? 'default.png'))}}"
                                                                                            alt="logo"></a>
        </div>
        <div class="site-menu d-none d-xl-block">
            <ul class="main-menu">
                <li class="nav-item"><a class="nav-link" href="{{route('home')}} ">{{__('lang.Home')}}</a></li>

                <li class="nav-item"><a class="nav-link" href="#">{{__('lang.Pages')}} <i
                            class="fa-solid fa-chevron-down"></i></a>
                    <ul class="submenu">
                        <li><a class="nav-link" href="{{route('about')}}">{{__('lang.About Us')}}</a></li>
                        <li><a class="nav-link" href="{{route('front.Opinion')}}">{{__('lang.Opinion')}}</a></li>
                        <li><a class="nav-link" href="{{route('front.faq')}}">{{__('lang.FAQ')}}</a></li>
                        <li><a class="nav-link" href="{{route('front.contact')}}"> {{__('lang.Contact us')}}</a></li>
                    </ul>
                </li>

                <!-- خدماتنا -->
                <li class="nav-item"><a class="nav-link" href="#">{{__('lang.Services')}} <i
                            class="fa-solid fa-chevron-down"></i></a>
                    <ul class="submenu">
                        <li><a class="nav-link" href="{{route('front.services')}}">{{__('lang.Services')}}</a></li>
                        <li><a class="nav-link" href="{{route('front.plans')}}">{{__('lang.Plans')}}</a></li>
                    </ul>
                </li>

                <!-- أعمالنا -->
                <li class="nav-item"><a class="nav-link" href="{{route('front.our_work')}}">{{__('lang.Our work')}}</a>
                </li>
                <li class="nav-item"><a class="nav-link" href="#">{{__('lang.Knowledgebases')}} <i
                            class="fa-solid fa-chevron-down"></i></a>
                    <ul class="submenu">
                        @php
                            $knowledgebases = App\Models\Knowledgebase::get();
                        @endphp
                        @foreach ($knowledgebases as $knowledgebase)
                            <li><a class="nav-link"
                                   href="{{route('front.knowledgebases',$knowledgebase->id)}}">
                                    {{ app()->getLocale() == 'ar' ? $knowledgebase->title_ar : $knowledgebase->title_en }}
                                </a></li>
                        @endforeach
                    </ul>
                <li class="nav-item"><a class="nav-link" href="{{route('front.blogs')}}">{{__('lang.Blog')}} </a></li>

            </ul>

        </div>

        <div style="line-height: 5;" class="mbi">
            <a class="btn btn-primary" href="{{ route('front.form') }}" target="_blank" title="احصل على استشارة">
                <i class="fa-solid fa-up-right-from-square"></i>
                احصل على استشارة
            </a>
        </div>
        <div style="margin-right: -40px" class="mbi">
            @if(LaravelLocalization::getCurrentLocale() == 'en')
                <a class="custom-btn" style="margin:29px 0px; " title="عربي"
                   href="{{ LaravelLocalization::getLocalizedURL('ar', null, [], true) }}">عربي</a>
            @else
                <a class="custom-btn" style="margin:29px 0px; " title="English"
                   href="{{ LaravelLocalization::getLocalizedURL('en', null, [], true) }}">En</a>

            @endif
        </div>

        <div class="mobile-action d-block d-xl-none">
            <div class="mobile-hamburger">
                <a class="hamburger" href="#" data-bs-toggle="offcanvas" data-bs-target="#menuOffcanvas"
                   aria-controls="menuOffcanvas">
            <span class="hamburger-container">
              <span class="hamburger-inner"></span>
              <span class="hamburger-hidden"></span>
            </span>
                </a>
            </div>
        </div>

    </div>
</header>

<!--=================================
  Main Menu OffCanvas -->
<div class="offcanvas main-menu-offcanvas offcanvas-end" tabindex="-1" id="menuOffcanvas"
     aria-labelledby="menuOffcanvasLabel">
    <div class="offcanvas-header">
        <a id="menuOffcanvasLabel" class="navbar-brand" href="{{route('home')}}"><img class="img-fluid"
                                                                                      src="{{asset('storage/files/' . ($setting->logo ?? 'default.png'))}}"
                                                                                      alt="logo"></a>
        <button type="button" class="btn-close" style=" transform-origin: rigt center;" data-bs-dismiss="offcanvas"
                aria-label="Close"><i
                class="fa-solid fa-xmark"></i></button>
    </div>
    <div class="offcanvas-body lenis-scroll-disable">
        <div class="body-inner">
            <nav class="navbar">
                <ul class="navbar-nav">
                    <!-- الرئيسية -->


                    <li class="nav-item dropdown">
                        <a class="nav-link " href="{{route('home')}}">{{__('lang.Home')}}</a>
                    </li>

                    <!-- الصفحات -->
                    <li class="nav-item dropdown">
                        <a class="nav-link dropdown-toggle" href="#" role="button" data-bs-toggle="dropdown"
                           aria-expanded="false">{{__('lang.Pages')}}</a>
                        <ul class="dropdown-menu">
                            <li><a class="dropdown-item" href="{{route('about')}}">{{__('lang.About Us')}}</a></li>
                            <li><a class="dropdown-item" href="{{route('front.Opinion')}}l">{{__('lang.Opinion')}}</a>
                            </li>
                            <li><a class="dropdown-item" href="{{route('front.faq')}}">{{__('lang.FAQ')}}</a></li>
                            <li><a class="dropdown-item" href="{{route('front.contact')}}">{{__('lang.Contact us')}}</a>
                            </li>
                        </ul>
                    </li>

                    <!-- خدماتنا -->
                    <li class="nav-item dropdown">
                        <a class="nav-link dropdown-toggle" href="#" role="button" data-bs-toggle="dropdown"
                           aria-expanded="false">{{__('lang.Services')}}</a>
                        <ul class="dropdown-menu">
                            <li><a class="dropdown-item" href="{{route('front.services')}}">{{__('lang.Services')}}</a>
                            </li>
                            <li><a class="dropdown-item" href="{{route('front.plans')}}">{{__('lang.Plans')}}</a></li>
                        </ul>
                    </li>

                    <li class="nav-item dropdown"><a class="nav-link dropdown-toggle" role="button"
                                                     data-bs-toggle="dropdown"
                                                     aria-expanded="false" href="#">{{__('lang.Knowledgebases')}}  </a>
                        <ul class="dropdown-menu">
                            @php
                                $knowledgebases = App\Models\knowledgebase::get();
                            @endphp
                            @foreach ($knowledgebases as $knowledgebase)
                                <li><a class="dropdown-item"
                                       href="{{route('front.knowledgebases',$knowledgebase->id)}}">
                                        {{ app()->getLocale() == 'ar' ? $knowledgebase->title_ar : $knowledgebase->title_en }}
                                    </a></li>
                            @endforeach
                        </ul>

                        <!-- أعمالنا -->
                    <li class="nav-item dropdown">
                        <a class="nav-link " href="{{route('front.our_work')}}"
                           role="button">{{__('lang.Our Work')}}</a>
                    </li>


                    <!-- المدونة -->
                    <li class="nav-item dropdown">
                        <a class="nav-link dropdown-toggle" href="{{route('front.blogs')}}">{{__('lang.Blog')}}</a>
                    </li>


                    @if(LaravelLocalization::getCurrentLocale() == 'en')
                        <li class="nav-item dropdown">
                            <a class="nav-link" title="عربي"
                               href="{{ LaravelLocalization::getLocalizedURL('ar', null, [], true) }}">عربي</a>
                        </li>

                    @else
                        <li class="nav-item dropdown">
                            <a class="nav-link"  title="English"
                               href="{{ LaravelLocalization::getLocalizedURL('en', null, [], true) }}">En</a>
                        </li>


                    @endif


                </ul>

            </nav>


        </div>
    </div>
</div>
