@extends('Frontend.Layouts.app')
@section('title', 'Business Mail')
@section('content')
    <!-- HEADER AREA -->
        @include('Frontend.Includes.Headers.headerOne')
    <!-- HEADER AREA END -->

    <!-- shared hosting banner -->
    <div class="rts-hosting-banner rts-hosting-banner-bg banner-default-height">
        <div class="container">
            <div class="row justify-content-sm-center">
                <div class="banner-area">
                    <div class="rts-hosting-banner rts-hosting-banner__content business-mail-banner">
                        <span class="starting__price" data-sal="slide-down" data-sal-delay="100" data-sal-duration="800">Business Mail</span>
                        <h1 class="banner-title" data-sal="slide-down" data-sal-delay="200" data-sal-duration="800">
                            Professional Business Email
                        </h1>
                        <p class="slogan" data-sal="slide-down" data-sal-delay="300" data-sal-duration="800">Buy business email addresses from Titan. Look professional and build trust for your brand.</p>
                        <div class="hosting-action">
                            <a href="{{route('pricing')}}" class="btn__two secondary__bg secondary__color">Start Now <i class="fa-regular fa-arrow-right"></i></a>
                        </div>
                    </div>
                    <div class="rts-hosting-banner__image business-mail__image">
                        <img src="{{asset ('assets/images/banner/banner__business__mail__image.svg') }}" alt="">
                        <img class="shape-image one" src="{{asset ('assets/images/banner/banner__business__mail__image-sm1.svg') }}" alt="">
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- shared hosting banner end-->

    <!-- HOSTIE FEATURE AREA -->
    <section class="rts-feature-six section__padding business">
        <div class="container">
            <div class="row">
                <div class="rts-section text-center">
                    <h2 class="rts-section__title" data-sal="slide-down" data-sal-delay="100" data-sal-duration="800">Hostie Email Key Features</h2>
                    <p class="rts-section__description" data-sal="slide-down" data-sal-delay="300" data-sal-duration="800">Powerful and Unique Tools for Your Email Inbox</p>
                </div>
            </div>
            <div class="row gy-30 justify-content-sm-center">
                <div class="col-lg-3 col-md-6 col-sm-10" data-sal="slide-down" data-sal-delay="500" data-sal-duration="800">
                    <div class="single__feature">
                        <div class="single__feature--box text-center">
                            <div class="single__feature--box-icon m-auto">
                                <img src="{{asset ('assets/images/feature/feature-08.svg') }}" alt="">
                            </div>
                            <h5 class="single__feature--box-title">
                                Multi Account Access
                            </h5>
                            <p class="single__feature--box-description">
                                Maintain and access all of your accounts in one place.
                            </p>
                        </div>
                    </div>
                </div>

                <div class="col-lg-3 col-md-6 col-sm-10" data-sal="slide-down" data-sal-delay="600" data-sal-duration="800">
                    <div class="single__feature">
                        <div class="single__feature--box text-center">
                            <div class="single__feature--box-icon m-auto">
                                <img src="{{asset ('assets/images/feature/feature-09.svg') }}" alt="">
                            </div>
                            <h5 class="single__feature--box-title">
                                Webmail & Mobile App
                            </h5>
                            <p class="single__feature--box-description">
                                So your conversations continue no matter where you are.
                            </p>
                        </div>
                    </div>
                </div>

                <div class="col-lg-3 col-md-6 col-sm-10" data-sal="slide-down" data-sal-delay="700" data-sal-duration="800">
                    <div class="single__feature">
                        <div class="single__feature--box text-center">
                            <div class="single__feature--box-icon m-auto">
                                <img src="{{asset ('assets/images/feature/feature-10.svg') }}" alt="">
                            </div>
                            <h5 class="single__feature--box-title">
                                Email Migration Tools
                            </h5>
                            <p class="single__feature--box-description">
                                Don't start from scratch: bring along existing emails
                            </p>
                        </div>
                    </div>
                </div>

                <div class="col-lg-3 col-md-6 col-sm-10" data-sal="slide-down" data-sal-delay="800" data-sal-duration="800">
                    <div class="single__feature">
                        <div class="single__feature--box text-center">
                            <div class="single__feature--box-icon m-auto">
                                <img src="{{asset ('assets/images/feature/feature-11.svg') }}" alt="">
                            </div>
                            <h5 class="single__feature--box-title">
                                Undo & Fix Emails
                            </h5>
                            <p class="single__feature--box-description">
                                Mistakes happen and you can fix them. Undo a sent email
                            </p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- HOSTIE FEATURE AREA END -->

    <!-- PRICING PLAN START -->
    <div class="rts-pricing-plan alice__blue section__padding">
        <div class="container">
            <div class="row justify-content-center">
                <div class="rts-section text-center">
                    <h2 class="rts-section__title" data-sal="slide-down" data-sal-delay="100" data-sal-duration="800">Purchase Email Hosting Plan</h2>
                    <p class="rts-section__description w-420" data-sal="slide-down" data-sal-delay="200" data-sal-duration="800">Globally incubate next-generation e-services via state of the art technology.
                    </p>
                </div>
            </div>
            <div class="row">
                <div class="row justify-content-center">
                    <div class="col-lg-3 col-md-5">
                        <div class="rts-pricing-plan__tab plan__tab">
                            <div class="tab__button">
                                <div class="tab__button__item">
                                    <button class="active tab__price text-white" data-tab="monthly">monthly</button>
                                    <button class="tab__price text-white" data-tab="yearly">yearly</button>
                                </div>
                            </div>
                            <div class="discount">
                                <span class="line"><img src="{{asset ('assets/images/pricing/offer__vactor.svg') }}" height="20" width="85" alt=""></span>
                                <p>20% save</p>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- PRICING PLAN -->
                <div class="price__content open" id="monthly">
                    <div class="row g-30 monthly">
                        <!-- single card -->
                        <div class="col-lg-3 col-md-6 col-sm-6">
                            <div class="card-plan">
                                <div class="card-plan__package">
                                    <div class="icon">
                                        <img src="{{asset ('assets/images/pricing/basic.svg') }}" height="30" width="30" alt="">
                                    </div>
                                    <h4 class="package__name">Basic</h4>
                                </div>
                                <p class="card-plan__desc">Everything need to your website</p>
                                <div class="card-plan__offer">
                                    <span class="past-price">$6.63</span>
                                    <span class="offer-given">Save 60%</span>
                                </div>
                                <h5 class="card-plan__price">
                                    <sup>$</sup> 3.63 <sub>/ month</sub>
                                </h5>
                                <div class="card-plan__cartbtn">
                                    <a href="#">add to cart</a>
                                </div>
                                <p class="card-plan__renew-price">
                                    $ 6.99 /mo when you renew
                                </p>
                                <div class="card-plan__feature">
                                    <ul class="card-plan__feature--list">
                                        <li class="card-plan__feature--list-item">
                                            <span class="text"><i class="fa-regular fa-check"></i> 1 Website</span>
                                            <span class="tolltip" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Explore, discover, and learn on our innovative and informative website."><i class="fa-light fa-circle-question"></i></span>
                                        </li>
                                        <li class="card-plan__feature--list-item">
                                            <span class="text"><i class="fa-regular fa-check"></i> Standard Performance</span>
                                            <span class="tolltip" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Unlock superior online experiences with our standard performance solutions, ensuring reliability, speed, and seamless functionality for your website needs."><i class="fa-light fa-circle-question"></i></span>
                                        </li>
                                        <li class="card-plan__feature--list-item">
                                            <span class="text"><i class="fa-regular fa-check"></i> 24/7/365 Support</span>
                                            <span class="tolltip" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Hostie provides reliable 24/7 support for your hosting needs, ensuring assistance whenever you require help."><i class="fa-light fa-circle-question"></i></span>
                                        </li>
                                        <li class="card-plan__feature--list-item">
                                            <span class="text"><i class="fa-regular fa-xmark"></i> Free Email</span>
                                            <span class="tolltip" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Hostie offers complimentary email services, empowering your online communication with reliable and secure free email solutions."><i class="fa-light fa-circle-question"></i></span>
                                        </li>
                                        <li class="card-plan__feature--list-item">
                                            <span class="text"><i class="fa-regular fa-xmark"></i> Unlimited Bandwidth</span>
                                            <span class="tolltip" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Hostie provides unlimited bandwidth, ensuring seamless data transfer for your website's optimal performance and user experience."><i class="fa-light fa-circle-question"></i></span>
                                        </li>
                                        <li class="card-plan__feature--list-item">
                                            <span class="text"><i class="fa-regular fa-xmark"></i> 100 GB SSD Storage</span>
                                            <span class="tolltip" data-bs-toggle="tooltip" data-bs-placement="bottom"
                                            title="Elevate your online presence with Hostie, offering unlimited bandwidth for your domain, ensuring optimal performance and seamless data flow."><i class="fa-light fa-circle-question"></i></span>
                                        </li>


                                        <li class="card-plan__feature--list-item">
                                            <span class="text"><i class="fa-regular fa-check"></i> Unlimited Free SSL</span>
                                            <span class="tolltip" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Secure your website with Hostie's unlimited free SSL certificates, ensuring encrypted and safe online transactions for your users."><i class="fa-light fa-circle-question"></i></span>
                                        </li>
                                        <li class="card-plan__feature--list-item">
                                            <span class="text"><i class="fa-regular fa-check"></i> 99.9% Uptime Guarantee</span>
                                            <span class="tolltip" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Hostie guarantees 99% uptime, ensuring your website is consistently available and reliable for visitors around the clock."><i class="fa-light fa-circle-question"></i></span>
                                        </li>
                                        <li class="card-plan__feature--list-item">
                                            <span class="text"><i class="fa-regular fa-xmark"></i> Web Application Firewall</span>
                                            <span class="tolltip" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Enhance your website's security with Hostie's Web Application Firewall, protecting against online threats and ensuring a safe online environment."><i class="fa-light fa-circle-question"></i></span>
                                        </li>
                                        <li class="card-plan__feature--list-trigered">
                                            <span class="text">More Features <i class="fa-sharp fa-regular fa-chevron-down"></i>
                                            </span>
                                        </li>
                                    </ul>
                                    <ul class="card-plan__feature--list more__feature">
                                        <li class="card-plan__feature--list-item">
                                            <span class="text"><i class="fa-regular fa-check"></i> 100 GB SSD Storage</span>
                                            <span class="tolltip" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Hostie offers generous hosting with 100GB SSD storage, providing ample space for your data and ensuring high-performance storage solutions."><i class="fa-light fa-circle-question"></i></span>
                                        </li>
                                        <li class="card-plan__feature--list-item">
                                            <span class="text"><i class="fa-regular fa-check"></i> Unlimited Free SSL</span>
                                            <span class="tolltip" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Secure your website with Hostie's unlimited free SSL certificates, ensuring encrypted and safe online transactions for your users."><i class="fa-light fa-circle-question"></i></span>
                                        </li>
                                        <li class="card-plan__feature--list-item">
                                            <span class="text"><i class="fa-regular fa-check"></i> 99.9% Uptime Guarantee</span>
                                            <span class="tolltip" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Hostie guarantees 99% uptime, ensuring your website is consistently available and reliable for visitors around the clock."><i class="fa-light fa-circle-question"></i></span>
                                        </li>
                                        <li class="card-plan__feature--list-item">
                                            <span class="text"><i class="fa-regular fa-xmark"></i> Web Application Firewall</span>
                                            <span class="tolltip" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Enhance your website's security with Hostie's Web Application Firewall, protecting against online threats and ensuring a safe online environment."><i class="fa-light fa-circle-question"></i></span>
                                        </li>
                                        <li class="card-plan__feature--list-trigered">
                                            <span class="text">See less Features <i class="fa-sharp fa-regular fa-chevron-up"></i>
                                            </span>
                                        </li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                        <!-- single card end -->
                        <!-- single card -->
                        <div class="col-lg-3 col-md-6 col-sm-6">
                            <div class="card-plan">
                                <div class="card-plan__package">
                                    <div class="icon">
                                        <img src="{{asset ('assets/images/pricing/premium.svg') }}" height="30" width="30" alt="">
                                    </div>
                                    <h4 class="package__name">Premium</h4>
                                </div>
                                <p class="card-plan__desc">Level-up more power features</p>
                                <div class="card-plan__offer">
                                    <span class="past-price">$12.63</span>
                                    <span class="offer-given">Save 60%</span>
                                </div>
                                <h5 class="card-plan__price">
                                    <sup>$</sup> 6.63 <sub>/ month</sub>
                                </h5>
                                <div class="card-plan__cartbtn">
                                    <a href="#">add to cart</a>
                                </div>
                                <p class="card-plan__renew-price">
                                    $ 6.99 /mo when you renew
                                </p>
                                <div class="card-plan__feature">
                                    <ul class="card-plan__feature--list">
                                        <li class="card-plan__feature--list-item">
                                            <span class="text"><i class="fa-regular fa-check"></i> 1 Website</span>
                                            <span class="tolltip" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Explore, discover, and learn on our innovative and informative website."><i class="fa-light fa-circle-question"></i></span>
                                        </li>
                                        <li class="card-plan__feature--list-item">
                                            <span class="text"><i class="fa-regular fa-check"></i> Standard Performance</span>
                                            <span class="tolltip" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Unlock superior online experiences with our standard performance solutions, ensuring reliability, speed, and seamless functionality for your website needs."><i class="fa-light fa-circle-question"></i></span>
                                        </li>
                                        <li class="card-plan__feature--list-item">
                                            <span class="text"><i class="fa-regular fa-check"></i> 24/7/365 Support</span>
                                            <span class="tolltip" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Hostie provides reliable 24/7 support for your hosting needs, ensuring assistance whenever you require help."><i class="fa-light fa-circle-question"></i></span>
                                        </li>
                                        <li class="card-plan__feature--list-item">
                                            <span class="text"><i class="fa-regular fa-xmark"></i> Free Email</span>
                                            <span class="tolltip" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Hostie offers complimentary email services, empowering your online communication with reliable and secure free email solutions."><i class="fa-light fa-circle-question"></i></span>
                                        </li>
                                        <li class="card-plan__feature--list-item">
                                            <span class="text"><i class="fa-regular fa-xmark"></i> Unlimited Bandwidth</span>
                                            <span class="tolltip" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Hostie provides unlimited bandwidth, ensuring seamless data transfer for your website's optimal performance and user experience."><i class="fa-light fa-circle-question"></i></span>
                                        </li>
                                        <li class="card-plan__feature--list-item">
                                            <span class="text"><i class="fa-regular fa-xmark"></i> 100 GB SSD Storage</span>
                                            <span class="tolltip" data-bs-toggle="tooltip" data-bs-placement="bottom"
                                            title="Elevate your online presence with Hostie, offering unlimited bandwidth for your domain, ensuring optimal performance and seamless data flow."><i class="fa-light fa-circle-question"></i></span>
                                        </li>


                                        <li class="card-plan__feature--list-item">
                                            <span class="text"><i class="fa-regular fa-check"></i> Unlimited Free SSL</span>
                                            <span class="tolltip" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Secure your website with Hostie's unlimited free SSL certificates, ensuring encrypted and safe online transactions for your users."><i class="fa-light fa-circle-question"></i></span>
                                        </li>
                                        <li class="card-plan__feature--list-item">
                                            <span class="text"><i class="fa-regular fa-check"></i> 99.9% Uptime Guarantee</span>
                                            <span class="tolltip" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Hostie guarantees 99% uptime, ensuring your website is consistently available and reliable for visitors around the clock."><i class="fa-light fa-circle-question"></i></span>
                                        </li>
                                        <li class="card-plan__feature--list-item">
                                            <span class="text"><i class="fa-regular fa-check"></i> Web Application Firewall</span>
                                            <span class="tolltip" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Enhance your website's security with Hostie's Web Application Firewall, protecting against online threats and ensuring a safe online environment."><i class="fa-light fa-circle-question"></i></span>
                                        </li>
                                        <li class="card-plan__feature--list-trigered">
                                            <span class="text">More Features <i class="fa-sharp fa-regular fa-chevron-down"></i>
                                            </span>
                                        </li>
                                    </ul>
                                    <ul class="card-plan__feature--list more__feature">
                                        <li class="card-plan__feature--list-item">
                                            <span class="text"><i class="fa-regular fa-check"></i> 100 GB SSD Storage</span>
                                            <span class="tolltip" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Hostie offers generous hosting with 100GB SSD storage, providing ample space for your data and ensuring high-performance storage solutions."><i class="fa-light fa-circle-question"></i></span>
                                        </li>
                                        <li class="card-plan__feature--list-item">
                                            <span class="text"><i class="fa-regular fa-check"></i> Unlimited Free SSL</span>
                                            <span class="tolltip" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Secure your website with Hostie's unlimited free SSL certificates, ensuring encrypted and safe online transactions for your users."><i class="fa-light fa-circle-question"></i></span>
                                        </li>
                                        <li class="card-plan__feature--list-item">
                                            <span class="text"><i class="fa-regular fa-check"></i> 99.9% Uptime Guarantee</span>
                                            <span class="tolltip" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Hostie guarantees 99% uptime, ensuring your website is consistently available and reliable for visitors around the clock."><i class="fa-light fa-circle-question"></i></span>
                                        </li>
                                        <li class="card-plan__feature--list-item">
                                            <span class="text"><i class="fa-regular fa-xmark"></i> Web Application Firewall</span>
                                            <span class="tolltip" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Enhance your website's security with Hostie's Web Application Firewall, protecting against online threats and ensuring a safe online environment."><i class="fa-light fa-circle-question"></i></span>
                                        </li>
                                        <li class="card-plan__feature--list-trigered">
                                            <span class="text">See less Features <i class="fa-sharp fa-regular fa-chevron-up"></i>
                                            </span>
                                        </li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                        <!-- single card end -->
                        <!-- single card -->
                        <div class="col-lg-3 col-md-6 col-sm-6">
                            <div class="card-plan active">
                                <div class="popular-tag">most popular</div>
                                <div class="card-plan__package">
                                    <div class="icon">
                                        <img src="{{asset ('assets/images/pricing/business.svg') }}" height="30" width="30" alt="">
                                    </div>
                                    <h4 class="package__name">Business</h4>
                                </div>
                                <p class="card-plan__desc">Everything need to your website</p>
                                <div class="card-plan__offer">
                                    <span class="past-price">$19.63</span>
                                    <span class="offer-given">Save 60%</span>
                                </div>
                                <h5 class="card-plan__price">
                                    <sup>$</sup> 8.63 <sub>/ month</sub>
                                </h5>
                                <div class="card-plan__cartbtn">
                                    <a href="#">add to cart</a>
                                </div>
                                <p class="card-plan__renew-price">
                                    $ 6.99 /mo when you renew
                                </p>
                                <div class="card-plan__feature">
                                    <ul class="card-plan__feature--list">
                                        <li class="card-plan__feature--list-item">
                                            <span class="text"><i class="fa-regular fa-check"></i> 1 Website</span>
                                            <span class="tolltip" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Explore, discover, and learn on our innovative and informative website."><i class="fa-light fa-circle-question"></i></span>
                                        </li>
                                        <li class="card-plan__feature--list-item">
                                            <span class="text"><i class="fa-regular fa-check"></i> Standard Performance</span>
                                            <span class="tolltip" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Unlock superior online experiences with our standard performance solutions, ensuring reliability, speed, and seamless functionality for your website needs."><i class="fa-light fa-circle-question"></i></span>
                                        </li>
                                        <li class="card-plan__feature--list-item">
                                            <span class="text"><i class="fa-regular fa-check"></i> 24/7/365 Support</span>
                                            <span class="tolltip" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Hostie provides reliable 24/7 support for your hosting needs, ensuring assistance whenever you require help."><i class="fa-light fa-circle-question"></i></span>
                                        </li>
                                        <li class="card-plan__feature--list-item">
                                            <span class="text"><i class="fa-regular fa-xmark"></i> Free Email</span>
                                            <span class="tolltip" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Hostie offers complimentary email services, empowering your online communication with reliable and secure free email solutions."><i class="fa-light fa-circle-question"></i></span>
                                        </li>
                                        <li class="card-plan__feature--list-item">
                                            <span class="text"><i class="fa-regular fa-xmark"></i> Unlimited Bandwidth</span>
                                            <span class="tolltip" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Hostie provides unlimited bandwidth, ensuring seamless data transfer for your website's optimal performance and user experience."><i class="fa-light fa-circle-question"></i></span>
                                        </li>
                                        <li class="card-plan__feature--list-item">
                                            <span class="text"><i class="fa-regular fa-check"></i> 100 GB SSD Storage</span>
                                            <span class="tolltip" data-bs-toggle="tooltip" data-bs-placement="bottom"
                                            title="Elevate your online presence with Hostie, offering unlimited bandwidth for your domain, ensuring optimal performance and seamless data flow."><i class="fa-light fa-circle-question"></i></span>
                                        </li>


                                        <li class="card-plan__feature--list-item">
                                            <span class="text"><i class="fa-regular fa-check"></i> Unlimited Free SSL</span>
                                            <span class="tolltip" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Secure your website with Hostie's unlimited free SSL certificates, ensuring encrypted and safe online transactions for your users."><i class="fa-light fa-circle-question"></i></span>
                                        </li>
                                        <li class="card-plan__feature--list-item">
                                            <span class="text"><i class="fa-regular fa-check"></i> 99.9% Uptime Guarantee</span>
                                            <span class="tolltip" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Hostie guarantees 99% uptime, ensuring your website is consistently available and reliable for visitors around the clock."><i class="fa-light fa-circle-question"></i></span>
                                        </li>
                                        <li class="card-plan__feature--list-item">
                                            <span class="text"><i class="fa-regular fa-check"></i> Web Application Firewall</span>
                                            <span class="tolltip" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Enhance your website's security with Hostie's Web Application Firewall, protecting against online threats and ensuring a safe online environment."><i class="fa-light fa-circle-question"></i></span>
                                        </li>
                                        <li class="card-plan__feature--list-trigered">
                                            <span class="text">More Features <i class="fa-sharp fa-regular fa-chevron-down"></i>
                                            </span>
                                        </li>
                                    </ul>
                                    <ul class="card-plan__feature--list more__feature">
                                        <li class="card-plan__feature--list-item">
                                            <span class="text"><i class="fa-regular fa-check"></i> 100 GB SSD Storage</span>
                                            <span class="tolltip" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Hostie offers generous hosting with 100GB SSD storage, providing ample space for your data and ensuring high-performance storage solutions."><i class="fa-light fa-circle-question"></i></span>
                                        </li>
                                        <li class="card-plan__feature--list-item">
                                            <span class="text"><i class="fa-regular fa-check"></i> Unlimited Free SSL</span>
                                            <span class="tolltip" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Secure your website with Hostie's unlimited free SSL certificates, ensuring encrypted and safe online transactions for your users."><i class="fa-light fa-circle-question"></i></span>
                                        </li>
                                        <li class="card-plan__feature--list-item">
                                            <span class="text"><i class="fa-regular fa-check"></i> 99.9% Uptime Guarantee</span>
                                            <span class="tolltip" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Hostie guarantees 99% uptime, ensuring your website is consistently available and reliable for visitors around the clock."><i class="fa-light fa-circle-question"></i></span>
                                        </li>
                                        <li class="card-plan__feature--list-item">
                                            <span class="text"><i class="fa-regular fa-xmark"></i> Web Application Firewall</span>
                                            <span class="tolltip" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Enhance your website's security with Hostie's Web Application Firewall, protecting against online threats and ensuring a safe online environment."><i class="fa-light fa-circle-question"></i></span>
                                        </li>
                                        <li class="card-plan__feature--list-trigered">
                                            <span class="text">See less Features <i class="fa-sharp fa-regular fa-chevron-up"></i>
                                            </span>
                                        </li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                        <!-- single card end -->
                        <!-- single card -->
                        <div class="col-lg-3 col-md-6 col-sm-6">
                            <div class="card-plan ">

                                <div class="card-plan__package">
                                    <div class="icon">
                                        <img src="{{asset ('assets/images/pricing/cloud.svg') }}" height="30" width="30" alt="">
                                    </div>
                                    <h4 class="package__name">Cloud Startup</h4>
                                </div>
                                <p class="card-plan__desc">Everything need to your website</p>
                                <div class="card-plan__offer">
                                    <span class="past-price">$29.63</span>
                                    <span class="offer-given">Save 60%</span>
                                </div>
                                <h5 class="card-plan__price">
                                    <sup>$</sup> 11.63 <sub>/ month</sub>
                                </h5>
                                <div class="card-plan__cartbtn">
                                    <a href="#">add to cart</a>
                                </div>
                                <p class="card-plan__renew-price">
                                    $ 6.99 /mo when you renew
                                </p>
                                <div class="card-plan__feature">
                                    <ul class="card-plan__feature--list">
                                        <li class="card-plan__feature--list-item">
                                            <span class="text"><i class="fa-regular fa-check"></i> 1 Website</span>
                                            <span class="tolltip" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Explore, discover, and learn on our innovative and informative website."><i class="fa-light fa-circle-question"></i></span>
                                        </li>
                                        <li class="card-plan__feature--list-item">
                                            <span class="text"><i class="fa-regular fa-check"></i> Standard Performance</span>
                                            <span class="tolltip" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Unlock superior online experiences with our standard performance solutions, ensuring reliability, speed, and seamless functionality for your website needs."><i class="fa-light fa-circle-question"></i></span>
                                        </li>
                                        <li class="card-plan__feature--list-item">
                                            <span class="text"><i class="fa-regular fa-check"></i> 24/7/365 Support</span>
                                            <span class="tolltip" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Hostie provides reliable 24/7 support for your hosting needs, ensuring assistance whenever you require help."><i class="fa-light fa-circle-question"></i></span>
                                        </li>
                                        <li class="card-plan__feature--list-item">
                                            <span class="text"><i class="fa-regular fa-check"></i> Free Email</span>
                                            <span class="tolltip" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Hostie offers complimentary email services, empowering your online communication with reliable and secure free email solutions."><i class="fa-light fa-circle-question"></i></span>
                                        </li>
                                        <li class="card-plan__feature--list-item">
                                            <span class="text"><i class="fa-regular fa-check"></i> Unlimited Bandwidth</span>
                                            <span class="tolltip" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Hostie provides unlimited bandwidth, ensuring seamless data transfer for your website's optimal performance and user experience."><i class="fa-light fa-circle-question"></i></span>
                                        </li>
                                        <li class="card-plan__feature--list-item">
                                            <span class="text"><i class="fa-regular fa-check"></i> 100 GB SSD Storage</span>
                                            <span class="tolltip" data-bs-toggle="tooltip" data-bs-placement="bottom"
                                            title="Elevate your online presence with Hostie, offering unlimited bandwidth for your domain, ensuring optimal performance and seamless data flow."><i class="fa-light fa-circle-question"></i></span>
                                        </li>


                                        <li class="card-plan__feature--list-item">
                                            <span class="text"><i class="fa-regular fa-check"></i> Unlimited Free SSL</span>
                                            <span class="tolltip" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Secure your website with Hostie's unlimited free SSL certificates, ensuring encrypted and safe online transactions for your users."><i class="fa-light fa-circle-question"></i></span>
                                        </li>
                                        <li class="card-plan__feature--list-item">
                                            <span class="text"><i class="fa-regular fa-check"></i> 99.9% Uptime Guarantee</span>
                                            <span class="tolltip" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Hostie guarantees 99% uptime, ensuring your website is consistently available and reliable for visitors around the clock."><i class="fa-light fa-circle-question"></i></span>
                                        </li>
                                        <li class="card-plan__feature--list-item">
                                            <span class="text"><i class="fa-regular fa-check"></i> Web Application Firewall</span>
                                            <span class="tolltip" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Enhance your website's security with Hostie's Web Application Firewall, protecting against online threats and ensuring a safe online environment."><i class="fa-light fa-circle-question"></i></span>
                                        </li>
                                        <li class="card-plan__feature--list-trigered">
                                            <span class="text">More Features <i class="fa-sharp fa-regular fa-chevron-down"></i>
                                            </span>
                                        </li>
                                    </ul>
                                    <ul class="card-plan__feature--list more__feature">
                                        <li class="card-plan__feature--list-item">
                                            <span class="text"><i class="fa-regular fa-check"></i> 100 GB SSD Storage</span>
                                            <span class="tolltip" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Hostie offers generous hosting with 100GB SSD storage, providing ample space for your data and ensuring high-performance storage solutions."><i class="fa-light fa-circle-question"></i></span>
                                        </li>
                                        <li class="card-plan__feature--list-item">
                                            <span class="text"><i class="fa-regular fa-check"></i> Unlimited Free SSL</span>
                                            <span class="tolltip" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Secure your website with Hostie's unlimited free SSL certificates, ensuring encrypted and safe online transactions for your users."><i class="fa-light fa-circle-question"></i></span>
                                        </li>
                                        <li class="card-plan__feature--list-item">
                                            <span class="text"><i class="fa-regular fa-check"></i> 99.9% Uptime Guarantee</span>
                                            <span class="tolltip" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Hostie guarantees 99% uptime, ensuring your website is consistently available and reliable for visitors around the clock."><i class="fa-light fa-circle-question"></i></span>
                                        </li>
                                        <li class="card-plan__feature--list-item">
                                            <span class="text"><i class="fa-regular fa-check"></i> Web Application Firewall</span>
                                            <span class="tolltip" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Enhance your website's security with Hostie's Web Application Firewall, protecting against online threats and ensuring a safe online environment."><i class="fa-light fa-circle-question"></i></span>
                                        </li>
                                        <li class="card-plan__feature--list-trigered">
                                            <span class="text">See less Features <i class="fa-sharp fa-regular fa-chevron-up"></i>
                                            </span>
                                        </li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                        <!-- single card end -->
                    </div>
                </div>

                <!-- PRICING PLAN -->
                <div class="price__content" id="yearly">
                    <div class="row g-30 yearly">
                        <!-- single card -->
                        <div class="col-lg-3 col-md-6 col-sm-6">
                            <div class="card-plan">
                                <div class="card-plan__package">
                                    <div class="icon">
                                        <img src="{{asset ('assets/images/pricing/basic.svg') }}" height="30" width="30" alt="">
                                    </div>
                                    <h4 class="package__name">Basic</h4>
                                </div>
                                <p class="card-plan__desc">Everything need to your website</p>
                                <div class="card-plan__offer">
                                    <span class="past-price">$79.63</span>
                                    <span class="offer-given">Save 60%</span>
                                </div>
                                <h5 class="card-plan__price">
                                    <sup>$</sup> 36.63 <sub>/ month</sub>
                                </h5>
                                <div class="card-plan__cartbtn">
                                    <a href="#">add to cart</a>
                                </div>
                                <p class="card-plan__renew-price">
                                    $ 79.99 /year when you renew
                                </p>
                                <div class="card-plan__feature">
                                    <ul class="card-plan__feature--list">
                                        <li class="card-plan__feature--list-item">
                                            <span class="text"><i class="fa-regular fa-check"></i> 1 Website</span>
                                            <span class="tolltip" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Explore, discover, and learn on our innovative and informative website."><i class="fa-light fa-circle-question"></i></span>
                                        </li>
                                        <li class="card-plan__feature--list-item">
                                            <span class="text"><i class="fa-regular fa-check"></i> Standard Performance</span>
                                            <span class="tolltip" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Unlock superior online experiences with our standard performance solutions, ensuring reliability, speed, and seamless functionality for your website needs."><i class="fa-light fa-circle-question"></i></span>
                                        </li>
                                        <li class="card-plan__feature--list-item">
                                            <span class="text"><i class="fa-regular fa-check"></i> 24/7/365 Support</span>
                                            <span class="tolltip" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Hostie provides reliable 24/7 support for your hosting needs, ensuring assistance whenever you require help."><i class="fa-light fa-circle-question"></i></span>
                                        </li>
                                        <li class="card-plan__feature--list-item">
                                            <span class="text"><i class="fa-regular fa-xmark"></i> Free Email</span>
                                            <span class="tolltip" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Hostie offers complimentary email services, empowering your online communication with reliable and secure free email solutions."><i class="fa-light fa-circle-question"></i></span>
                                        </li>
                                        <li class="card-plan__feature--list-item">
                                            <span class="text"><i class="fa-regular fa-xmark"></i> Unlimited Bandwidth</span>
                                            <span class="tolltip" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Hostie provides unlimited bandwidth, ensuring seamless data transfer for your website's optimal performance and user experience."><i class="fa-light fa-circle-question"></i></span>
                                        </li>
                                        <li class="card-plan__feature--list-item">
                                            <span class="text"><i class="fa-regular fa-xmark"></i> 100 GB SSD Storage</span>
                                            <span class="tolltip" data-bs-toggle="tooltip" data-bs-placement="bottom"
                                            title="Elevate your online presence with Hostie, offering unlimited bandwidth for your domain, ensuring optimal performance and seamless data flow."><i class="fa-light fa-circle-question"></i></span>
                                        </li>


                                        <li class="card-plan__feature--list-item">
                                            <span class="text"><i class="fa-regular fa-check"></i> Unlimited Free SSL</span>
                                            <span class="tolltip" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Secure your website with Hostie's unlimited free SSL certificates, ensuring encrypted and safe online transactions for your users."><i class="fa-light fa-circle-question"></i></span>
                                        </li>
                                        <li class="card-plan__feature--list-item">
                                            <span class="text"><i class="fa-regular fa-check"></i> 99.9% Uptime Guarantee</span>
                                            <span class="tolltip" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Hostie guarantees 99% uptime, ensuring your website is consistently available and reliable for visitors around the clock."><i class="fa-light fa-circle-question"></i></span>
                                        </li>
                                        <li class="card-plan__feature--list-item">
                                            <span class="text"><i class="fa-regular fa-xmark"></i> Web Application Firewall</span>
                                            <span class="tolltip" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Enhance your website's security with Hostie's Web Application Firewall, protecting against online threats and ensuring a safe online environment."><i class="fa-light fa-circle-question"></i></span>
                                        </li>
                                        <li class="card-plan__feature--list-trigered">
                                            <span class="text">More Features <i class="fa-sharp fa-regular fa-chevron-down"></i>
                                            </span>
                                        </li>
                                    </ul>
                                    <ul class="card-plan__feature--list more__feature">
                                        <li class="card-plan__feature--list-item">
                                            <span class="text"><i class="fa-regular fa-check"></i> 100 GB SSD Storage</span>
                                            <span class="tolltip" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Hostie offers generous hosting with 100GB SSD storage, providing ample space for your data and ensuring high-performance storage solutions."><i class="fa-light fa-circle-question"></i></span>
                                        </li>
                                        <li class="card-plan__feature--list-item">
                                            <span class="text"><i class="fa-regular fa-check"></i> Unlimited Free SSL</span>
                                            <span class="tolltip" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Secure your website with Hostie's unlimited free SSL certificates, ensuring encrypted and safe online transactions for your users."><i class="fa-light fa-circle-question"></i></span>
                                        </li>
                                        <li class="card-plan__feature--list-item">
                                            <span class="text"><i class="fa-regular fa-check"></i> 99.9% Uptime Guarantee</span>
                                            <span class="tolltip" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Hostie guarantees 99% uptime, ensuring your website is consistently available and reliable for visitors around the clock."><i class="fa-light fa-circle-question"></i></span>
                                        </li>
                                        <li class="card-plan__feature--list-item">
                                            <span class="text"><i class="fa-regular fa-xmark"></i> Web Application Firewall</span>
                                            <span class="tolltip" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Enhance your website's security with Hostie's Web Application Firewall, protecting against online threats and ensuring a safe online environment."><i class="fa-light fa-circle-question"></i></span>
                                        </li>
                                        <li class="card-plan__feature--list-trigered">
                                            <span class="text">See less Features <i class="fa-sharp fa-regular fa-chevron-up"></i>
                                            </span>
                                        </li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                        <!-- single card end -->
                        <!-- single card -->
                        <div class="col-lg-3 col-md-6 col-sm-6">
                            <div class="card-plan">
                                <div class="card-plan__package">
                                    <div class="icon">
                                        <img src="{{asset ('assets/images/pricing/premium.svg') }}" height="30" width="30" alt="">
                                    </div>
                                    <h4 class="package__name">Premium</h4>
                                </div>
                                <p class="card-plan__desc">Level-up more power features</p>
                                <div class="card-plan__offer">
                                    <span class="past-price">$151.63</span>
                                    <span class="offer-given">Save 60%</span>
                                </div>
                                <h5 class="card-plan__price">
                                    <sup>$</sup> 79.56 <sub>/ month</sub>
                                </h5>
                                <div class="card-plan__cartbtn">
                                    <a href="#">add to cart</a>
                                </div>
                                <p class="card-plan__renew-price">
                                    $ 151.99 /year when you renew
                                </p>
                                <div class="card-plan__feature">
                                    <ul class="card-plan__feature--list">
                                        <li class="card-plan__feature--list-item">
                                            <span class="text"><i class="fa-regular fa-check"></i> 1 Website</span>
                                            <span class="tolltip" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Explore, discover, and learn on our innovative and informative website."><i class="fa-light fa-circle-question"></i></span>
                                        </li>
                                        <li class="card-plan__feature--list-item">
                                            <span class="text"><i class="fa-regular fa-check"></i> Standard Performance</span>
                                            <span class="tolltip" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Unlock superior online experiences with our standard performance solutions, ensuring reliability, speed, and seamless functionality for your website needs."><i class="fa-light fa-circle-question"></i></span>
                                        </li>
                                        <li class="card-plan__feature--list-item">
                                            <span class="text"><i class="fa-regular fa-check"></i> 24/7/365 Support</span>
                                            <span class="tolltip" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Hostie provides reliable 24/7 support for your hosting needs, ensuring assistance whenever you require help."><i class="fa-light fa-circle-question"></i></span>
                                        </li>
                                        <li class="card-plan__feature--list-item">
                                            <span class="text"><i class="fa-regular fa-xmark"></i> Free Email</span>
                                            <span class="tolltip" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Hostie offers complimentary email services, empowering your online communication with reliable and secure free email solutions."><i class="fa-light fa-circle-question"></i></span>
                                        </li>
                                        <li class="card-plan__feature--list-item">
                                            <span class="text"><i class="fa-regular fa-xmark"></i> Unlimited Bandwidth</span>
                                            <span class="tolltip" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Hostie provides unlimited bandwidth, ensuring seamless data transfer for your website's optimal performance and user experience."><i class="fa-light fa-circle-question"></i></span>
                                        </li>
                                        <li class="card-plan__feature--list-item">
                                            <span class="text"><i class="fa-regular fa-xmark"></i> 100 GB SSD Storage</span>
                                            <span class="tolltip" data-bs-toggle="tooltip" data-bs-placement="bottom"
                                            title="Elevate your online presence with Hostie, offering unlimited bandwidth for your domain, ensuring optimal performance and seamless data flow."><i class="fa-light fa-circle-question"></i></span>
                                        </li>


                                        <li class="card-plan__feature--list-item">
                                            <span class="text"><i class="fa-regular fa-check"></i> Unlimited Free SSL</span>
                                            <span class="tolltip" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Secure your website with Hostie's unlimited free SSL certificates, ensuring encrypted and safe online transactions for your users."><i class="fa-light fa-circle-question"></i></span>
                                        </li>
                                        <li class="card-plan__feature--list-item">
                                            <span class="text"><i class="fa-regular fa-check"></i> 99.9% Uptime Guarantee</span>
                                            <span class="tolltip" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Hostie guarantees 99% uptime, ensuring your website is consistently available and reliable for visitors around the clock."><i class="fa-light fa-circle-question"></i></span>
                                        </li>
                                        <li class="card-plan__feature--list-item">
                                            <span class="text"><i class="fa-regular fa-check"></i> Web Application Firewall</span>
                                            <span class="tolltip" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Enhance your website's security with Hostie's Web Application Firewall, protecting against online threats and ensuring a safe online environment."><i class="fa-light fa-circle-question"></i></span>
                                        </li>
                                        <li class="card-plan__feature--list-trigered">
                                            <span class="text">More Features <i class="fa-sharp fa-regular fa-chevron-down"></i>
                                            </span>
                                        </li>
                                    </ul>
                                    <ul class="card-plan__feature--list more__feature">
                                        <li class="card-plan__feature--list-item">
                                            <span class="text"><i class="fa-regular fa-check"></i> 100 GB SSD Storage</span>
                                            <span class="tolltip" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Hostie offers generous hosting with 100GB SSD storage, providing ample space for your data and ensuring high-performance storage solutions."><i class="fa-light fa-circle-question"></i></span>
                                        </li>
                                        <li class="card-plan__feature--list-item">
                                            <span class="text"><i class="fa-regular fa-check"></i> Unlimited Free SSL</span>
                                            <span class="tolltip" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Secure your website with Hostie's unlimited free SSL certificates, ensuring encrypted and safe online transactions for your users."><i class="fa-light fa-circle-question"></i></span>
                                        </li>
                                        <li class="card-plan__feature--list-item">
                                            <span class="text"><i class="fa-regular fa-check"></i> 99.9% Uptime Guarantee</span>
                                            <span class="tolltip" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Hostie guarantees 99% uptime, ensuring your website is consistently available and reliable for visitors around the clock."><i class="fa-light fa-circle-question"></i></span>
                                        </li>
                                        <li class="card-plan__feature--list-item">
                                            <span class="text"><i class="fa-regular fa-xmark"></i> Web Application Firewall</span>
                                            <span class="tolltip" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Enhance your website's security with Hostie's Web Application Firewall, protecting against online threats and ensuring a safe online environment."><i class="fa-light fa-circle-question"></i></span>
                                        </li>
                                        <li class="card-plan__feature--list-trigered">
                                            <span class="text">See less Features <i class="fa-sharp fa-regular fa-chevron-up"></i>
                                            </span>
                                        </li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                        <!-- single card end -->
                        <!-- single card -->
                        <div class="col-lg-3 col-md-6 col-sm-6">
                            <div class="card-plan active">
                                <div class="popular-tag">most popular</div>
                                <div class="card-plan__package">
                                    <div class="icon">
                                        <img src="{{asset ('assets/images/pricing/business.svg') }}" height="30" width="30" alt="">
                                    </div>
                                    <h4 class="package__name">Business</h4>
                                </div>
                                <p class="card-plan__desc">Everything need to your website</p>
                                <div class="card-plan__offer">
                                    <span class="past-price">$235.63</span>
                                    <span class="offer-given">Save 60%</span>
                                </div>
                                <h5 class="card-plan__price">
                                    <sup>$</sup> 103.63 <sub>/ month</sub>
                                </h5>
                                <div class="card-plan__cartbtn">
                                    <a href="#">add to cart</a>
                                </div>
                                <p class="card-plan__renew-price">
                                    $ 235.99 /mo when you renew
                                </p>
                                <div class="card-plan__feature">
                                    <ul class="card-plan__feature--list">
                                        <li class="card-plan__feature--list-item">
                                            <span class="text"><i class="fa-regular fa-check"></i> 1 Website</span>
                                            <span class="tolltip" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Explore, discover, and learn on our innovative and informative website."><i class="fa-light fa-circle-question"></i></span>
                                        </li>
                                        <li class="card-plan__feature--list-item">
                                            <span class="text"><i class="fa-regular fa-check"></i> Standard Performance</span>
                                            <span class="tolltip" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Unlock superior online experiences with our standard performance solutions, ensuring reliability, speed, and seamless functionality for your website needs."><i class="fa-light fa-circle-question"></i></span>
                                        </li>
                                        <li class="card-plan__feature--list-item">
                                            <span class="text"><i class="fa-regular fa-check"></i> 24/7/365 Support</span>
                                            <span class="tolltip" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Hostie provides reliable 24/7 support for your hosting needs, ensuring assistance whenever you require help."><i class="fa-light fa-circle-question"></i></span>
                                        </li>
                                        <li class="card-plan__feature--list-item">
                                            <span class="text"><i class="fa-regular fa-xmark"></i> Free Email</span>
                                            <span class="tolltip" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Hostie offers complimentary email services, empowering your online communication with reliable and secure free email solutions."><i class="fa-light fa-circle-question"></i></span>
                                        </li>
                                        <li class="card-plan__feature--list-item">
                                            <span class="text"><i class="fa-regular fa-xmark"></i> Unlimited Bandwidth</span>
                                            <span class="tolltip" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Hostie provides unlimited bandwidth, ensuring seamless data transfer for your website's optimal performance and user experience."><i class="fa-light fa-circle-question"></i></span>
                                        </li>
                                        <li class="card-plan__feature--list-item">
                                            <span class="text"><i class="fa-regular fa-check"></i> 100 GB SSD Storage</span>
                                            <span class="tolltip" data-bs-toggle="tooltip" data-bs-placement="bottom"
                                            title="Elevate your online presence with Hostie, offering unlimited bandwidth for your domain, ensuring optimal performance and seamless data flow."><i class="fa-light fa-circle-question"></i></span>
                                        </li>


                                        <li class="card-plan__feature--list-item">
                                            <span class="text"><i class="fa-regular fa-check"></i> Unlimited Free SSL</span>
                                            <span class="tolltip" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Secure your website with Hostie's unlimited free SSL certificates, ensuring encrypted and safe online transactions for your users."><i class="fa-light fa-circle-question"></i></span>
                                        </li>
                                        <li class="card-plan__feature--list-item">
                                            <span class="text"><i class="fa-regular fa-check"></i> 99.9% Uptime Guarantee</span>
                                            <span class="tolltip" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Hostie guarantees 99% uptime, ensuring your website is consistently available and reliable for visitors around the clock."><i class="fa-light fa-circle-question"></i></span>
                                        </li>
                                        <li class="card-plan__feature--list-item">
                                            <span class="text"><i class="fa-regular fa-check"></i> Web Application Firewall</span>
                                            <span class="tolltip" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Enhance your website's security with Hostie's Web Application Firewall, protecting against online threats and ensuring a safe online environment."><i class="fa-light fa-circle-question"></i></span>
                                        </li>
                                        <li class="card-plan__feature--list-trigered">
                                            <span class="text">More Features <i class="fa-sharp fa-regular fa-chevron-down"></i>
                                            </span>
                                        </li>
                                    </ul>
                                    <ul class="card-plan__feature--list more__feature">
                                        <li class="card-plan__feature--list-item">
                                            <span class="text"><i class="fa-regular fa-check"></i> 100 GB SSD Storage</span>
                                            <span class="tolltip" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Hostie offers generous hosting with 100GB SSD storage, providing ample space for your data and ensuring high-performance storage solutions."><i class="fa-light fa-circle-question"></i></span>
                                        </li>
                                        <li class="card-plan__feature--list-item">
                                            <span class="text"><i class="fa-regular fa-check"></i> Unlimited Free SSL</span>
                                            <span class="tolltip" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Secure your website with Hostie's unlimited free SSL certificates, ensuring encrypted and safe online transactions for your users."><i class="fa-light fa-circle-question"></i></span>
                                        </li>
                                        <li class="card-plan__feature--list-item">
                                            <span class="text"><i class="fa-regular fa-check"></i> 99.9% Uptime Guarantee</span>
                                            <span class="tolltip" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Hostie guarantees 99% uptime, ensuring your website is consistently available and reliable for visitors around the clock."><i class="fa-light fa-circle-question"></i></span>
                                        </li>
                                        <li class="card-plan__feature--list-item">
                                            <span class="text"><i class="fa-regular fa-xmark"></i> Web Application Firewall</span>
                                            <span class="tolltip" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Enhance your website's security with Hostie's Web Application Firewall, protecting against online threats and ensuring a safe online environment."><i class="fa-light fa-circle-question"></i></span>
                                        </li>
                                        <li class="card-plan__feature--list-trigered">
                                            <span class="text">See less Features <i class="fa-sharp fa-regular fa-chevron-up"></i>
                                            </span>
                                        </li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                        <!-- single card end -->
                        <!-- single card -->
                        <div class="col-lg-3 col-md-6 col-sm-6">
                            <div class="card-plan ">
                                <div class="card-plan__package">
                                    <div class="icon">
                                        <img src="{{asset ('assets/images/pricing/cloud.svg') }}" height="30" width="30" alt="">
                                    </div>
                                    <h4 class="package__name">Cloud Startup</h4>
                                </div>
                                <p class="card-plan__desc">Everything need to your website</p>
                                <div class="card-plan__offer">
                                    <span class="past-price">$353.63</span>
                                    <span class="offer-given">Save 60%</span>
                                </div>
                                <h5 class="card-plan__price">
                                    <sup>$</sup> 139.63 <sub>/ month</sub>
                                </h5>
                                <div class="card-plan__cartbtn">
                                    <a href="#">add to cart</a>
                                </div>
                                <p class="card-plan__renew-price">
                                    $ 353.99 /mo when you renew
                                </p>
                                <div class="card-plan__feature">
                                    <ul class="card-plan__feature--list">
                                        <li class="card-plan__feature--list-item">
                                            <span class="text"><i class="fa-regular fa-check"></i> 1 Website</span>
                                            <span class="tolltip" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Explore, discover, and learn on our innovative and informative website."><i class="fa-light fa-circle-question"></i></span>
                                        </li>
                                        <li class="card-plan__feature--list-item">
                                            <span class="text"><i class="fa-regular fa-check"></i> Standard Performance</span>
                                            <span class="tolltip" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Unlock superior online experiences with our standard performance solutions, ensuring reliability, speed, and seamless functionality for your website needs."><i class="fa-light fa-circle-question"></i></span>
                                        </li>
                                        <li class="card-plan__feature--list-item">
                                            <span class="text"><i class="fa-regular fa-check"></i> 24/7/365 Support</span>
                                            <span class="tolltip" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Hostie provides reliable 24/7 support for your hosting needs, ensuring assistance whenever you require help."><i class="fa-light fa-circle-question"></i></span>
                                        </li>
                                        <li class="card-plan__feature--list-item">
                                            <span class="text"><i class="fa-regular fa-check"></i> Free Email</span>
                                            <span class="tolltip" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Hostie offers complimentary email services, empowering your online communication with reliable and secure free email solutions."><i class="fa-light fa-circle-question"></i></span>
                                        </li>
                                        <li class="card-plan__feature--list-item">
                                            <span class="text"><i class="fa-regular fa-check"></i> Unlimited Bandwidth</span>
                                            <span class="tolltip" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Hostie provides unlimited bandwidth, ensuring seamless data transfer for your website's optimal performance and user experience."><i class="fa-light fa-circle-question"></i></span>
                                        </li>
                                        <li class="card-plan__feature--list-item">
                                            <span class="text"><i class="fa-regular fa-check"></i> 100 GB SSD Storage</span>
                                            <span class="tolltip" data-bs-toggle="tooltip" data-bs-placement="bottom"
                                            title="Elevate your online presence with Hostie, offering unlimited bandwidth for your domain, ensuring optimal performance and seamless data flow."><i class="fa-light fa-circle-question"></i></span>
                                        </li>


                                        <li class="card-plan__feature--list-item">
                                            <span class="text"><i class="fa-regular fa-check"></i> Unlimited Free SSL</span>
                                            <span class="tolltip" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Secure your website with Hostie's unlimited free SSL certificates, ensuring encrypted and safe online transactions for your users."><i class="fa-light fa-circle-question"></i></span>
                                        </li>
                                        <li class="card-plan__feature--list-item">
                                            <span class="text"><i class="fa-regular fa-check"></i> 99.9% Uptime Guarantee</span>
                                            <span class="tolltip" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Hostie guarantees 99% uptime, ensuring your website is consistently available and reliable for visitors around the clock."><i class="fa-light fa-circle-question"></i></span>
                                        </li>
                                        <li class="card-plan__feature--list-item">
                                            <span class="text"><i class="fa-regular fa-check"></i> Web Application Firewall</span>
                                            <span class="tolltip" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Enhance your website's security with Hostie's Web Application Firewall, protecting against online threats and ensuring a safe online environment."><i class="fa-light fa-circle-question"></i></span>
                                        </li>
                                        <li class="card-plan__feature--list-trigered">
                                            <span class="text">More Features <i class="fa-sharp fa-regular fa-chevron-down"></i>
                                            </span>
                                        </li>
                                    </ul>
                                    <ul class="card-plan__feature--list more__feature">
                                        <li class="card-plan__feature--list-item">
                                            <span class="text"><i class="fa-regular fa-check"></i> 100 GB SSD Storage</span>
                                            <span class="tolltip" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Hostie offers generous hosting with 100GB SSD storage, providing ample space for your data and ensuring high-performance storage solutions."><i class="fa-light fa-circle-question"></i></span>
                                        </li>
                                        <li class="card-plan__feature--list-item">
                                            <span class="text"><i class="fa-regular fa-check"></i> Unlimited Free SSL</span>
                                            <span class="tolltip" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Secure your website with Hostie's unlimited free SSL certificates, ensuring encrypted and safe online transactions for your users."><i class="fa-light fa-circle-question"></i></span>
                                        </li>
                                        <li class="card-plan__feature--list-item">
                                            <span class="text"><i class="fa-regular fa-check"></i> 99.9% Uptime Guarantee</span>
                                            <span class="tolltip" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Hostie guarantees 99% uptime, ensuring your website is consistently available and reliable for visitors around the clock."><i class="fa-light fa-circle-question"></i></span>
                                        </li>
                                        <li class="card-plan__feature--list-item">
                                            <span class="text"><i class="fa-regular fa-check"></i> Web Application Firewall</span>
                                            <span class="tolltip" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Enhance your website's security with Hostie's Web Application Firewall, protecting against online threats and ensuring a safe online environment."><i class="fa-light fa-circle-question"></i></span>
                                        </li>
                                        <li class="card-plan__feature--list-trigered">
                                            <span class="text">See less Features <i class="fa-sharp fa-regular fa-chevron-up"></i>
                                            </span>
                                        </li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                        <!-- single card end -->
                    </div>
                </div>
            </div>
            <div class="view-plan-btn">
                <a href="{{route('pricing')}}" class="btn long-btn">view all plan</a>
            </div>
        </div>
    </div>
    <!-- PRICING PLAN START END -->

    <!-- SHARED HOSTING FAQ -->
    <div class="rts-hosting-faq section__padding">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-lg-8">
                    <div class="rts-section text-center">
                        <h2 class="rts-section__title mb-0" data-sal="slide-down" data-sal-delay="200" data-sal-duration="800">Frequently asked questions</h2>
                    </div>
                    <div class="rts-faq__accordion">
                        <div class="accordion accordion-flush" id="rts-accordion">
                            <div class="accordion-item active">
                                <div class="accordion-header" id="first">
                                    <h4 class="accordion-button collapse show" data-bs-toggle="collapse" data-bs-target="#item__one" aria-expanded="false" aria-controls="item__one">
                                        Why buy a domain name from hostie?
                                    </h4>
                                </div>
                                <div id="item__one" class="accordion-collapse collapse collapse show" aria-labelledby="first" data-bs-parent="#rts-accordion">
                                    <div class="accordion-body">
                                        Above all else, we strive to deliver outstanding customer experiences. When you buy a domain name from hostie, we guarantee it will be handed over.
                                    </div>
                                </div>
                            </div>
                            <div class="accordion-item">
                                <div class="accordion-header" id="two">
                                    <h4 class="accordion-button collapsed" data-bs-toggle="collapse" data-bs-target="#item__two" aria-expanded="false" aria-controls="item__two">
                                        How does domain registration work?
                                    </h4>
                                </div>
                                <div id="item__two" class="accordion-collapse collapse" aria-labelledby="two" data-bs-parent="#rts-accordion">
                                    <div class="accordion-body">
                                        Above all else, we strive to deliver outstanding customer experiences. When you buy a domain name from hostie, we guarantee it will be handed over.
                                    </div>
                                </div>
                            </div>
                            <div class="accordion-item">
                                <div class="accordion-header" id="three">
                                    <h4 class="accordion-button collapsed" data-bs-toggle="collapse" data-bs-target="#item__three" aria-expanded="false" aria-controls="item__three">
                                        Why is domain name registration required?
                                    </h4>
                                </div>
                                <div id="item__three" class="accordion-collapse collapse" aria-labelledby="three" data-bs-parent="#rts-accordion">
                                    <div class="accordion-body">
                                        Above all else, we strive to deliver outstanding customer experiences. When you buy a domain name from hostie, we guarantee it will be handed over.
                                    </div>
                                </div>
                            </div>

                            <div class="accordion-item">
                                <div class="accordion-header" id="four">
                                    <h4 class="accordion-button collapsed" data-bs-toggle="collapse" data-bs-target="#item__four" aria-expanded="false" aria-controls="item__four">
                                        Why is domain name registration required?
                                    </h4>
                                </div>
                                <div id="item__four" class="accordion-collapse collapse" aria-labelledby="four" data-bs-parent="#rts-accordion">
                                    <div class="accordion-body">
                                        Above all else, we strive to deliver outstanding customer experiences. When you buy a domain name from hostie, we guarantee it will be handed over.
                                    </div>
                                </div>
                            </div>
                            <div class="accordion-item">
                                <div class="accordion-header" id="five">
                                    <h4 class="accordion-button collapsed" data-bs-toggle="collapse" data-bs-target="#item__five" aria-expanded="false" aria-controls="item__four">
                                        Why is domain name registration required?
                                    </h4>
                                </div>
                                <div id="item__five" class="accordion-collapse collapse" aria-labelledby="five" data-bs-parent="#rts-accordion">
                                    <div class="accordion-body">
                                        Above all else, we strive to deliver outstanding customer experiences. When you buy a domain name from hostie, we guarantee it will be handed over.
                                    </div>
                                </div>
                            </div>

                        </div>
                    </div>
                </div>

            </div>
        </div>
    </div>
    <!-- SHARED HOSTING FAQ END -->

    <!-- SUPPORT AREA -->
    <div class="rts-support black__friday--support">
        <div class="container">
            <div class="row">
                <div class="rts-support__wrapper">
                    <div class="rts-support__wrapper--content">
                        <h3 class="title" data-sal="slide-down" data-sal-delay="100" data-sal-duration="800">24/7 World-Class Support</h3>
                        <p data-sal="slide-down" data-sal-delay="200" data-sal-duration="800">Ran into trouble? Contact our Customer Success team any
                            time via live chat or email.
                        </p>
                        <div class="feature" data-sal="slide-down" data-sal-delay="300" data-sal-duration="800">
                            <ul class="feature__list">
                                <li class="feature__item">Receive professional WordPress support</li>
                                <li class="feature__item">Our specialists are available round</li>
                            </ul>
                        </div>
                        <a href="{{route('support')}}" class="rts-btn rts-btn-primary support-btn">Get Support <i class="fa-regular fa-chevron-right"></i></a>
                    </div>
                    <div class="rts-support__wrapper--image" data-sal="slide-left" data-sal-delay="400" data-sal-duration="800">
                        <img src="{{asset ('assets/images/support/support__image.svg') }}" alt="">
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- SUPPORT AREA END -->

    <!-- HOSTIE CTA -->
    <div class="rts-cta-two shared-page-bg pt--120">
        <div class="container">
            <div class="row">
                <div class="rts-cta-two__wrapper">
                    <div class="cta__shape"></div>
                    <div class="cta-content">
                        <span data-sal="slide-down" data-sal-delay="100" data-sal-duration="800">Need help choosing a plan?</span>
                        <h4 data-sal="slide-down" data-sal-delay="300" data-sal-duration="800">Need help?
                            We're always here for you.</h4>
                    </div>
                    <div class="cta-btn">
                        <a href="#" class="contact__us rts-btn rts-btn-secondary">Go to Live chat Page</a>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- HOSTIE CTA END -->

    <!-- FOOTER AREA -->
    @include('Frontend.Includes.Footers.footerOne')
    <!-- FOOTER AREA END -->
@endsection
