@extends('Frontend.Layouts.app')
@section('title', 'Data Center')
@section('content')
    <!-- HEADER AREA -->
        @include('Frontend.Includes.Headers.headerOne')
    <!-- HEADER AREA END -->

    <!-- shared hosting banner -->
    <div class="rts-hosting-banner rts-hosting-banner-bg banner-default-height">
        <div class="container">
            <div class="row justify-content-sm-center">
                <div class="banner-area">
                    <div class="rts-hosting-banner rts-hosting-banner__content w-530">
                        <span class="starting__price" data-sal="slide-down" data-sal-delay="100" data-sal-duration="800">Data Center</span>
                        <h1 class="banner-title" data-sal="slide-down" data-sal-delay="200" data-sal-duration="800">
                            Modern And Green
                            Data Centers
                        </h1>
                        <div class="feature mb-0" data-sal="slide-down" data-sal-delay="300" data-sal-duration="800">
                            <ul class="feature__list">
                                <li class="feature__item">High redundancy & availability</li>
                                <li class="feature__item">Fast connectivity and low latency</li>
                            </ul>
                        </div>
                    </div>
                    <div class="rts-hosting-banner__image vps">
                        <img src="{{asset ('assets/images/banner/banner__vps__image.svg') }}" alt="">
                        <img class="shape-image one top-bottom2" src="{{asset ('assets/images/banner/banner__vps__image-sm1.svg') }}" alt="">
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- shared hosting banner end-->

    <!-- HOSTIE FEATURE AREA -->
    <section class="rts-feature-six section__padding business">
        <div class="container">
            <div class="row">
                <div class="rts-section text-center">
                    <h2 class="rts-section__title" data-sal="slide-down" data-sal-delay="100" data-sal-duration="800">Hostie Email Key Features</h2>
                    <p class="rts-section__description" data-sal="slide-down" data-sal-delay="300" data-sal-duration="800">Powerful and Unique Tools for Your Email Inbox</p>
                </div>
            </div>
            <div class="row gy-30 justify-content-sm-center">
                <div class="col-lg-3 col-md-6 col-sm-10" data-sal="slide-down" data-sal-delay="500" data-sal-duration="800">
                    <div class="single__feature">
                        <div class="single__feature--box text-center">
                            <div class="single__feature--box-icon m-auto">
                                <img src="{{asset ('assets/images/feature/feature-12.svg') }}" alt="">
                            </div>
                            <h5 class="single__feature--box-title">
                                High redundancy
                            </h5>
                            <p class="single__feature--box-description">
                                Maintain and access all of your accounts in one place.
                            </p>
                        </div>
                    </div>
                </div>

                <div class="col-lg-3 col-md-6 col-sm-10" data-sal="slide-down" data-sal-delay="600" data-sal-duration="800">
                    <div class="single__feature">
                        <div class="single__feature--box text-center">
                            <div class="single__feature--box-icon m-auto">
                                <img src="{{asset ('assets/images/feature/feature-13.svg') }}" alt="">
                            </div>
                            <h5 class="single__feature--box-title">
                                Multi-layered security
                            </h5>
                            <p class="single__feature--box-description">
                                So your conversations continue no matter where you are.
                            </p>
                        </div>
                    </div>
                </div>

                <div class="col-lg-3 col-md-6 col-sm-10" data-sal="slide-down" data-sal-delay="700" data-sal-duration="800">
                    <div class="single__feature">
                        <div class="single__feature--box text-center">
                            <div class="single__feature--box-icon m-auto">
                                <img src="{{asset ('assets/images/feature/feature-14.svg') }}" alt="">
                            </div>
                            <h5 class="single__feature--box-title">
                                Green-friendly hosting
                            </h5>
                            <p class="single__feature--box-description">
                                Don't start from scratch: bring along existing emails
                            </p>
                        </div>
                    </div>
                </div>

                <div class="col-lg-3 col-md-6 col-sm-10" data-sal="slide-down" data-sal-delay="800" data-sal-duration="800">
                    <div class="single__feature">
                        <div class="single__feature--box text-center">
                            <div class="single__feature--box-icon m-auto">
                                <img src="{{asset ('assets/images/feature/feature-15.svg') }}" alt="">
                            </div>
                            <h5 class="single__feature--box-title">
                                Fast connectivity
                            </h5>
                            <p class="single__feature--box-description">
                                Mistakes happen and you can fix them. Undo a sent email
                            </p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- HOSTIE FEATURE AREA END -->

    <!-- CDN NETWORK -->
    <div class="rts-cdn-feature pb--120">
        <div class="container">
            <div class="row g-40  align-items-center">
                <div class="col-xl-5 col-lg-6">
                    <div class="cdn-images">
                        <img src="{{asset ('assets/images/feature/cdn.jpg') }}" alt="">
                    </div>
                </div>
                <div class="col-xl-6 col-lg-6">
                    <div class="cdn-description">
                        <h2 class="title fw-bold">Global CDN network</h2>
                        <p class="description mb-4">
                            SiteGround customers enjoy free in-house built CDN service that significantly
                            speeds up the loading speed for all your site visitors across the globe With our CDN your site content is cached
                        </p>
                        <div class="feature style-two m-0" data-sal="slide-down" data-sal-delay="500" data-sal-duration="800">
                            <ul class="feature__list">
                                <li class="feature__item">Our CDN locations includes Tokyo (Japan)</li>
                                <li class="feature__item">Warsaw (Poland), Hamina (Finland), London (England)</li>
                                <li class="feature__item">Madrid (Spain), Eemshaven (Netherlands), Paris (France)</li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- CDN NETWORK END -->

    <!-- SUPPORT AREA -->
    <div class="rts-support black__friday--support">
        <div class="container">
            <div class="row">
                <div class="rts-support__wrapper">
                    <div class="rts-support__wrapper--content">
                        <h3 class="title" data-sal="slide-down" data-sal-delay="100" data-sal-duration="800">24/7 World-Class Support</h3>
                        <p data-sal="slide-down" data-sal-delay="200" data-sal-duration="800">Ran into trouble? Contact our Customer Success team any
                            time via live chat or email.
                        </p>
                        <div class="feature" data-sal="slide-down" data-sal-delay="300" data-sal-duration="800">
                            <ul class="feature__list">
                                <li class="feature__item">Receive professional WordPress support</li>
                                <li class="feature__item">Our specialists are available round</li>
                            </ul>
                        </div>
                        <a href="{{route('support')}}" class="rts-btn rts-btn-primary support-btn">Get Support <i class="fa-regular fa-chevron-right"></i></a>
                    </div>
                    <div class="rts-support__wrapper--image" data-sal="slide-left" data-sal-delay="400" data-sal-duration="800">
                        <img src="{{asset ('assets/images/support/support__image.svg') }}" alt="">
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- SUPPORT AREA END -->

    <!-- DATA CENTER AREA -->
    <div class="rts-data-center no-bg fix section__padding">
        <div class="container">
            <div class="row">
                <div class="col-12">
                    <div class="rts-section text-center">
                        <h3 class="rts-section__title" data-sal="slide-down" data-sal-delay="300" data-sal-duration="800">Globally distributed infrastructure</h3>
                        <p class="rts-section__description w-790" data-sal="slide-down" data-sal-delay="400" data-sal-duration="800">Our web hosting, WordPress hosting, and cloud hosting plans offer server locations in: USA, Germany Egypt , India, Chaina, Brazil, Canada, Russia, Australia and South Africa.
                        </p>
                    </div>
                </div>
            </div>
            <!-- data center content -->
            <div class="row">
                <div class="col-12">
                    <div class="rts-data-center__location">
                        <img src="{{asset ('assets/images/data__center.png') }}" alt="data__center">
                        <ul class="round-shape">
                            <li class="one">
                                <span class="tolltip1" data-bs-toggle="tooltip" data-bs-placement="top" data-bs-custom-class="color-hostie" title="Canada"></span>
                                <img src="{{asset ('assets/images/flag-01.svg') }}" alt="">
                            </li>
                            <li class="two">
                                <span class="tolltip1" data-bs-toggle="tooltip" data-bs-placement="top" data-bs-custom-class="color-hostie" title="Germany"></span>
                                <img src="{{asset ('assets/images/flag-02.svg') }}" alt="">
                            </li>
                            <li class="three">
                                <span class="tolltip1" data-bs-toggle="tooltip" data-bs-placement="top" data-bs-custom-class="color-hostie" title="Russia"></span>
                                <img src="{{asset ('assets/images/flag-03.svg') }}" alt="">
                            </li>
                            <li class="four">
                                <span class="tolltip1" data-bs-toggle="tooltip" data-bs-placement="top" data-bs-custom-class="color-hostie"  title="USA"></span>
                                <img src="{{asset ('assets/images/flag-04.svg') }}" alt="">
                            </li>
                            <li class="five">
                                <span class="tolltip1" data-bs-toggle="tooltip" data-bs-placement="top" data-bs-custom-class="color-hostie" title="Egypt"></span>
                                <img src="{{asset ('assets/images/flag-05.svg') }}" alt="">
                            </li>
                            <li class="six">
                                <span class="tolltip1" data-bs-toggle="tooltip" data-bs-placement="top"  data-bs-custom-class="color-hostie" title="India"></span>
                                <img src="{{asset ('assets/images/flag-06.svg') }}" alt="">
                            </li>
                            <li class="seven">
                                <span class="tolltip1" data-bs-toggle="tooltip" data-bs-placement="top" data-bs-custom-class="color-hostie" title="China"></span>
                                <img src="{{asset ('assets/images/flag-07.svg') }}" alt="">
                            </li>
                            <li class="eight">
                                <span class="tolltip1" data-bs-toggle="tooltip" data-bs-placement="top" data-bs-custom-class="color-hostie" title="Brazil"></span>
                                <img src="{{asset ('assets/images/flag-08.svg') }}" alt="">
                            </li>
                            <li class="nine">
                                <span class="tolltip1" data-bs-toggle="tooltip" data-bs-placement="top" data-bs-custom-class="color-hostie"  title="South Africa"></span>
                                <img src="{{asset ('assets/images/flag-09.svg') }}" alt="">
                            </li>
                            <li class="ten">
                                <span class="tolltip1" data-bs-toggle="tooltip" data-bs-placement="top" data-bs-custom-class="color-hostie" title="Australia"></span>
                                <img src="{{asset ('assets/images/flag-10.svg') }}" alt="">
                            </li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- DATA CENTER AREA END -->

    <!-- HOSTIE CTA -->
    <div class="rts-cta-two shared-page-bg">
        <div class="container">
            <div class="row">
                <div class="rts-cta-two__wrapper">
                    <div class="cta__shape"></div>
                    <div class="cta-content">
                        <span data-sal="slide-down" data-sal-delay="100" data-sal-duration="800">Need help choosing a plan?</span>
                        <h4 data-sal="slide-down" data-sal-delay="200" data-sal-duration="800">Need help?
                            We're always here for you.</h4>
                    </div>
                    <div class="cta-btn">
                        <a href="#" class="contact__us primary__btn btn__two secondary__bg secondary__color">Go to Live chat Page</a>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- HOSTIE CTA END -->

    <!-- FOOTER AREA -->
    @include('Frontend.Includes.Footers.footerOne')
    <!-- FOOTER AREA END -->
@endsection
