@extends('Frontend.Layouts.app')
@section('title', __('lang.FAQ'))
@section('content')
    <!-- HEADER AREA -->
    @include('Frontend.Includes.navbar')
    <!-- HEADER AREA END -->
    <div class="site-content">

        <div class="container-fluid">
            <div class="item-efftect">
                <div class="efftect overflow-hidden"></div>
                <div class="efftect overflow-hidden"></div>
                <div class="efftect overflow-hidden"></div>
                <div class="efftect overflow-hidden"></div>
                <div class="efftect overflow-hidden"></div>
            </div>
        </div>

        <div class="inner-header bg-holder" data-bg="{{ asset('front/images/head.jpg') }}">
            <div class="container">
                <div class="row  justify-content-center">
                    <div class="col-md-12 text-center">
                        <h1 class="title">{{ __('lang.Plans') }}</h1>
                    </div>
                </div>
            </div>
        </div>

        <div class="content-wrapper">

            @php
                $hsetting = App\Models\Home_setting::select(
                    'section10_subtitle',
                    'section10_title',
                    'section10_title_en',
                    'section10_subtitle_en',
                    'section8_subtitle',
                    'section8_title',
                    'section8_title_en',
                    'section8_subtitle_en',
                )->first();
            @endphp
              <section class="space-pt">
                <div class="container">
                    <div class="row">
                        <div class="col-lg-5">
                            <div class="section-title">
                                <h2 class="title">
                                    {{ app()->getLocale() == 'ar' ? $hsetting->section8_title : $hsetting->section8_title_en }}
                                </h2>
                                <p class="title">
                                    {{ app()->getLocale() == 'ar' ? $hsetting->section8_subtitle : $hsetting->section8_subtitle_en }}
                                </p>
                            </div>
                        </div>
                        @php
                            $plans = App\Models\Plan::where('status', 1)->latest()->get();
                            $allFeatures = App\Models\Feature::all();
                        @endphp
                        <div class="col-lg-7 ps-xxl-5">
                            <div class="pgs-accordion pgs-pricing ps-0 ps-lg-5 mt-5 mt-lg-0 mb-5">
                                @foreach ($plans as $index => $plan)
                                    <div class="accordion-item @if ($index == 0) is-active @endif">
                                        <div class="accordion-header">
                                            <div class="package-info">
                                                <span class="package-check"><i class="fa-solid fa-check"></i></span>
                                                <div class="package-name">
                                                    <h5 class="package-title">
                                                        {{ app()->getLocale() == 'ar' ? $plan->title_ar : $plan->title_en }}
                                                    </h5>
                                                    <span
                                                        class="package-discount">{{ app()->getLocale() == 'ar' ? $plan->description_ar : $plan->description_en }}</span>
                                                </div>
                                            </div>
                                            <div class="package-price">
                                                <img class="img-fluid" width="170"
                                                    src="{{ asset('storage/files/' . ($plan->image ?? 'default.png')) }}"
                                                    alt="logo">
                                            </div>
                                        </div>
                                        <div class="accordion-content">
                                            <div class="content-inner">
                                                <div class="pricing-lists">
                                                    <ul class="pricing-lists">
                                                        @foreach ($allFeatures as $feature)
                                                            @if (in_array($feature->id, $plan->features))
                                                                <li><i class="fa-regular fa-circle-check"></i>
                                                                    {{ app()->getLocale() == 'ar' ? $feature->title_ar : $feature->title_en }}
                                                                </li>
                                                            @endif
                                                        @endforeach
                                                    </ul>
                                                </div>
                                                <div class="pricing-link">
                                                    <a href="{{route('front.form')}}"><svg width="17" height="16"
                                                            viewBox="0 0 17 16" fill="none"
                                                            xmlns="http://www.w3.org/2000/svg">
                                                            <g clip-path="url(#clip0_923_1331)">
                                                                <path
                                                                    d="M8.70801 0.959961L9.29825 2.7665C10.2512 5.68321 12.8308 7.77453 15.8928 8.1128C12.8468 8.37564 10.2578 10.4348 9.3276 13.3343L8.70801 15.2657"
                                                                    stroke="inherit" stroke-width="1" />
                                                                <path d="M15.7602 8.12158H0.1875" stroke="inherit"
                                                                    stroke-width="1" />
                                                            </g>
                                                            <defs>
                                                                <clipPath id="clip0_923_1331">
                                                                    <rect width="15.904" height="14.8437" fill="inherit"
                                                                        transform="translate(0.1875 0.578125)" />
                                                                </clipPath>
                                                            </defs>
                                                        </svg></a>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                @endforeach

                            </div>
                        </div>
                    </div>
                </div>
            </section>
            <section class="space-small-ptb ellipse-top bg-black z-index-2">
                <div class="container">
                    <div class="row mb-lg-5">
                        <div class="col-xxl-6 col-lg-8">
                            <div class="section-title mb-lg-0">
                                <span
                                    class="sub-title">{{ app()->getLocale() == 'ar' ? $hsetting->section10_title : $hsetting->section10_title_en }}</span>
                                <h2 class="title mb-0">
                                    {{ app()->getLocale() == 'ar' ? $hsetting->section10_subtitle : $hsetting->section10_subtitle_en }}
                                </h2>
                            </div>
                        </div>
                        <div class="col-xxl-6 col-lg-4 align-self-end">
                            <div class="d-flex justify-content-center mt-5 ms-sm-5 ms-0">
                                <a class="btn btn-primary" href="{{ route('front.form') }}">
                                    <span>{{ __('lang.start now') }}</span>
                                    <svg width="20" height="22" viewBox="0 0 20 22" fill="none"
                                        xmlns="http://www.w3.org/2000/svg">
                                        <g clip-path="url(#clip0_59_253)">
                                            <path
                                                d="M19.4854 11.4293L17.0513 12.221C13.1214 13.4993 10.3036 16.9595 9.84784 21.0668C9.49371 16.981 6.71926 13.5081 2.81255 12.2604L0.210283 11.4293"
                                                stroke="white" stroke-width="2" />
                                            <path d="M9.83594 20.8889L9.83594 0" stroke="white" stroke-width="2" />
                                        </g>
                                        <defs>
                                            <clipPath id="clip0_59_253">
                                                <rect width="21.3333" height="20" fill="white"
                                                    transform="translate(20) rotate(90)" />
                                            </clipPath>
                                        </defs>
                                    </svg>
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </section>
        </div>
    </div>

    @include('Frontend.Includes.Footer')
    <!-- FOOTER AREA END -->
@endsection
