@extends('Frontend.Layouts.app')
@section('title', __('lang.Services'))
@section('content')
    <!-- HEADER AREA -->
    @include('Frontend.Includes.navbar')
    <!-- HEADER AREA END -->
    <div class="site-content">

        <div class="container-fluid">
            <div class="item-efftect">
                <div class="efftect overflow-hidden"></div>
                <div class="efftect overflow-hidden"></div>
                <div class="efftect overflow-hidden"></div>
                <div class="efftect overflow-hidden"></div>
                <div class="efftect overflow-hidden"></div>
            </div>
        </div>

        <!--=================================
                          Page Header -->
        <div class="inner-header bg-holder" data-bg="{{ asset('front/images/head.jpg') }}">
            <div class="container">
                <div class="row  justify-content-center">
                    <div class="col-md-12 text-center">
                        <h1 class="title">{{ __('lang.Services') }}</h1>
                    </div>
                </div>
            </div>
        </div>

        <div class="content-wrapper">
            <section class="space-ptb ellipse-bottom">
                <div class="container">
                    <div class="row justify-content-center">
                        <div class="col-md-10 text-center">
                            <div class="section-title">
                                <h2 class="title"> {{ __('lang.We make technology work for you') }}
                                </h2>
                            </div>
                        </div>
                    </div>
                    <div class="row justify-content-start">
                        <div class="col-lg-12">
                            <div class="services grid-wrapper grid-xl-3 grid-lg-3 grid-md-2 grid-sm-1">
                                @php
                                $services = App\Models\Service::where('status', 1)->latest()->get();

                            @endphp
                            @foreach ($services as $service)
                            <div class="service-wrapper service-style-1">
                                <div class="service-inner">
                                    <div class="service-icon">
                                        <img class="img-fluid" src="{{asset('front/images/svg/services/Content-Management.svg')}}"
                                            alt="#">
                                    </div>
                                    <div class="bg-icon">
                                        <img class="img-fluid" src="{{asset('front/images/svg/services/color-icon/Content-Management.svg')}}"
                                            alt="#">
                                    </div>
                                    <div class="service-content">
                                        <h5 class="service-title">
                                            {{ app()->getLocale() == 'ar' ? $service->title : $service->title_en }}</small>

                                        </h5>
                                        <p>
                                            {{ app()->getLocale() == 'ar' ? $service->body : $service->body_en }}</small>

                                        </p>
                                    </div>
                                </div>
                            </div>

                            @endforeach


                            </div>
                        </div>
                    </div>
                </div>
            </section>

            @php
                $hsetting = App\Models\Home_setting::select(
                    'section10_subtitle',
                    'section10_title',
                    'section10_title_en',
                    'section10_subtitle_en',
                )->first();
            @endphp
            <section class="space-small-ptb ellipse-top bg-black z-index-2">
                <div class="container">
                    <div class="row mb-lg-5">
                        <div class="col-xxl-6 col-lg-8">
                            <div class="section-title mb-lg-0">
                                <span
                                    class="sub-title">{{ app()->getLocale() == 'ar' ? $hsetting->section10_title : $hsetting->section10_title_en }}</span>
                                <h2 class="title mb-0">
                                    {{ app()->getLocale() == 'ar' ? $hsetting->section10_subtitle : $hsetting->section10_subtitle_en }}
                                </h2>
                            </div>
                        </div>
                        <div class="col-xxl-6 col-lg-4 align-self-end">
                            <div class="d-flex justify-content-center mt-5 ms-sm-5 ms-0">
                                <a class="btn btn-primary" href="{{ route('front.form') }}">
                                    <span>{{ __('lang.start now') }}</span>
                                    <svg width="20" height="22" viewBox="0 0 20 22" fill="none"
                                        xmlns="http://www.w3.org/2000/svg">
                                        <g clip-path="url(#clip0_59_253)">
                                            <path
                                                d="M19.4854 11.4293L17.0513 12.221C13.1214 13.4993 10.3036 16.9595 9.84784 21.0668C9.49371 16.981 6.71926 13.5081 2.81255 12.2604L0.210283 11.4293"
                                                stroke="white" stroke-width="2" />
                                            <path d="M9.83594 20.8889L9.83594 0" stroke="white" stroke-width="2" />
                                        </g>
                                        <defs>
                                            <clipPath id="clip0_59_253">
                                                <rect width="21.3333" height="20" fill="white"
                                                    transform="translate(20) rotate(90)" />
                                            </clipPath>
                                        </defs>
                                    </svg>
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </section>
        </div>
    </div>

    @include('Frontend.Includes.Footer')
    <!-- FOOTER AREA END -->
@endsection
