@extends('Frontend.Layouts.app')
@section('title', 'Support')
@section('content')
    <!-- HEADER AREA -->
        @include('Frontend.Includes.Headers.headerOne')
    <!-- HEADER AREA END -->

    <!-- shared hosting banner -->
    <div class="rts-hosting-banner rts-hosting-banner-bg banner-default-height">
        <div class="container">
            <div class="row justify-content-sm-center">
                <div class="banner-area">
                    <div class="rts-hosting-banner rts-hosting-banner__content w-460">
                        <span class="starting__price" data-sal="slide-down" data-sal-delay="100"
                            data-sal-duration="800">Technology</span>
                        <h1 class="banner-title" data-sal="slide-down" data-sal-delay="200" data-sal-duration="800">
                            Premium Hosting
                            Technologies
                        </h1>
                        <p class="description" data-sal="slide-down" data-sal-delay="300" data-sal-duration="800">Developing
                            smart solutions in-house and adopting the latest speed and security technologies is our
                            passion.</p>
                    </div>
                    <div class="rts-hosting-banner__image vps">
                        <img src="{{asset ('assets/images/banner/banner__vps__image.svg') }}" width="356" height="370" alt="">
                        <img class="shape-image one top-bottom2" src="{{asset ('assets/images/banner/banner__vps__image-sm1.svg') }}" alt="">
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- shared hosting banner end-->

    <!-- CLOUD FEATURE -->
    <section class="rts-cloud-feature section__padding">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-lg-6">
                    <div class="rts-section">
                        <h3 class="title mb-0" data-sal="slide-down" data-sal-delay="100" data-sal-duration="800">
                            High-Performance Platform
                        </h3>
                    </div>
                </div>
            </div>
            <!-- feature single -->
            <div class="row g-30">
                <div class="col-lg-4 col-md-6 col-sm-6" data-sal="slide-down" data-sal-delay="100" data-sal-duration="800">
                    <div class="cloud-feature">
                        <div class="icon">
                            <img src="{{asset ('assets/images/feature/cloud/1.svg') }}" height="50" width="60" alt="">
                        </div>
                        <h4 class="title">Powerful Caching Technology</h4>
                        <p class="description">
                            All hosted sites get cached, which improves
                            their performance up to 5 times!
                        </p>
                    </div>
                </div>
                <div class="col-lg-4 col-md-6 col-sm-6" data-sal="slide-down" data-sal-delay="200" data-sal-duration="800">
                    <div class="cloud-feature">
                        <div class="icon">
                            <img src="{{asset ('assets/images/feature/cloud/php.svg') }}" height="50" width="60" alt="">
                        </div>
                        <h4 class="title">Ultrafast PHP Setup</h4>
                        <p class="description">
                            We developed a custom PHP setup that cuts
                            the TTFB (time to first byte) and makes
                        </p>
                    </div>
                </div>
                <div class="col-lg-4 col-md-6 col-sm-6" data-sal="slide-down" data-sal-delay="100" data-sal-duration="800">
                    <div class="cloud-feature">
                        <div class="icon">
                            <img src="{{asset ('assets/images/feature/cloud/sql.svg') }}" height="50" width="60" alt="">
                        </div>
                        <h4 class="title">Custom MySQL Setup</h4>
                        <p class="description">
                            If your site has outgrown the shared hosting
                            solutions it’s time to move to the cloud.
                        </p>
                    </div>
                </div>
                <div class="col-lg-4 col-md-6 col-sm-6" data-sal="slide-down" data-sal-delay="200" data-sal-duration="800">
                    <div class="cloud-feature">
                        <div class="icon">
                            <img src="{{asset ('assets/images/feature/cloud/resell.svg') }}" height="50" width="60" alt="">
                        </div>
                        <h4 class="title">White-label Reselling</h4>
                        <p class="description">
                            If your site has outgrown the shared hosting
                            solutions it’s time to move to the cloud.
                        </p>
                    </div>
                </div>
                <div class="col-lg-4 col-md-6 col-sm-6" data-sal="slide-down" data-sal-delay="100" data-sal-duration="800">
                    <div class="cloud-feature">
                        <div class="icon">
                            <img src="{{asset ('assets/images/feature/cloud/backup.svg') }}" height="50" width="60" alt="">
                        </div>
                        <h4 class="title">Automated Onsite Backups</h4>
                        <p class="description">
                            If your site has outgrown the shared hosting
                            solutions it’s time to move to the cloud.
                        </p>
                    </div>
                </div>
                <div class="col-lg-4 col-md-6 col-sm-6" data-sal="slide-down" data-sal-delay="200" data-sal-duration="800">
                    <div class="cloud-feature">
                        <div class="icon">
                            <img src="{{asset ('assets/images/feature/cloud/speed-meter-2.svg') }}" height="50" width="60" alt="">
                        </div>
                        <h4 class="title">Top WordPress Performance</h4>
                        <p class="description">
                            If your site has outgrown the shared hosting
                            solutions it’s time to move to the cloud.
                        </p>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- CLOUD FEATURE END -->

    <!-- PERFORMANCE SECTION -->
    <section class="rts-performance section__padding ">
        <div class="container">
            <div class="row g-5 align-items-center">
                <div class="col-xl-6 col-lg-5">
                    <div class="performance__image">
                        <img src="{{asset ('assets/images/feature/performance.jpg') }}" alt="">
                    </div>
                </div>
                <div class="col-xl-6 col-lg-7">
                    <div class="performance__text w-480  mx-0 mx-lg-auto ml--90">
                        <h2 class="fw-bold">High-Performance
                            Platform
                        </h2>
                        <p class="description">We launched geographically distributed backups that minimize the risk of date loss and allows
                            for fast data recovery even in case of a serious incident that may affect a whole.</p>
                        <a href="{{route('WordPressHosting')}}" class="rts-btn rts-btn-secondary hover-white">get started</a>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- PERFORMANCE SECTION END -->

    <!-- ABOUT RESELLER HOSTING -->
    <div class="rts-about-reseller section__padding">
        <div class="container">
            <div class="row align-items-center">

                <div class="col-lg-6">
                    <div class="hosting-info">
                        <h2 class="hosting-info__title mt-0 w-450" data-sal="slide-down" data-sal-delay="200" data-sal-duration="800">Automatic Scaling
                            on Cloud</h2>
                        <p class="description w-480" data-sal="slide-down" data-sal-delay="100" data-sal-duration="800">
                            We develop unique technologies that facilitate our clients in building and managing their websites. Start with our in-house developed site control panel and go through a wide range of tools for WordPress</p>

                        <a href="{{route('pricing')}}" class="btn__two btn__long secondary__bg secondary__color">View Plan <i
                                class="fa-regular fa-arrow-right"></i></a>
                    </div>
                </div>
                <div class="col-lg-6  padding-bottom-75">
                    <div class="hosting-about-image-bg"></div>
                    <div class="hosting-about-image">
                        <div class="img-one">
                            <img src="{{asset ('assets/images/about/resell/image-1.png') }}" width="378" height="400" alt="">
                        </div>
                        <div class="img-two">
                            <img src="{{asset ('assets/images/feature/scalling.jpg') }}" width="247" height="347" alt="">
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- ABOUT RESELLER HOSTING END -->

    <!-- HOSTIE CTA -->
    <div class="rts-cta-two shared-page-bg">
        <div class="container">
            <div class="row">
                <div class="rts-cta-two__wrapper">
                    <div class="cta__shape"></div>
                    <div class="cta-content">
                        <span data-sal="slide-down" data-sal-delay="100" data-sal-duration="800">Need help choosing a
                            plan?</span>
                        <h4 data-sal="slide-down" data-sal-delay="200" data-sal-duration="800">Need help?
                            We're always here for you.</h4>
                    </div>
                    <div class="cta-btn">
                        <a href="#" class="contact__us primary__btn btn__two secondary__bg secondary__color">Go to Live
                            chat Page</a>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- HOSTIE CTA END -->

    <!-- FOOTER AREA -->
    @include('Frontend.Includes.Footers.footerOne')
    <!-- FOOTER AREA END -->
@endsection
