@extends('layouts.dash_master')
@section('title')
    <title>{{ __('المدونة') }}</title>
@endsection

@section('dash-content')
    <div class="content-header row">
        <div class="content-header-left col-md-9 col-12 mb-2">
            <div class="row breadcrumbs-top">
                <div class="col-12">
                    <h2 class="content-header-title float-start mb-0">{{ __('المدونة') }}</h2>
                    <div class="breadcrumb-wrapper">
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">Home</a>
                            </li>
                            <li class="breadcrumb-item"> {{ __('المدونة') }}
                            </li>
                        </ol>
                    </div>
                </div>
            </div>
        </div>
        <div class="content-header-right text-md-end col-md-3 col-12 d-md-block d-none">
            <div class="mb-1 breadcrumb-right">
                <a href="{{route('blog.create')}}" class="btn btn-primary create_agent"><i class="fas fa-plus"></i> {{ __('اضف جديد') }}</a>
            </div>
        </div>
    </div>
    <div class="blog-list-wrapper">
        <!-- Blog List Items -->
        <div class="row">
            @foreach ($blogs as $blog)
            <div class="col-md-4 col-6">
                <div class="card">
                    <a href="">
                        <img class="card-img-top img-fluid" src="{{ asset('storage/files/' . ($blog->image ?? 'default.png')) }}"
                            alt="Blog Post pic">
                    </a>
                    <div class="card-body">
                        <h4 class="card-title">
                            <a href="" class="blog-title-truncate text-body-heading">{{$blog->title }}</a>
                        </h4>
                        <div class="d-flex">
                            <div class="author-info">
                                <small class="text-muted">{{$blog->created_at->format('d/m/Y')}}</small>
                            </div>
                        </div>
                        <div class="my-1 py-25">
                            <a>
                                <span class="badge rounded-pill badge-light-primary">{{$blog->category}}</span>
                            </a>
                        </div>

                        <hr>
                        <div class="d-flex justify-content-between align-items-center">
                                <button class="btn btn-flat-danger" onclick="confirmDelete({{ $blog->id }})">
                                    حذف <i data-feather='trash'></i>
                                </button>
                            <a href="{{route('blog.edit',$blog->id)}}" class="fw-bold">تعديل <i data-feather='edit'></i></a>
                        </div>
                    </div>
                </div>
            </div>

            @endforeach
        </div>
        <!--/ Blog List Items -->

    </div>
  <!-- Delete Blog Modal -->
<div class="modal fade modal-danger text-start" id="deleteBlogModal" tabindex="-1" aria-labelledby="deleteBlogLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-sm">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title" id="deleteBlogLabel">تأكيد حذف مدونة</h4>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="X"></button>
            </div>
            <div class="modal-body">
                <p>هل انت متأكد من انك تريد حذف هذه المدونة ؟ لايمكن التراجع عن العملية</p>
            </div>
            <div class="modal-footer">
                <form method="POST" id="deleteBlogForm">
                    @csrf
                    @method('DELETE')
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">اغلاق</button>
                    <button type="submit" class="btn btn-danger"> حذف</button>
                </form>
            </div>
        </div>
    </div>
</div>
@endsection
@push('js')
<script>
    function confirmDelete(blogId) {
        const form = document.getElementById('deleteBlogForm');
        form.action = "{{ route('blog.destroy', ':id') }}".replace(':id', blogId);// غيّر المسار حسب الراوت عندك
        const modal = new bootstrap.Modal(document.getElementById('deleteBlogModal'));
        modal.show();
    }
    </script>
@endpush
