  @extends('layouts.dash_master')
  @section('title')
      <title>{{ __('dash.Dashboard') }}</title>
  @endsection

  @section('dash-content')
      <div class="content-header row">
          <div class="content-header-left col-md-9 col-12 mb-2">
              <div class="row breadcrumbs-top">
                  <div class="col-12">
                      <h2 class="content-header-title float-start mb-0">الرئيسية</h2>
                      <div class="breadcrumb-wrapper">
                          <ol class="breadcrumb">
                              <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">الرئيسية</a>
                              </li>

                          </ol>
                      </div>
                  </div>
              </div>
          </div>
      </div>
      <div class="row">
          <div class="col-xl-2 col-md-4 col-sm-6">
              <a href="{{ route('orders') }}">
                  <div class="card text-center">
                      <div class="card-body">
                          <div class="avatar bg-light-info p-50 mb-1">
                              <div class="avatar-content">
                                  <i data-feather="eye" class="font-medium-5"></i>
                              </div>
                          </div>
                          <h2 class="fw-bolder">{{ App\Models\Order::where('status', 'new')->count() ?? '' }}</h2>
                          <h3 class="card-text">طلبات جديدة </h3>
                      </div>
                  </div>
              </a>
          </div>
          <div class="col-xl-2 col-md-4 col-sm-6">
              <a href="{{ route('messages') }}">
                  <div class="card text-center">
                      <div class="card-body">
                          <div class="avatar bg-light-warning p-50 mb-1">
                              <div class="avatar-content">
                                  <i data-feather="message-square" class="font-medium-5"></i>
                              </div>
                          </div>
                          <h2 class="fw-bolder">{{ App\Models\Message::count() ?? '' }}</h2>
                          <h3 class="card-text">رسائل</h3>
                      </div>
                  </div>
              </a>
          </div>
          <div class="col-xl-2 col-md-4 col-sm-6">
              <a href="{{ route('orders') }}">

                  <div class="card text-center">
                      <div class="card-body">
                          <div class="avatar bg-light-danger p-50 mb-1">
                              <div class="avatar-content">
                                  <i data-feather="shopping-bag" class="font-medium-5"></i>
                              </div>
                          </div>
                          <h2 class="fw-bolder">{{ App\Models\Order::where('status', 'urgent')->count() ?? '' }}</h2>
                          <h3 class="card-text">طلبات مستعجلة</h3>
                      </div>
                  </div>
              </a>
          </div>
          <div class="col-xl-2 col-md-4 col-sm-6">
              <a href="{{ route('orders') }}">

                  <div class="card text-center">
                      <div class="card-body">
                          <div class="avatar bg-light-primary p-50 mb-1">
                              <div class="avatar-content">
                                  <i data-feather="heart" class="font-medium-5"></i>
                              </div>
                          </div>
                          <h2 class="fw-bolder">{{ App\Models\Order::where('status', 'under_review')->count() ?? '' }}</h2>
                          <h5 class="card-text">طلبات تحت المراجعة</h5>
                      </div>
                  </div>
              </a>
          </div>
          <div class="col-xl-2 col-md-4 col-sm-6">
              <a href="{{ route('orders') }}">
                  <div class="card text-center">
                      <div class="card-body">
                          <div class="avatar bg-light-success p-50 mb-1">
                              <div class="avatar-content">
                                  <i data-feather="award" class="font-medium-5"></i>
                              </div>
                          </div>
                          <h2 class="fw-bolder">{{ App\Models\Order::where('status', 'Completed')->count() ?? '' }}</h2>
                          <h3 class="card-text">طلبات مكتملة </h3>
                      </div>
                  </div>
              </a>
          </div>
          <div class="col-xl-2 col-md-4 col-sm-6">
              <a href="{{ route('blog.index') }}">
                  <div class="card text-center">
                      <div class="card-body">
                          <div class="avatar bg-light-danger p-50 mb-1">
                              <div class="avatar-content">
                                  <i data-feather="file" class="font-medium-5"></i>
                              </div>
                          </div>
                          <h2 class="fw-bolder">{{ App\Models\Blog::where('status', 1)->count() ?? '' }}</h2>
                          <h3 class="card-text">مقالات</h3>
                      </div>
                  </div>
              </a>
          </div>
      </div>
      <div class="row" id="basic-table">
          <div class="col-12">
              <div class="card">
                  <div class="card-header">
                      <h4 class="card-title">اخر الطلباات</h4>
                  </div>
                  <div class="table-responsive p-3">
                      <table class="table">
                          <thead>
                              <tr>
                                  <th> # </th>
                                  <th>{{ __('الاسم') }}</th>
                                  <th>{{ __('الهاتف') }}</th>
                                  <th>{{ __('الايميل') }}</th>
                                  <th>{{ __('النوع  ') }}</th>
                                  <th>{{ __('الحالة') }}</th>
                              </tr>
                          </thead>
                          <tbody>
                              @php
                                  $orders = App\Models\Order::latest()->limit(10)->get();

                              @endphp
                              @foreach ($orders as $index => $order)
                                  @php
                                      if($order->type == 'service'){
                                            $type = $order->relatedName() ?? '<span class="badge badge-light-primary">خدمة</span>'  ;
                                        }elseif($order->type == 'plan'){
                                            $type = $order->relatedName() ?? '<span class="badge badge-light-secondary">باقة</span>' ;
                                        }else{
                                            $type ='<span class="badge badge-light-info">إستشارة</span>' ;
                                        }
                                      if ($order->status == 'new') {
                                          $status = '<span class="badge badge-glow bg-info">جديد</span>';
                                      } elseif ($order->status == 'urgent') {
                                          $status = '<span class="badge badge-glow bg-warning">مستعجل</span>';
                                      } elseif ($order->status == 'Completed') {
                                          $status = '<span class="badge badge-glow bg-success">مكتمل</span>';
                                      } elseif ($order->status == 'Cancelled') {
                                          $status = '<span class="badge badge-glow bg-danger">ملغي</span>';
                                      } elseif ($order->status == 'under_review') {
                                          $status = '<span class="badge badge-glow bg-secondary">تحت المراجعة</span>';
                                      }
                                  @endphp
                                  <tr>
                                      <td>{{ ++$index }}</td>
                                      <td>{{ $order->name ?? '' }}</td>
                                      <td>{{ $order->phone ?? '' }}</td>
                                      <td>{{ $order->email ?? '' }}</td>
                                      <td>{!! $type ?? '' !!}</td>
                                      <td>{!! $status ?? '' !!}</td>
                                  </tr>
                              @endforeach
                          </tbody>
                      </table>
                  </div>
              </div>
          </div>
      </div>
      <div class="row" id="basic-table">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h4 class="card-title">اخر الطلباات</h4>
                </div>
                <div class="table-responsive p-3">
                    <table class="table">
                        <thead>
                            <tr>
                                <th> # </th>
                                <th>{{ __('الاسم') }}</th>
                                <th>{{ __('الهاتف') }}</th>
                                <th>{{ __('الايميل') }}</th>
                                <th>{{ __('الموضوع  ') }}</th>
                                <th>{{ __('الرسالة') }}</th>
                            </tr>
                        </thead>
                        <tbody>
                            @php
                                $messages = App\Models\Message::latest()->limit(10)->get();

                            @endphp
                            @foreach ($messages as $index => $message)
                                <tr>
                                    <td>{{ ++$index }}</td>
                                    <td>{{ $message->name ?? '' }}</td>
                                    <td>{{ $message->phone ?? '' }}</td>
                                    <td>{{ $message->email ?? '' }}</td>
                                    <td>{{ $message->subject ?? '' }}</td>
                                    <td>{{ $message->message ?? '' }}</td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
  @endsection
