@extends('layouts.dash_master')
@section('title')
    <title>{{ __('مركز المعرفة') }}</title>
@endsection

@section('dash-content')
    <div class="content-header row">
        <div class="content-header-left col-md-9 col-12 mb-2">
            <div class="row breadcrumbs-top">
                <div class="col-12">
                    <h2 class="content-header-title float-start mb-0">قائمة فئات مركز المعرفة</h2>
                    <div class="breadcrumb-wrapper">
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">Home</a>
                            </li>
                            <li class="breadcrumb-item"> {{ __('مركز المعرفة') }}
                            </li>
                        </ol>
                    </div>
                </div>
            </div>
        </div>
        <div class="content-header-right text-md-end col-md-3 col-12 d-md-block d-none">
            <div class="mb-1 breadcrumb-right">
                <a class="btn btn-primary create_knowledgebase"><i
                        class="fas fa-plus"></i> {{ __('اضف جديد') }}</a>
            </div>
        </div>
    </div>
    <div class="knowledgebases-list-wrapper">
        <!-- knowledgebases List Items -->
        <div class="row" id="basic-table">
            <div class="col-12">
                <div class="card">
                    <div class="card-header">
                        <h4 class="card-title">فئات مركز المعرفة</h4>
                    </div>
                    <div class="table-responsive p-3">
                        <table class="table">
                            <thead>
                                <tr>
                                    <th>#</th>
                                    <th>العنوان</th>
                                    <th>عدد المحتويات</th>
                                    <th>الحالة</th>
                                    <th>العمليات</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach ($knowledgebases as $index => $knowledgebase)
                                    <tr>
                                        <td>{{ ++$index }}</td>
                                        <td>{{ $knowledgebase->title_ar }}</td>
                                        <td>{{ $knowledgebase->contents->count() }}</td>
                                        <td>
                                            @if ($knowledgebase->status == 1)
                                                <a href="javascript:;"
                                                    onclick="changeknowledgebaseStatus({{ $knowledgebase->id }})">
                                                    <input type="checkbox" class="form-check-input" id="colorCheck3" checked >
                                                </a>
                                                <label class="form-check-label" for="colorCheck6">active</label>

                                            @else
                                                <a href="javascript:;"
                                                    onclick="changeknowledgebaseStatus({{ $knowledgebase->id }})">
                                                    <input type="checkbox" class="form-check-input" id="colorCheck4" >
                                                </a>
                                                <label class="form-check-label" for="colorCheck6">active</label>

                                            @endif
                                        </td>
                                        <td>
                                            <div class="dropdown">
                                                <button type="button" class="btn btn-sm dropdown-toggle hide-arrow py-0"
                                                    data-bs-toggle="dropdown">
                                                    <i data-feather="more-vertical"></i>
                                                </button>
                                                <div class="dropdown-menu dropdown-menu-end">
                                                    <a class="dropdown-item" id="knowledgebase-edit"
                                                        data-id="{{ $knowledgebase->id }}">
                                                        <i data-feather="edit-2" class="me-50"></i>
                                                        <span>تعديل</span>
                                                    </a>
                                                    <a href="{{route('knowledgebase.contents',$knowledgebase->id)}}" class="dropdown-item"  >
                                                        <i data-feather="edit" class="me-50"></i>
                                                        <span>المحتوى</span>
                                                    </a>
                                                    <a class="dropdown-item"
                                                        onclick="confirmDelete({{ $knowledgebase->id }})">
                                                        <i data-feather="trash" class="me-50"></i>
                                                        <span>حذف</span>
                                                    </a>
                                                </div>
                                            </div>
                                        </td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
        <!--/ knowledgebases List Items -->

    </div>
    <!-- Delete knowledgebases Modal -->
    <div class="modal fade modal-danger text-start" id="deleteknowledgebaseModal" tabindex="-1"
        aria-labelledby="deleteknowledgebasesLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered modal-sm">
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title" id="deleteknowledgebasesLabel">تأكيد حذف الفئة</h4>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="X"></button>
                </div>
                <div class="modal-body">
                    <p>هل انت متأكد من انك تريد حذف هذه الفئة ؟ لايمكن التراجع عن العملية</p>
                </div>
                <div class="modal-footer">
                    <form method="POST" id="deleteknowledgebaseForm">
                        @csrf
                        @method('DELETE')
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">اغلاق</button>
                        <button type="submit" class="btn btn-danger"> حذف</button>
                    </form>
                </div>
            </div>
        </div>
    </div>
    <!-- Modal -->
    <div class="modal fade text-start" id="ceratModal" tabindex="-1"
        aria-labelledby="ceratModal" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered modal-sm">
            <div class="modal-content">
                <!-- سيتم تحميل المحتوى هنا -->
            </div>
        </div>
    </div>
@endsection
@push('js')
    <script>
        function confirmDelete(knowledgebasesId) {
            const form = document.getElementById('deleteknowledgebaseForm');
            form.action = "{{ route('knowledgebases.destroy', ':id') }}".replace(':id', knowledgebasesId);
            const modal = new bootstrap.Modal(document.getElementById('deleteknowledgebaseModal'));
            modal.show();
        }
    </script>


    <script>
        $(document).ready(function() {
            $('.create_knowledgebase').on('click', function() {
                $.ajax({
                    url: "{{ route('knowledgebases.create') }}",
                    method: 'GET',
                    success: function(response) {
                        // تعيين المحتوى إلى المودال
                        $('#ceratModal .modal-content').html(response.modalContent);
                        $('#ceratModal').modal('show');
                    },
                    error: function() {
                        alert('حدث خطأ أثناء جلب بيانات الطلب.');
                    }
                });
            });
        });
    </script>
    <script>
        //knowledgebaseForm submit
        $(document).on('submit', '.knowledgebaseForm', function(e) {
            e.preventDefault();

            // مسح الأخطاء السابقة
            $('.text-danger').text('');

            $.ajax({
                url: "{{ route('knowledgebases.store') }}",
                method: 'POST',
                data: $(this).serialize(),
                success: function(response) {
                    localStorage.setItem('notification', JSON.stringify(response.notification));
                    window.location.href = response.redirect_url; // احصل على الرابط من الرد

                },
                error: function(xhr) {
                    let errors = xhr.responseJSON.errors;
                    if (errors) {
                        toastr.error('تاكد من البيانات');

                        // عرض الأخطاء لكل حقل
                        if (errors.phone) {
                            $('.error-phone').text(errors.phone[0]);
                        }
                        if (errors.name) {
                            $('.error-name').text(errors.name[0]);
                        }
                    }
                }
            });
        });

        //جلب بيانات تعديل الknowledgebase
        $(document).on('click', '#knowledgebase-edit', function(e) {
            var knowledgebaseId = $(this).data('id'); // Get ID

            $.ajax({
                url: "{{ route('knowledgebases.edit', ':id') }}".replace(':id', knowledgebaseId),
                method: 'GET',
                success: function(response) {
                    // تعيين المحتوى إلى المودال
                    $('#ceratModal .modal-content').html(response.modalContent);
                    $('#ceratModal').modal('show');
                },
                error: function() {
                    toastr.warning('حدث خطأ أثناء جلب بيانات الطلب.');
                }
            });
        });


        //knowledgebaseEditForm submit
        $(document).on('submit', '.knowledgebaseEditForm', function(e) {
            e.preventDefault();
            var knowledgebaseId = $(this).data('id'); // Get ID

            // مسح الأخطاء السابقة
            $('.text-danger').text('');

            $.ajax({
                url: "{{ route('knowledgebases.update', ':id') }}".replace(':id', knowledgebaseId),
                method: 'PUT',
                data: $(this).serialize(),
                success: function(response) {
                    localStorage.setItem('notification', JSON.stringify(response.notification));
                    window.location.href = response.redirect_url; // احصل على الرابط من الرد
                },
                error: function(xhr) {
                    let errors = xhr.responseJSON.errors;
                    if (errors) {
                        toastr.error('تاكد من البيانات');

                        // عرض الأخطاء لكل حقل
                        if (errors.phone) {
                            $('.error-phone').text(errors.phone[0]);
                        }
                        if (errors.name) {
                            $('.error-name').text(errors.name[0]);
                        }
                    }
                }
            });
        });

        function changeknowledgebaseStatus(id) {
            $.ajax({
                type: "put",
                data: {
                    _token: '{{ csrf_token() }}'
                },
                url: "{{ route('knowledgebase.status', ':id') }}".replace(':id', id),
                success: function(response) {
                    toastr.success(response)
                },
                error: function(err) {


                }
            })
        }
    </script>
@endpush
