@extends('layouts.dash_master')
@section('title')
    <title>
        {{ __('الباقات') }}</title>
@endsection

@section('dash-content')
    <div class="content-header row">
        <div class="content-header-left col-md-9 col-12 mb-2">
            <div class="row breadcrumbs-top">
                <div class="col-12">
                    <h2 class="content-header-title float-start mb-0">  الباقات</h2>
                    <div class="breadcrumb-wrapper">
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">الرئيسية</a>
                            </li>
                            <li class="breadcrumb-item"> {{ __('قائمة الباقات') }}
                            </li>
                        </ol>
                    </div>
                </div>
            </div>
        </div>
        <div class="content-header-right text-md-end col-md-3 col-12 d-md-block d-none">
            <div class="mb-1 breadcrumb-right">
                <a class="btn btn-primary create_plan"><i class="fas fa-plus"></i> {{ __('اضف جديد') }}</a>
            </div>
        </div>
    </div>
    <div class="plans-list-wrapper">
        <!-- plans List Items -->
        <div class="row" id="basic-table">
            <div class="col-12">
                <div class="card">
                    <div class="card-header">
                        <h4 class="card-title">قائمة الباقات</h4>
                    </div>
                    <div class="table-responsive p-3">
                        <table class="table">
                            <thead>
                                <tr>
                                    <th>#</th>
                                    <th>العنوان </th>
                                    <th>الحالة </th>
                                    <th>العمليات</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach ($plans as $index => $plan)
                                    <tr>
                                        <td>{{ ++$index }}</td>
                                        <td>{{ $plan->title_ar }} <img src="{{ asset('storage/files/' . $plan->image) }}"
                                                height="30" width="30" alt=""></td>

                                        <td>
                                            @if ($plan->status == 1)
                                                <a href="javascript:;" onclick="changeplanStatus({{ $plan->id }})">
                                                    <input type="checkbox" class="form-check-input" id="colorCheck3"
                                                        checked>
                                                </a>
                                                <label class="form-check-label" for="colorCheck6">active</label>
                                            @else
                                                <a href="javascript:;" onclick="changeplanStatus({{ $plan->id }})">
                                                    <input type="checkbox" class="form-check-input" id="colorCheck4">
                                                </a>
                                                <label class="form-check-label" for="colorCheck6">active</label>
                                            @endif
                                        </td>
                                        <td>
                                            <div class="d-flex gap-1">
                                                <a href="javascript:void(0);" id="plan-edit" data-id="{{ $plan->id }}"
                                                   class="btn btn-sm btn-icon btn-outline-primary" title="Edit">
                                                    <i data-feather="edit-2"></i>
                                                </a>
                                                <a href="javascript:void(0);" onclick="confirmDelete({{ $plan->id }})"
                                                   class="btn btn-sm btn-icon btn-outline-danger" title="Delete">
                                                    <i data-feather="trash"></i>
                                                </a>
                                            </div>
                                        </td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
        <!--/ plans List Items -->

    </div>
    <!-- Delete plans Modal -->
    <div class="modal fade modal-danger text-start" id="deleteplanModal" tabindex="-1" aria-labelledby="deleteplansLabel"
        aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered modal-sm">
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title" id="deleteplansLabel">تأكيد حذف</h4>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="X"></button>
                </div>
                <div class="modal-body">
                    <p>هل انت متأكد من انك تريد حذف هذه الباقة ؟ لايمكن التراجع عن العملية</p>
                </div>
                <div class="modal-footer">
                    <form method="POST" id="deleteplanForm">
                        @csrf
                        @method('DELETE')
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">اغلاق</button>
                        <button type="submit" class="btn btn-danger"> حذف</button>
                    </form>
                </div>
            </div>
        </div>
    </div>
    <!-- Modal -->
    <div class="modal fade text-start" id="ceratModal" tabindex="-1" aria-labelledby="ceratModal" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered modal-lg">
            <div class="modal-content">
                <!-- سيتم تحميل المحتوى هنا -->
            </div>
        </div>
    </div>
@endsection
@push('js')
    <script>
        function confirmDelete(plansId) {
            const form = document.getElementById('deleteplanForm');
            form.action = "{{ route('plan.destroy', ':id') }}".replace(':id', plansId) ;
            const modal = new bootstrap.Modal(document.getElementById('deleteplanModal'));
            modal.show();
        }
    </script>


    <script>
        $(document).ready(function() {
            $('.create_plan').on('click', function() {
                $.ajax({
                    url: "{{ route('plan.create') }}",
                    method: 'GET',
                    success: function(response) {
                        // تعيين المحتوى إلى المودال
                        $('#ceratModal .modal-content').html(response.modalContent);
                        $('#ceratModal').modal('show');
                    },
                    error: function() {
                        alert('حدث خطأ أثناء جلب بيانات الطلب.');
                    }
                });
            });
        });
    </script>
    <script>
        //planForm submit
        $(document).on('submit', '.planForm', function(e) {
            e.preventDefault();

            // مسح الأخطاء السابقة
            $('.text-danger').text('');

            let form = $(this)[0];
            let formData = new FormData(form); // يدعم الصور والملفات

            $.ajax({
                url: "{{ route('plan.store') }}" ,
                method: 'POST',
                data: formData,
                processData: false, // مهم جداً
                contentType: false, // مهم جداً
                success: function(response) {
                    localStorage.setItem('notification', JSON.stringify(response.notification));
                    window.location.href = response.redirect_url; // احصل على الرابط من الرد

                },
                error: function(xhr) {
                    let errors = xhr.responseJSON.errors;
                    if (errors) {
                        toastr.error('تاكد من البيانات');

                        // // عرض الأخطاء لكل حقل
                        // if (errors.phone) {
                        //     $('.error-phone').text(errors.phone[0]);
                        // }
                        // if (errors.name) {
                        //     $('.error-name').text(errors.name[0]);
                        // }
                    }
                }
            });
        });

        //جلب بيانات تعديل الplan
        $(document).on('click', '#plan-edit', function(e) {
            var planId = $(this).data('id'); // Get ID

            $.ajax({
                url: "{{ route('plan.edit', ':id') }}".replace(':id', planId),
                method: 'GET',
                success: function(response) {
                    // تعيين المحتوى إلى المودال
                    $('#ceratModal .modal-content').html(response.modalContent);
                    $('#ceratModal').modal('show');
                },
                error: function() {
                    toastr.warning('حدث خطأ أثناء جلب بيانات الطلب.');
                }
            });
        });


        //planEditForm submit
        $(document).on('submit', '.planEditForm', function(e) {
            e.preventDefault();
            var planId = $(this).data('id'); // Get ID
            // مسح الأخطاء السابقة
            $('.text-danger').text('');
            let form = $(this)[0];
            let formData = new FormData(form);
            formData.append('_token', $('meta[name="csrf-token"]').attr('content'));
            $.ajax({
                url: "{{ route('plan.update', ':id') }}".replace(':id', planId),
                method: 'POST',
                data: formData,
                processData: false, // مهم جداً
                contentType: false, // مهم جداً
                success: function(response) {
                    localStorage.setItem('notification', JSON.stringify(response.notification));
                    window.location.href = response.redirect_url; // احصل على الرابط من الرد
                },
                error: function(xhr) {
                    let errors = xhr.responseJSON.errors;
                    if (errors) {
                        toastr.error('تاكد من البيانات');

                        // // عرض الأخطاء لكل حقل
                        // if (errors.phone) {
                        //     $('.error-phone').text(errors.phone[0]);
                        // }
                        // if (errors.name) {
                        //     $('.error-name').text(errors.name[0]);
                        // }
                    }
                }
            });
        });

        function changeplanStatus(id) {
            $.ajax({
                type: "put",
                data: {
                    _token: '{{ csrf_token() }}'
                },
                url: "{{ route('plan.status', ':id') }}".replace(':id', id),
                success: function(response) {
                    toastr.success(response)
                },
                error: function(err) {


                }
            })
        }
    </script>
@endpush
