@extends('layouts.dash_master')
@section('title')
    <title>{{ __('انشاء عمل') }}</title>
@endsection

@section('dash-content')
    <div class="content-header row">
        <div class="content-header-left col-md-9 col-12 mb-2">
            <div class="row breadcrumbs-top">
                <div class="col-12">
                    <h2 class="content-header-title float-start mb-0">{{ __('انشاء سلايدر') }}</h2>
                    <div class="breadcrumb-wrapper">
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">الرئيسية</a>
                            </li>
                            <li class="breadcrumb-item"><a href="{{ route('work.index') }}">اعمالنا</a>
                            </li>
                            <li class="breadcrumb-item"> {{ __('انشاء عمل') }}
                            </li>
                        </ol>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <section id="multiple-column-form">
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-header">
                        <h4 class="card-title"> {{ __('انشاء عمل') }}</h4>
                    </div>
                    <div class="card-body">
                        <form action="{{ route('sliders.store') }}" method="POST"
                              enctype="multipart/form-data">
                            @csrf
                            <div class="row">
                                {{-- //image --}}
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <input type='file' onchange="loadFile_image(image_ar)" name="image_ar"
                                               id="image_ar"
                                               class="@error('image_ar') is-invalid @enderror" style="display:none;"/>
                                        <button id="output_image_ar" type="button"
                                                onclick="document.getElementById('image_ar').click();"
                                                style="width: 190px;
                                                    height: 120px;
                                                    border-radius: 0.357rem !important;
                                                    background-color: #cecbcb;
                                                    background-repeat: no-repeat;
                                                    background-size: cover;
                                                    background-position: center;
                                                    "/>
                                    </div>
                                    <label for="username">{{ __('Image ar') }}</label>
                                </div>
                                <script>
                                    var loadFile_image = function (image) {
                                        var image = document.getElementById('output_image_ar');
                                        var src = URL.createObjectURL(event.target.files[0]);
                                        image.style.backgroundImage = 'url(' + src + ')';
                                    };
                                </script>


                                <div class="col-md-4">
                                    <div class="form-group">
                                        <input type='file' onchange="loadFile_image_en(image_en)" name="image_en"
                                               id="image_en"
                                               class="@error('image_en') is-invalid @enderror" style="display:none;"/>
                                        <button id="output_image_en" type="button"
                                                onclick="document.getElementById('image_en').click();"
                                                style="width: 190px;
                                                    height: 120px;
                                                    border-radius: 0.357rem !important;
                                                    background-color: #cecbcb;
                                                    background-repeat: no-repeat;
                                                    background-size: cover;
                                                    background-position: center;
                                                    "/>
                                    </div>
                                    <label for="username">{{ __('Image en') }}</label>
                                </div>
                                <script>
                                    var loadFile_image_en = function (image) {
                                        var image2 = document.getElementById('output_image_en');
                                        var src2 = URL.createObjectURL(event.target.files[0]);
                                        image2.style.backgroundImage = 'url(' + src2 + ')';
                                    };
                                </script>


                                <hr class="invoice-spacing">
                                <div class="row">

                                    <x-input-field label="العنوان الفرعي ar" name="subtitle_ar"
                                                   value="{{ old('subtitle_ar') }}" maxLength="250" col="6" required/>
                                    <x-input-field label="العنوان الفرعي en" name="subtitle_en"
                                                   value="{{ old('subtitle_en') }}" maxLength="250" col="6" required/>


                                    <div class="col-12 mb-1">
                                        <x-input-field label="العنوان الرئيسي ar" name="title_ar"
                                                       value="{{ old('title_ar') }}" maxLength="250" col="6" required/>
                                        <x-input-field label="العنوان الرئيسي en" name="title_en"
                                                       value="{{ old('title_en') }}" maxLength="250" col="6" required/>
                                    </div>


                                    <div class="col-12 mb-1">
                                        <x-input-field label="{{ __('نص الزر ') }} ar" name="btn_ar"
                                                       value="{{ old('btn_ar') }}" maxLength="250" col="4" required/>
                                        <x-input-field label="{{ __('نص الزر ') }} en" name="btn_en"
                                                       value="{{ old('btn_en') }}" maxLength="250" col="4" required/>
                                        <x-input-field label="{{ __('رابط الزر') }} " name="url"
                                                       value="{{ old('url') }}" maxLength="250" col="4" required/>
                                    </div>



                                    <div class="col-6 mt-2">
                                        <label class="form-label pb-1">هل نشط:</label>
                                        <input type="checkbox" class="form-check-input" name="status" checked value="1"
                                               id="colorCheck4">
                                        <label class="form-label ">نشط </label>
                                    </div>


                                    <div class="col-6 mt-2">
                                        <label class="form-label pb-1">عرض العملاء:</label>
                                        <input type="checkbox" class="form-check-input" name="clients" checked value="1"
                                               id="colorCheck4">
                                        <label class="form-label ">نشط </label>
                                    </div>


                                    <div class="col-12">
                                        <button type="submit"
                                                class="btn btn-primary me-1 waves-effect waves-float waves-light">Submit
                                        </button>
                                    </div>
                                </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </section>
@endsection

@push('js')
    <script src="https://cdn.ckeditor.com/ckeditor5/39.0.1/classic/ckeditor.js"></script>
    <script>

        ClassicEditor
            .create(document.querySelector('#content'))
            .then(editor => {
                editor.editing.view.change(writer => {
                    writer.setStyle('min-height', '300px', editor.editing.view.document.getRoot());
                });
            })
            .catch(error => {
                console.error(error);
            });
    </script>

    <script>
        document.addEventListener("DOMContentLoaded", function () {
            let tagInput = document.getElementById("tag-input");
            let tagContainer = document.getElementById("tag-container");
            let hiddenTags = document.getElementById("hidden-tags");
            let tags = [];

            tagInput.addEventListener("keypress", function (event) {
                if (event.key === "Enter") {
                    event.preventDefault();
                    let tagText = tagInput.value.trim();

                    if (tagText !== "" && !tags.includes(tagText)) {
                        tags.push(tagText);
                        updateTags();
                        tagInput.value = "";
                    }
                }
            });

            function updateTags() {
                tagContainer.innerHTML = "";
                tags.forEach((tag, index) => {
                    let tagElement = document.createElement("span");
                    tagElement.classList.add("tag");
                    tagElement.innerHTML =
                        `${tag} <button type="button" onclick="removeTag(${index})">×</button>`;
                    tagContainer.appendChild(tagElement);
                });

                // إعادة إدخال الحقل حتى يكون موجود
                let newInput = document.createElement("input");
                newInput.type = "text";
                newInput.id = "tag-input";
                newInput.classList.add("form-control");
                newInput.placeholder = "أدخل التاغ واضغط Enter";
                tagContainer.appendChild(newInput);
                tagInput = newInput;
                tagInput.addEventListener("keypress", function (event) {
                    if (event.key === "Enter") {
                        event.preventDefault();
                        let tagText = tagInput.value.trim();

                        if (tagText !== "" && !tags.includes(tagText)) {
                            tags.push(tagText);
                            updateTags();
                            tagInput.value = "";
                        }
                    }
                });

                hiddenTags.value = tags.join(",");
            }

            window.removeTag = function (index) {
                tags.splice(index, 1);
                updateTags();
            };
        });
    </script>
@endpush
