@extends('layouts.dash_master')
@section('title')
    <title>{{ __('dash.Contact') }}</title>
@endsection
@include('layouts.admin_sidebar')
@section('dash-content')
    <!-- Main Content -->
    <div class="main-content">
        <section class="section">
            <div class="section-header">
                <h1>{{ __('dash.Contact') }}</h1>
                <div class="section-header-breadcrumb">
                    <div class="breadcrumb-item active"><a
                            href="{{ route('admin.dashboard') }}">{{ __('dash.Dashboard') }}</a></div>
                    <div class="breadcrumb-item">{{ __('dash.Contact') }}</div>
                </div>
            </div>
            <div class="row">
                <x-card title="{{ __('dash.Name') }}" color="success" icon="fas fa-solid fa-user"
                    value="{{ $user->name }}" />
                <x-card title="{{ __('dash.phone') }}" color="info" icon="fas fa-solid fa-phone"
                    value="{{ $user->phone }}" />
                <x-card title="{{ __('dash.Email') }}" color="primary" icon="fas fa-solid fa-email"
                    value="{{ $user->email }}" />
            </div>

        </section>
        <section>
            <div class="card">
            <div class="card-header">
                    <h5 class="card-title">{{ __('dash.Update Password') }}</h5>
                </div>
                <div class="card-body">
                    <form class="userForm" enctype="multipart/form-data">
                        @csrf
                        <div class="row">
                            <x-input-field label="{{ __('dash.Password') }}" name="password" value="{{ old('password') }}"
                                required="true" type="password" />
                            <x-input-field label="{{ __('dash.New Password') }}" name="password" value="{{ old('password') }}"
                                required="true" type="password" />
                            <x-input-field label="{{ __('dash.Confirm Password') }}" name="password_confirmation"
                                value="" required="true" type="password" />
                        </div>


                        <div class="row">
                            <div class="col-12">
                                <button class="btn btn-primary">{{ __('dash.Save') }}</button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </section>
    </div>
@endsection
@push('js')
    <script></script>
@endpush
