<?php
    $setting = App\Models\Home_setting::select('logo','phone','email','address','footer','footer_en','whatsapp'
    ,'facebook','instagram','linkedin','twitter','site_name','site_name_en')->first();
?>
<footer class="site-footer footer-dark">
  <div class="footer-main">
    <div class="container">
      <div class="row">
        <div class="col-xl-3 col-md-5">
          <div class="widget widget-address-info">
            <h5 class="widget-title"><?php echo e(app()->getLocale() == 'ar' ? $setting->footer : $setting->footer_en); ?></h5>
            <ul class="address-info-list">
              <li><i class="icon"><img class="img-fluid" src="<?php echo e(asset('front/images/svg/address-info-contacts.svg')); ?>" alt=""></i><span
                  class="info"><span> </span><?php echo e($setting->address); ?></span></li>
              <li><i class="icon"><img class="img-fluid" src="<?php echo e(asset('front/images/svg/address-info-headphone.svg')); ?>" alt=""></i><span
                  class="info"><span><a href="tel:<?php echo e($setting->phone); ?>"><?php echo e($setting->phone); ?></a> </span></li>
              <li><i class="icon"><img class="img-fluid" src="<?php echo e(asset('front/images/svg/address-info-email.svg')); ?>" alt=""></i><span
                  class="info"><span><a href="mailto:<?php echo e($setting->email); ?>"><?php echo e($setting->email); ?></a></span>24x7  </span></li>
            </ul>
          </div>
        </div>

        <div class="col-xl-6 col-md-7">
          <div class="widget">
            <div class="widget widget-menu">
              <h6 class="widget-title"><?php echo e(__('lang.Quick Links')); ?></h6>
              <ul class="list-unstyled list-col-3 mb-0">
                <li><a href="<?php echo e(route('front.services')); ?>"><?php echo e(__('lang.Services')); ?></a></li>
                <li><a href="<?php echo e(route('front.plans')); ?>"><?php echo e(__('lang.Plans')); ?></a></li>
                <li><a href="<?php echo e(route('about')); ?>"><?php echo e(__('lang.About Us')); ?></a></li>
                <li><a href="<?php echo e(route('front.Opinion')); ?>"><?php echo e(__('lang.Opinion')); ?></a></li>
                <li><a href="<?php echo e(route('front.faq')); ?>"><?php echo e(__('lang.FAQ')); ?></a></li>
                <li><a href="<?php echo e(route('front.contact')); ?>"> <?php echo e(__('lang.Contact us')); ?></a></li>
                <li><a href="<?php echo e(route('front.our_work')); ?>"><?php echo e(__('lang.Our work')); ?></a> </li>
                <li><a href="<?php echo e(route('front.Terms_of_Service')); ?>"><?php echo e(__('lang.Terms of Service')); ?> </a> </li>
                <li><a href="<?php echo e(route('front.Terms_of_Use')); ?>"><?php echo e(__('lang.Terms of Use')); ?> </a> </li>
                <li><a href="<?php echo e(route('front.Privacy')); ?>"><?php echo e(__('lang.Privacy')); ?> </a> </li>
                <li><a href="<?php echo e(route('front.blogs')); ?>"><?php echo e(__('lang.Blog')); ?> </a> </li>
              </ul>
            </div>
          </div>
        </div>
        <div class="col-xl-2 col-md-12 ms-auto">
            <p><a class="footer-logo" href="index.html"><img class="img-fluid" src="<?php echo e(asset('storage/files/' . ($setting->logo ?? 'default.png'))); ?>" alt="logo"></a></p>

          <div class="widget-socail">
            <div class="social-icons" style="display: flex; gap: 40px;">
                <a href="<?php echo e($setting->whatsapp); ?>" target="_blank" style="color: #25D366;">
                    <i class="fab fa-whatsapp fa-lg"></i>
                </a>
                <a href="<?php echo e($setting->facebook); ?>" target="_blank" style="color: #3b5998;">
                    <i class="fab fa-facebook-f fa-lg"></i>
                </a>
                <a href="<?php echo e($setting->twitter); ?>" target="_blank" style="color: #1DA1F2;">
                    <i class="fab fa-twitter fa-lg"></i>
                </a>
                <a href="<?php echo e($setting->instagram); ?>" target="_blank" style="color: #C13584;">
                    <i class="fab fa-instagram fa-lg"></i>
                </a>
                <a href="<?php echo e($setting->linkedin); ?>" target="_blank" style="color: #0077b5;">
                    <i class="fab fa-linkedin-in fa-lg"></i>
                </a>
            </div>
          </div>
        </div>
      </div>

    </div>
  </div>
  <div class="footer-copyright">
    <div class="container">
      <div class="row align-items-center">
        <div class="col-lg-6">
          <p><a class="footer-logo" href="index.html"><img class="img-fluid" src="<?php echo e(asset('storage/files/' . ($setting->logo ?? 'default.png'))); ?>" alt="logo"></a></p>
        </div>
        <div class="col-lg-6 text-lg-end">
          <p>Develop and design by <a href="#"><?php echo e(app()->getLocale() == 'ar' ? $setting->site_name : $setting->site_name_en); ?></a></p>
        </div>
      </div>
    </div>
  </div>
</footer>

<!--=================================
    Back To Top -->
<div class="back-to-top">
  <svg class="progress-circle svg-content" width="100%" height="100%" viewBox="-1 -1 102 102">
    <path d="M50,1 a49,49 0 0,1 0,98 a49,49 0 0,1 0,-98" />
  </svg>
</div>
<?php /**PATH C:\xampp\htdocs\tabadul_Irada\resources\views/Frontend/Includes/Footer.blade.php ENDPATH**/ ?>