  
  <?php $__env->startSection('title'); ?>
      <title><?php echo e(__('dash.Dashboard')); ?></title>
  <?php $__env->stopSection(); ?>

  <?php $__env->startSection('dash-content'); ?>
      <div class="content-header row">
          <div class="content-header-left col-md-9 col-12 mb-2">
              <div class="row breadcrumbs-top">
                  <div class="col-12">
                      <h2 class="content-header-title float-start mb-0">الرئيسية</h2>
                      <div class="breadcrumb-wrapper">
                          <ol class="breadcrumb">
                              <li class="breadcrumb-item"><a href="<?php echo e(route('admin.dashboard')); ?>">الرئيسية</a>
                              </li>

                          </ol>
                      </div>
                  </div>
              </div>
          </div>
      </div>
      <div class="row">
          <div class="col-xl-2 col-md-4 col-sm-6">
              <a href="<?php echo e(route('orders')); ?>">
                  <div class="card text-center">
                      <div class="card-body">
                          <div class="avatar bg-light-info p-50 mb-1">
                              <div class="avatar-content">
                                  <i data-feather="eye" class="font-medium-5"></i>
                              </div>
                          </div>
                          <h2 class="fw-bolder"><?php echo e(App\Models\Order::where('status', 'new')->count() ?? ''); ?></h2>
                          <h3 class="card-text">طلبات جديدة </h3>
                      </div>
                  </div>
              </a>
          </div>
          <div class="col-xl-2 col-md-4 col-sm-6">
              <a href="<?php echo e(route('messages')); ?>">
                  <div class="card text-center">
                      <div class="card-body">
                          <div class="avatar bg-light-warning p-50 mb-1">
                              <div class="avatar-content">
                                  <i data-feather="message-square" class="font-medium-5"></i>
                              </div>
                          </div>
                          <h2 class="fw-bolder"><?php echo e(App\Models\Message::count() ?? ''); ?></h2>
                          <h3 class="card-text">رسائل</h3>
                      </div>
                  </div>
              </a>
          </div>
          <div class="col-xl-2 col-md-4 col-sm-6">
              <a href="<?php echo e(route('orders')); ?>">

                  <div class="card text-center">
                      <div class="card-body">
                          <div class="avatar bg-light-danger p-50 mb-1">
                              <div class="avatar-content">
                                  <i data-feather="shopping-bag" class="font-medium-5"></i>
                              </div>
                          </div>
                          <h2 class="fw-bolder"><?php echo e(App\Models\Order::where('status', 'urgent')->count() ?? ''); ?></h2>
                          <h3 class="card-text">طلبات مستعجلة</h3>
                      </div>
                  </div>
              </a>
          </div>
          <div class="col-xl-2 col-md-4 col-sm-6">
              <a href="<?php echo e(route('orders')); ?>">

                  <div class="card text-center">
                      <div class="card-body">
                          <div class="avatar bg-light-primary p-50 mb-1">
                              <div class="avatar-content">
                                  <i data-feather="heart" class="font-medium-5"></i>
                              </div>
                          </div>
                          <h2 class="fw-bolder"><?php echo e(App\Models\Order::where('status', 'under_review')->count() ?? ''); ?></h2>
                          <h5 class="card-text">طلبات تحت المراجعة</h5>
                      </div>
                  </div>
              </a>
          </div>
          <div class="col-xl-2 col-md-4 col-sm-6">
              <a href="<?php echo e(route('orders')); ?>">
                  <div class="card text-center">
                      <div class="card-body">
                          <div class="avatar bg-light-success p-50 mb-1">
                              <div class="avatar-content">
                                  <i data-feather="award" class="font-medium-5"></i>
                              </div>
                          </div>
                          <h2 class="fw-bolder"><?php echo e(App\Models\Order::where('status', 'Completed')->count() ?? ''); ?></h2>
                          <h3 class="card-text">طلبات مكتملة </h3>
                      </div>
                  </div>
              </a>
          </div>
          <div class="col-xl-2 col-md-4 col-sm-6">
              <a href="<?php echo e(route('blog.index')); ?>">
                  <div class="card text-center">
                      <div class="card-body">
                          <div class="avatar bg-light-danger p-50 mb-1">
                              <div class="avatar-content">
                                  <i data-feather="file" class="font-medium-5"></i>
                              </div>
                          </div>
                          <h2 class="fw-bolder"><?php echo e(App\Models\Blog::where('status', 1)->count() ?? ''); ?></h2>
                          <h3 class="card-text">مقالات</h3>
                      </div>
                  </div>
              </a>
          </div>
      </div>
      <div class="row" id="basic-table">
          <div class="col-12">
              <div class="card">
                  <div class="card-header">
                      <h4 class="card-title">اخر الطلباات</h4>
                  </div>
                  <div class="table-responsive p-3">
                      <table class="table">
                          <thead>
                              <tr>
                                  <th> # </th>
                                  <th><?php echo e(__('الاسم')); ?></th>
                                  <th><?php echo e(__('الهاتف')); ?></th>
                                  <th><?php echo e(__('الايميل')); ?></th>
                                  <th><?php echo e(__('النوع  ')); ?></th>
                                  <th><?php echo e(__('الحالة')); ?></th>
                              </tr>
                          </thead>
                          <tbody>
                              <?php
                                  $orders = App\Models\Order::latest()->limit(10)->get();

                              ?>
                              <?php $__currentLoopData = $orders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $order): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                  <?php
                                      if($order->type == 'service'){
                                            $type = $order->relatedName() ?? '<span class="badge badge-light-primary">خدمة</span>'  ;
                                        }elseif($order->type == 'plan'){
                                            $type = $order->relatedName() ?? '<span class="badge badge-light-secondary">باقة</span>' ;
                                        }else{
                                            $type ='<span class="badge badge-light-info">إستشارة</span>' ;
                                        }
                                      if ($order->status == 'new') {
                                          $status = '<span class="badge badge-glow bg-info">جديد</span>';
                                      } elseif ($order->status == 'urgent') {
                                          $status = '<span class="badge badge-glow bg-warning">مستعجل</span>';
                                      } elseif ($order->status == 'Completed') {
                                          $status = '<span class="badge badge-glow bg-success">مكتمل</span>';
                                      } elseif ($order->status == 'Cancelled') {
                                          $status = '<span class="badge badge-glow bg-danger">ملغي</span>';
                                      } elseif ($order->status == 'under_review') {
                                          $status = '<span class="badge badge-glow bg-secondary">تحت المراجعة</span>';
                                      }
                                  ?>
                                  <tr>
                                      <td><?php echo e(++$index); ?></td>
                                      <td><?php echo e($order->name ?? ''); ?></td>
                                      <td><?php echo e($order->phone ?? ''); ?></td>
                                      <td><?php echo e($order->email ?? ''); ?></td>
                                      <td><?php echo $type ?? ''; ?></td>
                                      <td><?php echo $status ?? ''; ?></td>
                                  </tr>
                              <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                          </tbody>
                      </table>
                  </div>
              </div>
          </div>
      </div>
      <div class="row" id="basic-table">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h4 class="card-title">اخر الطلباات</h4>
                </div>
                <div class="table-responsive p-3">
                    <table class="table">
                        <thead>
                            <tr>
                                <th> # </th>
                                <th><?php echo e(__('الاسم')); ?></th>
                                <th><?php echo e(__('الهاتف')); ?></th>
                                <th><?php echo e(__('الايميل')); ?></th>
                                <th><?php echo e(__('الموضوع  ')); ?></th>
                                <th><?php echo e(__('الرسالة')); ?></th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php
                                $messages = App\Models\Message::latest()->limit(10)->get();

                            ?>
                            <?php $__currentLoopData = $messages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $message): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td><?php echo e(++$index); ?></td>
                                    <td><?php echo e($message->name ?? ''); ?></td>
                                    <td><?php echo e($message->phone ?? ''); ?></td>
                                    <td><?php echo e($message->email ?? ''); ?></td>
                                    <td><?php echo e($message->subject ?? ''); ?></td>
                                    <td><?php echo e($message->message ?? ''); ?></td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
  <?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.dash_master', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/ivadev/public_html/resources/views/admin/dashboard.blade.php ENDPATH**/ ?>