<?php $__env->startSection('title'); ?>
    <title><?php echo e(__('الخدمات')); ?></title>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('dash-content'); ?>
    <div class="content-header row">
        <div class="content-header-left col-md-9 col-12 mb-2">
            <div class="row breadcrumbs-top">
                <div class="col-12">
                    <h2 class="content-header-title float-start mb-0">قائمة الخدمات</h2>
                    <div class="breadcrumb-wrapper">
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item"><a href="<?php echo e(route('admin.dashboard')); ?>">الرئيسية</a>
                            </li>
                            <li class="breadcrumb-item"> <?php echo e(__('الخدمات')); ?>

                            </li>
                        </ol>
                    </div>
                </div>
            </div>
        </div>
        <div class="content-header-right text-md-end col-md-3 col-12 d-md-block d-none">
            <div class="mb-1 breadcrumb-right">
                <a class="btn btn-primary create_service"><i
                        class="fas fa-plus"></i> <?php echo e(__('اضفة جديد')); ?></a>
            </div>
        </div>
    </div>
    <div class="services-list-wrapper">
        <!-- services List Items -->
        <div class="row" id="basic-table">
            <div class="col-12">
                <div class="card">
                    <div class="card-header">
                        <h4 class="card-title">قائمة الخدمات</h4>
                    </div>
                    <div class="table-responsive p-3">
                        <table class="table">
                            <thead>
                                <tr>
                                    <th>#</th>
                                    <th>العنوان </th>
                                    <th>الحالة</th>
                                    <th>العمليات</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $services; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $service): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td><?php echo e(++$index); ?></td>
                                        <td><?php echo e($service->title); ?></td>
                                        <td>
                                            <?php if($service->status == 1): ?>
                                                <a href="javascript:;"
                                                    onclick="changeserviceStatus(<?php echo e($service->id); ?>)">
                                                    <input type="checkbox" class="form-check-input" id="colorCheck3" checked >
                                                </a>
                                                <label class="form-check-label" for="colorCheck6">نشط</label>

                                            <?php else: ?>
                                                <a href="javascript:;"
                                                    onclick="changeserviceStatus(<?php echo e($service->id); ?>)">
                                                    <input type="checkbox" class="form-check-input" id="colorCheck4" >
                                                </a>
                                                <label class="form-check-label" for="colorCheck6">نشط</label>

                                            <?php endif; ?>
                                        </td>
                                        <td>
                                            <div class="d-flex gap-1">
                                                <a href="javascript:void(0);" id="service-edit" data-id="<?php echo e($service->id); ?>"
                                                   class="btn btn-sm btn-icon btn-outline-primary" title="Edit">
                                                    <i data-feather="edit-2"></i>
                                                </a>
                                                <a href="javascript:void(0);" onclick="confirmDelete(<?php echo e($service->id); ?>)"
                                                   class="btn btn-sm btn-icon btn-outline-danger" title="Delete">
                                                    <i data-feather="trash"></i>
                                                </a>
                                            </div>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
        <!--/ services List Items -->

    </div>
    <!-- Delete services Modal -->
    <div class="modal fade modal-danger text-start" id="deleteserviceModal" tabindex="-1"
        aria-labelledby="deleteservicesLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered modal-sm">
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title" id="deleteservicesLabel">حذف خدمة!</h4>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="X"></button>
                </div>
                <div class="modal-body">
                    <p>هل انت متأكد من حذف هذه الخدمة؟ لايمكن التراجع عن هذه العملية</p>
                </div>
                <div class="modal-footer">
                    <form method="POST" id="deleteserviceForm">
                        <?php echo csrf_field(); ?>
                        <?php echo method_field('DELETE'); ?>
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">اغلاق</button>
                        <button type="submit" class="btn btn-danger"> حذف</button>
                    </form>
                </div>
            </div>
        </div>
    </div>
    <!-- Modal -->
    <div class="modal fade text-start" id="ceratModal" tabindex="-1"
        aria-labelledby="ceratModal" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered modal-md">
            <div class="modal-content">
                <!-- سيتم تحميل المحتوى هنا -->
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startPush('js'); ?>
    <script>
        function confirmDelete(servicesId) {
            const form = document.getElementById('deleteserviceForm');
            form.action =  "<?php echo e(route('service.destroy', ':id')); ?>".replace(':id', servicesId) ;
            const modal = new bootstrap.Modal(document.getElementById('deleteserviceModal'));
            modal.show();
        }
    </script>


    <script>
        $(document).ready(function() {
            $('.create_service').on('click', function() {
                $.ajax({
                    url: "<?php echo e(route('service.create')); ?>" ,
                    method: 'GET',
                    success: function(response) {
                        // تعيين المحتوى إلى المودال
                        $('#ceratModal .modal-content').html(response.modalContent);
                        $('#ceratModal').modal('show');
                    },
                    error: function() {
                        alert('حدث خطأ أثناء جلب بيانات الطلب.');
                    }
                });
            });
        });
    </script>
    <script>
        //serviceForm submit
        $(document).on('submit', '.serviceForm', function(e) {
            e.preventDefault();

            // مسح الأخطاء السابقة
            $('.text-danger').text('');

            $.ajax({
                url: "<?php echo e(route('service.store')); ?>" ,
                method: 'POST',
                data: $(this).serialize(),
                success: function(response) {
                    localStorage.setItem('notification', JSON.stringify(response.notification));
                    window.location.href = response.redirect_url; // احصل على الرابط من الرد

                },
                error: function(xhr) {
                    let errors = xhr.responseJSON.errors;
                    if (errors) {
                        toastr.error('تاكد من البيانات');

                        // عرض الأخطاء لكل حقل
                        if (errors.title) {
                            $('.error-title').text(errors.title[0]);
                        }
                        if (errors.body) {
                            $('.error-body').text(errors.body[0]);
                        }
                        if (errors.title_en) {
                            $('.error-title_en').text(errors.title_en[0]);
                        }
                        if (errors._en) {
                            $('.error-_en').text(errors._en[0]);
                        }
                    }
                }
            });
        });

        //جلب بيانات تعديل الservice
        $(document).on('click', '#service-edit', function(e) {
            var serviceId = $(this).data('id'); // Get ID

            $.ajax({
                url: "<?php echo e(route('service.edit', ':id')); ?>".replace(':id', serviceId) ,
                method: 'GET',
                success: function(response) {
                    // تعيين المحتوى إلى المودال
                    $('#ceratModal .modal-content').html(response.modalContent);
                    $('#ceratModal').modal('show');
                },
                error: function() {
                    toastr.warning('حدث خطأ أثناء جلب بيانات الطلب.');
                }
            });
        });


        //serviceEditForm submit
        $(document).on('submit', '.serviceEditForm', function(e) {
            e.preventDefault();
            var serviceId = $(this).data('id'); // Get ID

            // مسح الأخطاء السابقة
            $('.text-danger').text('');

            $.ajax({
                url: "<?php echo e(route('service.update', ':id')); ?>".replace(':id', serviceId),
                method: 'PUT',
                data: $(this).serialize(),
                success: function(response) {
                    localStorage.setItem('notification', JSON.stringify(response.notification));
                    window.location.href = response.redirect_url; // احصل على الرابط من الرد
                },
                error: function(xhr) {
                    let errors = xhr.responseJSON.errors;
                    if (errors) {
                        toastr.error('تاكد من البيانات');

                        if (errors.title) {
                            $('.error-title').text(errors.title[0]);
                        }
                        if (errors.body) {
                            $('.error-body').text(errors.body[0]);
                        }
                        if (errors.title_en) {
                            $('.error-title_en').text(errors.title_en[0]);
                        }
                        if (errors._en) {
                            $('.error-_en').text(errors._en[0]);
                        }
                    }
                }
            });
        });

        function changeserviceStatus(id) {
            $.ajax({
                type: "put",
                data: {
                    _token: '<?php echo e(csrf_token()); ?>'
                },
                url: "<?php echo e(route('service.status', ':id')); ?>".replace(':id', id) ,
                success: function(response) {
                    toastr.success(response)
                },
                error: function(err) {


                }
            })
        }
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.dash_master', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/ivadev/public_html/resources/views/admin/service/services.blade.php ENDPATH**/ ?>