<?php $__env->startSection('title'); ?>
    <title><?php echo e(__('اعمالنا')); ?></title>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('dash-content'); ?>
    <div class="content-header row">
        <div class="content-header-left col-md-9 col-12 mb-2">
            <div class="row breadcrumbs-top">
                <div class="col-12">
                    <h2 class="content-header-title float-start mb-0">قائمة اعمالنا</h2>
                    <div class="breadcrumb-wrapper">
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item"><a href="<?php echo e(route('admin.dashboard')); ?>">الرئيسية</a>
                            </li>
                            <li class="breadcrumb-item"> <?php echo e(__('اعمالنا')); ?>

                            </li>
                        </ol>
                    </div>
                </div>
            </div>
        </div>
        <div class="content-header-right text-md-end col-md-3 col-12 d-md-block d-none">
            <div class="mb-1 breadcrumb-right">
                <a href="<?php echo e(route('work.create')); ?>" class="btn btn-primary create_agent"><i class="fas fa-plus"></i> <?php echo e(__('اضف جديد')); ?></a>
            </div>
        </div>
    </div>
    <div class="work-list-wrapper">
        <!-- work List Items -->
        <div class="row">
            <?php $__currentLoopData = $works; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $work): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="col-md-4 col-6">
                <div class="card">
                    <a href="">
                        <img class="card-img-top img-fluid" src="<?php echo e(asset('storage/files/' . ($work->image ?? 'default.png'))); ?>"
                            alt="work Post pic">
                    </a>
                    <div class="card-body">
                        <h4 class="card-title">
                            <a href="" class="work-title-truncate text-body-heading"><?php echo e($work->title); ?></a>
                        </h4>
                        <div class="d-flex">
                            <div class="author-info">
                                <small class="text-muted"><?php echo e($work->created_at->format('d/m/Y')); ?></small>
                            </div>
                        </div>
                        <div class="my-1 py-25">
                            <a>
                                <span class="badge rounded-pill badge-light-primary"><?php echo e($work->category); ?></span>
                            </a>
                        </div>

                        <hr>
                        <div class="d-flex justify-content-between align-items-center">
                                <button class="btn btn-flat-danger" onclick="confirmDelete(<?php echo e($work->id); ?>)">
                                    حذف <i data-feather='trash'></i>
                                </button>
                            <a href="<?php echo e(route('work.edit',$work->id)); ?>" class="fw-bold">تعديل <i data-feather='edit'></i></a>
                        </div>
                    </div>
                </div>
            </div>

            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
        <!--/ work List Items -->

    </div>
  <!-- Delete work Modal -->
<div class="modal fade modal-danger text-start" id="deleteworkModal" tabindex="-1" aria-labelledby="deleteworkLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-sm">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title" id="deleteworkLabel">حذف عمل</h4>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="X"></button>
            </div>
            <div class="modal-body">
                <p >هل انت متأكد من حذف هذا العمل؟ لايمكن التراجع عن هذه العملية</p>
            </div>
            <div class="modal-footer">
                <form method="POST" id="deleteworkForm">
                    <?php echo csrf_field(); ?>
                    <?php echo method_field('DELETE'); ?>
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">اغلاق</button>
                    <button type="submit" class="btn btn-danger"> حذف</button>
                </form>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php $__env->startPush('js'); ?>
<script>
    function confirmDelete(workId) {
        const form = document.getElementById('deleteworkForm');
        form.action =  "<?php echo e(route('work.destroy', ':id')); ?>".replace(':id', workId) ; // غيّر المسار حسب الراوت عندك
        const modal = new bootstrap.Modal(document.getElementById('deleteworkModal'));
        modal.show();
    }
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.dash_master', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/ivadev/public_html/resources/views/admin/work/works.blade.php ENDPATH**/ ?>