<?php $__env->startSection('title'); ?>
    <title><?php echo e(__('الرسائل')); ?></title>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('dash-content'); ?>
    <div class="content-header row">
        <div class="content-header-left col-md-9 col-12 mb-2">
            <div class="row breadcrumbs-top">
                <div class="col-12">
                    <h2 class="content-header-title float-start mb-0">قائمة الرسائل</h2>
                    <div class="breadcrumb-wrapper">
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item"><a href="<?php echo e(route('admin.dashboard')); ?>">الرئيسية</a>
                            </li>
                            <li class="breadcrumb-item"> <?php echo e(__('الرسائل')); ?>

                            </li>
                        </ol>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="orders-list-wrapper">
        <!-- orders List Items -->
        <div class="row" id="basic-table">
            <div class="col-12">

                <div class="card">

                    <div class="card-header">
                        <h4 class="card-title">قائمة الرسائل</h4>
                    </div>
                    <div class="row">
                        <div class="col">
                            <div class="card">
                                <div class="card-body">
                                    <div class="table-responsive table-invoice">
                                        <table class="order-list-table table">
                                            <thead class="thead-light">
                                                <tr>
                                                    <th><?php echo e(__('الاسم')); ?></th>
                                                    <th><?php echo e(__('الهاتف')); ?></th>
                                                    <th><?php echo e(__('الايميل')); ?></th>
                                                    <th><?php echo e(__('الموضوع  ')); ?></th>
                                                    <th><?php echo e(__('الرسالة')); ?></th>
                                                    <th><?php echo e(__('العمليات')); ?></th>
                                                </tr>
                                            </thead>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

    </div>
    <!-- Delete orders Modal -->
    <div class="modal fade modal-danger text-start" id="deleteorderModal" tabindex="-1" aria-labelledby="deleteordersLabel"
        aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered modal-sm">
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title" id="deleteordersLabel">تأكيد حذف</h4>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="X"></button>
                </div>
                <div class="modal-body">
                    <p>هل انت متأكد من انك تريد حذف هذه الميزة ؟ لايمكن التراجع عن العملية</p>
                </div>
                <div class="modal-footer">
                    <form method="POST" id="deleteorderForm">
                        <?php echo csrf_field(); ?>
                        <?php echo method_field('DELETE'); ?>
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">اغلاق</button>
                        <button type="submit" class="btn btn-danger"> حذف</button>
                    </form>
                </div>
            </div>
        </div>
    </div>
    <!-- Modal -->
    <div class="modal fade text-start" id="ceratModal" tabindex="-1" aria-labelledby="ceratModal" >
        <div class="modal-dialog modal-dialog-centered modal-sm">
            <div class="modal-content">
                <!-- سيتم تحميل المحتوى هنا -->
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startPush('js'); ?>

    <script src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>

    <script src="https://cdn.datatables.net/buttons/2.4.2/js/dataTables.buttons.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/2.4.2/js/buttons.html5.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/2.4.2/js/buttons.print.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.10.1/jszip.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/feather-icons/4.28.0/feather.min.js"></script>

    <script>
        $(document).ready(function() {
            $('.order-list-table').DataTable().destroy();
            $('.order-list-table').DataTable({
                "processing": true,
                "serverSide": true,
                "lengthMenu": [
                    [10, 25, 50, 100, 250, 500],
                    [10, 25, 50, 100, 250, 500]
                ],
                ajax: {
                    url: "<?php echo e(route('messages')); ?>",
                }, // JSON file to add data
                columns: [
                    // columns according to JSON

                    {
                        data: 'name'
                    },
                    {
                        data: 'phone'
                    },
                    {
                        data: 'email'
                    },
                    {
                        data: 'subject'
                    },
                    {
                        data: 'message'
                    },
                    {
                        data: 'actions',
                        orderable: false
                    }
                ],

                order: [1, 'desc'],
                drawCallback: function(settings) {
                    $('.record__select').prop('checked', false);
                    $('#record__select-all').prop('checked', false);
                    $('#record-ids').val();
                    $('#bulk-delete').attr('disabled', true);
                },
                dom: '<"d-flex justify-content-between align-items-center header-actions mx-1 row mt-75"' +
                    '<"col-lg-12 col-xl-6" l>' +
                    '<"col-lg-12 col-xl-6 pl-xl-75 pl-0"<"dt-action-buttons text-xl-right text-lg-left text-md-right text-left d-flex align-items-center justify-content-lg-end align-items-center flex-sm-nowrap flex-wrap mr-1"<"mr-1"f>B>>' +
                    '>t' +
                    '<"d-flex justify-content-between mx-2 row mb-1"' +
                    '<"col-sm-12 col-md-6"i>' +
                    '<"col-sm-12 col-md-6"p>' +
                    '>',
                language: {
                    sLengthMenu: 'Show _MENU_',
                    search: 'بحث',
                    searchPlaceholder: 'بحث..',
                    paginate: {
                        // remove previous & next text from pagination
                        previous: '&nbsp;',
                        next: '&nbsp;'
                    }
                },
                // Buttons with Dropdown
                buttons: [{
                        extend: 'collection',
                        className: 'btn btn-outline-secondary dropdown-toggle mr-2 mt-50',
                        text: feather.icons['share'].toSvg({
                            class: 'font-small-4 mr-50'
                        }) + 'تصدير',
                        buttons: [{
                                extend: 'print',
                                text: feather.icons['printer'].toSvg({
                                    class: 'font-small-4 mr-50'
                                }) + 'طباعة',
                                className: 'dropdown-item',
                                exportOptions: {
                                    columns: [0, 1, 2, 3, 4 ],
                                    modifier: {
                                        selected: true // تصدير الصفوف المحددة فقط
                                    }
                                },
                                customize: function(win) {
                                    $(win.document.body).prepend(
                                        '<h3 style="text-align:center;">الرسائل</h3>'
                                    );
                                    $(win.document.body).find('table')
                                        .addClass('compact')
                                        .css('font-size', '12px');
                                }
                            },
                            {
                                extend: 'excelHtml5',
                                text: feather.icons['file'].toSvg({
                                    class: 'font-small-4 mr-50'
                                }) + 'اكسل',
                                className: 'dropdown-item',
                                exportOptions: {
                                    columns: [0, 1, 2, 3, 4 ]
                                }
                            },
                        ],

                    },

                ],

            });
        });
    </script>
    <script>
        function confirmDelete(messagesId) {
            const form = document.getElementById('deleteorderForm');
            form.action = "<?php echo e(route('message.destroy', ':id')); ?>".replace(':id', messagesId) ;
            const modal = new bootstrap.Modal(document.getElementById('deleteorderModal'));
            modal.show();
        }
    </script>


<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.dash_master', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\tabadul_Irada\resources\views/admin/message/messages.blade.php ENDPATH**/ ?>